/*
 * Decompiled with CFR 0.152.
 */
package ca.weblite.objc;

import ca.weblite.nativeutils.NativeUtils;
import ca.weblite.objc.Message;
import ca.weblite.objc.Peerable;
import ca.weblite.objc.Proxy;
import ca.weblite.objc.Recipient;
import ca.weblite.objc.Runtime;
import ca.weblite.objc.RuntmeArm64Extensions;
import ca.weblite.objc.TypeMapper;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;

public class RuntimeUtils {
    private static final Runtime rt = Runtime.INSTANCE;
    private static boolean isArm64;

    private RuntimeUtils() {
    }

    public static Pointer cls(String name) {
        return rt.objc_lookUpClass(name);
    }

    public static Pointer cls(Peerable peer) {
        return peer.getPeer();
    }

    public static String clsName(Pointer cls) {
        return rt.class_getName(cls);
    }

    public static String clsName(Peerable peer) {
        return RuntimeUtils.clsName(peer.getPeer());
    }

    public static Pointer sel(String name) {
        return rt.sel_getUid(name);
    }

    public static Pointer sel(Peerable peer) {
        return peer.getPeer();
    }

    public static String selName(Pointer sel) {
        return rt.sel_getName(sel);
    }

    public static String selName(Peerable peer) {
        return RuntimeUtils.selName(peer.getPeer());
    }

    public static long msg(String cls, String msg, Object ... args) {
        return RuntimeUtils.msg(RuntimeUtils.cls(cls), msg, args);
    }

    public static long msg(String cls, Pointer msg, Object ... args) {
        return RuntimeUtils.msg(RuntimeUtils.cls(cls), msg, args);
    }

    public static long msg(Pointer receiver, String msg, Object ... args) {
        return RuntimeUtils.objc_msgSend(receiver, RuntimeUtils.sel(msg), args);
    }

    private static String getArgsSuffix(Object ... args) {
        StringBuilder sb = new StringBuilder();
        boolean foundStructByValue = false;
        for (Object o : args) {
            if (o instanceof Structure.ByValue) {
                foundStructByValue = true;
                sb.append("1");
                continue;
            }
            sb.append("0");
        }
        if (foundStructByValue) {
            return sb.toString();
        }
        return "";
    }

    private static Class<?>[] getArgsParamTypes(Object ... args) {
        Class[] out = new Class[args.length + 2];
        out[0] = Pointer.class;
        out[1] = Pointer.class;
        for (int i = 0; i < args.length; ++i) {
            out[i + 2] = args[i] instanceof Structure.ByValue ? Structure.ByValue.class : Object.class;
        }
        return out;
    }

    private static Object[] merge(Pointer receiver, Pointer selector, Object ... args) {
        Object[] out = new Object[args.length + 2];
        out[0] = receiver;
        out[1] = selector;
        for (int i = 0; i < args.length; ++i) {
            out[i + 2] = args[i];
        }
        return out;
    }

    private static long objc_msgSend(Pointer receiver, Pointer selector, Object ... args) {
        String argSuffix = RuntimeUtils.getArgsSuffix(args);
        if (args.length <= 7 && argSuffix.isEmpty()) {
            switch (args.length) {
                case 0: {
                    return rt.objc_msgSend(receiver, selector);
                }
                case 1: {
                    return rt.objc_msgSend(receiver, selector, args[0]);
                }
                case 2: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1]);
                }
                case 3: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1], args[2]);
                }
                case 4: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3]);
                }
                case 5: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4]);
                }
                case 6: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5]);
                }
                case 7: {
                    return rt.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
                }
            }
            throw new IllegalArgumentException("msg currently supports max 4 args");
        }
        try {
            Class<?> runtimeClass = RuntimeUtils.class.getClassLoader().loadClass("ca.weblite.objc.RuntimeMappings$Runtime" + argSuffix);
            Field runtimeInstanceField = runtimeClass.getField("INSTANCE");
            Object runtimeInstance = runtimeInstanceField.get(null);
            return (Long)runtimeClass.getMethod("objc_msgSend", RuntimeUtils.getArgsParamTypes(args)).invoke(runtimeInstance, RuntimeUtils.merge(receiver, selector, args));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long msg(Pointer receiver, Pointer selector, Object ... args) {
        long out = RuntimeUtils.objc_msgSend(receiver, selector, args);
        return out;
    }

    public static Pointer msgPointer(Pointer receiver, Pointer selector, Object ... args) {
        long res = RuntimeUtils.msg(receiver, selector, args);
        return new Pointer(res);
    }

    public static Pointer msgPointer(Pointer receiver, String selector, Object ... args) {
        return RuntimeUtils.msgPointer(receiver, RuntimeUtils.sel(selector), args);
    }

    public static Pointer msgPointer(String receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.msgPointer(RuntimeUtils.cls(receiver), selector, args);
    }

    public static Pointer msgPointer(String receiver, String selector, Object ... args) {
        return RuntimeUtils.msgPointer(RuntimeUtils.cls(receiver), RuntimeUtils.sel(selector), args);
    }

    public static int msgInt(Pointer receiver, Pointer selector, Object ... args) {
        long res = RuntimeUtils.msg(receiver, selector, args);
        return (int)res;
    }

    public static int msgInt(String receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.msgInt(RuntimeUtils.cls(receiver), selector, args);
    }

    public static int msgInt(String receiver, String selector, Object ... args) {
        return RuntimeUtils.msgInt(RuntimeUtils.cls(receiver), RuntimeUtils.sel(selector), args);
    }

    public static int msgInt(Pointer receiver, String selector, Object ... args) {
        return RuntimeUtils.msgInt(receiver, RuntimeUtils.sel(selector), args);
    }

    public static boolean msgBoolean(Pointer receiver, Pointer selector, Object ... args) {
        long res = RuntimeUtils.msg(receiver, selector, args);
        return res > 0L;
    }

    public static boolean msgBoolean(String receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.msgBoolean(RuntimeUtils.cls(receiver), selector, args);
    }

    public static boolean msgBoolean(String receiver, String selector, Object ... args) {
        return RuntimeUtils.msgBoolean(RuntimeUtils.cls(receiver), RuntimeUtils.sel(selector), args);
    }

    public static boolean msgBoolean(Pointer receiver, String selector, Object ... args) {
        return RuntimeUtils.msgBoolean(receiver, RuntimeUtils.sel(selector), args);
    }

    public static String msgString(Pointer receiver, Pointer selector, Object ... args) {
        long res = RuntimeUtils.msg(receiver, selector, args);
        return new Pointer(res).getString(0L);
    }

    public static String msgString(String receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.msgString(RuntimeUtils.cls(receiver), selector, args);
    }

    public static String msgString(String receiver, String selector, Object ... args) {
        return RuntimeUtils.msgString(RuntimeUtils.cls(receiver), RuntimeUtils.sel(selector), args);
    }

    public static String msgString(Pointer receiver, String selector, Object ... args) {
        return RuntimeUtils.msgString(receiver, RuntimeUtils.sel(selector), args);
    }

    public static double msgDouble(Pointer receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.objc_msgSend_fpret(receiver, selector, args);
    }

    private static double objc_msgSend_fpret(Pointer receiver, Pointer selector, Object ... args) {
        if (isArm64) {
            switch (args.length) {
                case 0: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector);
                }
                case 1: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0]);
                }
                case 2: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1]);
                }
                case 3: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1], args[2]);
                }
                case 4: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3]);
                }
                case 5: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4]);
                }
                case 6: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5]);
                }
                case 7: {
                    return RuntmeArm64Extensions.INSTANCE.objc_msgSend(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
                }
            }
            throw new IllegalArgumentException("objc_msgSend does not support " + args.length + " arguments yet");
        }
        switch (args.length) {
            case 0: {
                return rt.objc_msgSend_fpret(receiver, selector);
            }
            case 1: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0]);
            }
            case 2: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1]);
            }
            case 3: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1], args[2]);
            }
            case 4: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return rt.objc_msgSend_fpret(receiver, selector, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        }
        throw new IllegalArgumentException("objc_msgSend_fpret does not support " + args.length + " arguments yet");
    }

    public static double msgDouble(String receiver, Pointer selector, Object ... args) {
        return RuntimeUtils.msgDouble(RuntimeUtils.cls(receiver), selector, args);
    }

    public static double msgDouble(String receiver, String selector, Object ... args) {
        return RuntimeUtils.msgDouble(RuntimeUtils.cls(receiver), RuntimeUtils.sel(selector), args);
    }

    public static double msgDouble(Pointer receiver, String selector, Object ... args) {
        return RuntimeUtils.msgDouble(receiver, RuntimeUtils.sel(selector), args);
    }

    private static void sleep50() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object msg(boolean coerceReturn, boolean coerceArgs, Pointer receiver, Pointer selector, Object ... args) {
        char returnTypeFirstChar;
        Pointer methodSignature = RuntimeUtils.msgPointer(receiver, "methodSignatureForSelector:", selector);
        if (Pointer.nativeValue((Pointer)methodSignature) == 0L) {
            throw new RuntimeException(new NoSuchMethodException("Method cannot be found for signature " + Pointer.nativeValue((Pointer)selector)));
        }
        int numArgs = (int)RuntimeUtils.msg(methodSignature, "numberOfArguments", new Object[0]);
        if (numArgs >= 2 && numArgs != args.length + 2) {
            throw new RuntimeException("Wrong argument count.  The selector " + RuntimeUtils.selName(selector) + " requires " + (numArgs - 2) + " arguments, but received " + args.length);
        }
        long returnTypePtr = RuntimeUtils.msg(methodSignature, "methodReturnType", new Object[0]);
        String returnTypeSignature = new Pointer(returnTypePtr).getString(0L);
        if (numArgs == 0 && returnTypeSignature == null) {
            return RuntimeUtils.msg(receiver, selector, args);
        }
        if (coerceArgs && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                long out2 = RuntimeUtils.msg(methodSignature, "getArgumentTypeAtIndex:", i + 2);
                String argumentTypeSignature = new Pointer(out2).getString(0L);
                args[i] = TypeMapper.getInstance().jToC(args[i], argumentTypeSignature, TypeMapper.getInstance());
            }
        }
        String prefixes = "rnNoORV";
        int offset = 0;
        while (prefixes.indexOf(returnTypeSignature.charAt(offset)) != -1 && ++offset <= returnTypeSignature.length() - 1) {
        }
        if (offset > 0) {
            returnTypeSignature = returnTypeSignature.substring(offset);
        }
        if ("[{(".indexOf(returnTypeFirstChar = returnTypeSignature.charAt(0)) == -1) {
            if ("df".indexOf(returnTypeFirstChar) != -1) {
                Double res = RuntimeUtils.msgDouble(receiver, selector, args);
                for (int i = 0; i < args.length; ++i) {
                    Proxy.release(args[i]);
                }
                return res;
            }
            long result = RuntimeUtils.msg(receiver, selector, args);
            if (coerceReturn) {
                Object res2 = TypeMapper.getInstance().cToJ(result, returnTypeSignature, TypeMapper.getInstance());
                for (int i = 0; i < args.length; ++i) {
                    Proxy.release(args[i]);
                }
                return res2;
            }
            for (int i = 0; i < args.length; ++i) {
                Proxy.release(args[i]);
            }
            return result;
        }
        Long output = RuntimeUtils.msg(receiver, selector, args);
        for (int i = 0; i < args.length; ++i) {
            Proxy.release(args[i]);
        }
        return output;
    }

    public static int arraySize(String signature) {
        int typeIndex = 2;
        String digits = "0123456789";
        while (digits.indexOf(signature.charAt(typeIndex++)) != -1) {
        }
        return Integer.parseInt(signature.substring(1, typeIndex));
    }

    public static Pointer addr(Peerable peer) {
        return peer.getPeer();
    }

    public static Object msg(Message ... messages) {
        int i;
        for (i = 0; i < messages.length; ++i) {
            if (i > 0) {
                messages[i].previous = messages[i - 1];
            }
            if (i >= messages.length - 1) continue;
            messages[i].next = messages[i + 1];
        }
        for (i = 0; i < messages.length; ++i) {
            Message m = messages[i];
            if (m.receiver == Pointer.NULL) {
                m.receiver = (Pointer)m.previous.result;
            }
            m.beforeRequest();
            if (m.status == 1) continue;
            if (m.status == 2) break;
            boolean coerceInput = false;
            boolean coerceOutput = false;
            if (i == messages.length - 1) {
                coerceInput = m.coerceInput;
                coerceOutput = m.coerceOutput;
            }
            try {
                m.result = RuntimeUtils.msg(coerceOutput, coerceInput, m.receiver, m.selector, m.args.toArray());
            }
            catch (Exception ex) {
                m.error = ex;
            }
            m.status = 3;
        }
        if (messages.length > 0) {
            return messages[messages.length - 1].result;
        }
        throw new RuntimeException("Message queue was empty");
    }

    public static Pointer str(String str) {
        return RuntimeUtils.msgPointer("NSString", "stringWithUTF8String:", str);
    }

    public static String str(Pointer str) {
        long ptr = RuntimeUtils.msg(str, "UTF8String", new Object[0]);
        return new Pointer(ptr).getString(0L);
    }

    public static Pointer getAsReference(Object val, String signature) {
        return RuntimeUtils.getAsReferenceWrapper(val, signature).getPointer();
    }

    public static ByReference getAsReferenceWrapper(Object val, String signature) {
        String prefixes = "rnNoORV";
        int offset = 0;
        while (prefixes.indexOf(signature.charAt(offset)) != -1 && ++offset <= signature.length() - 1) {
        }
        if (offset > 0) {
            signature = signature.substring(offset);
        }
        switch (signature.charAt(0)) {
            case 'I': 
            case 'i': {
                int intVal;
                if (val instanceof Number) {
                    intVal = ((Number)val).intValue();
                } else if (val instanceof String) {
                    intVal = Integer.parseInt((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to int: " + val);
                }
                return new IntByReference(intVal);
            }
            case 'S': 
            case 's': {
                short shortVal;
                if (val instanceof Number) {
                    shortVal = ((Number)val).shortValue();
                } else if (val instanceof String) {
                    shortVal = Short.parseShort((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to short: " + val);
                }
                return new ShortByReference(shortVal);
            }
            case 'L': 
            case 'Q': 
            case 'l': 
            case 'q': {
                long longVal;
                if (val instanceof Number) {
                    longVal = ((Number)val).longValue();
                } else if (val instanceof String) {
                    longVal = Long.parseLong((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to long: " + val);
                }
                return new LongByReference(longVal);
            }
            case 'f': {
                float floatVal;
                if (val instanceof Number) {
                    floatVal = ((Number)val).floatValue();
                } else if (val instanceof String) {
                    floatVal = Float.parseFloat((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to float: " + val);
                }
                return new FloatByReference(floatVal);
            }
            case 'd': {
                double doubleVal;
                if (val instanceof Number) {
                    doubleVal = ((Number)val).doubleValue();
                } else if (val instanceof String) {
                    doubleVal = Double.parseDouble((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to double: " + val);
                }
                return new DoubleByReference(doubleVal);
            }
            case 'B': 
            case 'C': 
            case 'b': 
            case 'c': {
                byte byteVal;
                if (val instanceof Boolean) {
                    byteVal = (byte)(Boolean.TRUE.equals(val) ? 1 : 0);
                } else if (val instanceof Number) {
                    byteVal = ((Number)val).byteValue();
                } else if (val instanceof String) {
                    byteVal = Byte.parseByte((String)val);
                } else {
                    throw new RuntimeException("Attempt to pass ineligible value to byte: " + val);
                }
                return new ByteByReference(byteVal);
            }
            case 'v': {
                return null;
            }
        }
        if (val instanceof Pointer) {
            return new PointerByReference((Pointer)val);
        }
        if (val instanceof Long) {
            return new PointerByReference(new Pointer(((Long)val).longValue()));
        }
        throw new RuntimeException("Don't know what to do for conversion of value " + val + " and signature " + signature);
    }

    private static native void init();

    public static native long createProxy(Recipient var0);

    public static native Recipient getJavaPeer(long var0);

    static {
        String libraryPath = "/libjcocoa.dylib";
        try {
            NativeUtils.loadLibraryFromJar(libraryPath);
            RuntimeUtils.init();
        }
        catch (IOException ioException) {
            throw new UncheckedIOException("Failed loading library " + libraryPath, ioException);
        }
        isArm64 = System.getProperty("os.arch").equals("aarch64");
    }
}

