/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.context;

import cd.connect.context.NamedConnectContext;
import cd.connect.jackson.JacksonObjectProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Map;
import org.slf4j.MDC;

public class ConnectContext {
    public static NamedConnectContext requestId = new NamedConnectImpl("request-id");
    public static NamedConnectContext scenarioId = new NamedConnectImpl("scenario-id");
    public static final String JSON_PREFIX = "json:";

    public static void clear() {
        MDC.clear();
    }

    public static void remove(String key) {
        MDC.remove((String)key);
    }

    public static void set(String key, Object value) {
        if (key != null) {
            if (value == null) {
                MDC.remove((String)key);
            } else if ("java.lang".equals(value.getClass().getPackage().getName())) {
                MDC.put((String)key, (String)value.toString());
            } else {
                try {
                    MDC.put((String)(JSON_PREFIX + key), (String)JacksonObjectProvider.mapper.writeValueAsString(value));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String get(String key) {
        String val = MDC.get((String)key);
        if (val == null) {
            val = MDC.get((String)(JSON_PREFIX + key));
        }
        return val;
    }

    public static <T> T get(String key, Class<T> clazz) {
        String val;
        if (key != null && (val = MDC.get((String)(JSON_PREFIX + key))) != null) {
            try {
                return (T)JacksonObjectProvider.mapper.readValue(val, clazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Map<String, String> getContext() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContext(Map<String, String> pushContext) {
        MDC.setContextMap(pushContext);
    }

    static class NamedConnectImpl
    implements NamedConnectContext {
        private final String key;

        NamedConnectImpl(String key) {
            this.key = key;
        }

        @Override
        public String get() {
            return ConnectContext.get(this.key);
        }

        @Override
        public void set(String id) {
            ConnectContext.set(this.key, id);
        }

        @Override
        public void remove() {
            ConnectContext.remove(this.key);
        }
    }
}

