/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.logging;

import cd.connect.logging.JsonLogEnhancer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public class DefaultJsonLogEnhancer
implements JsonLogEnhancer {
    static int prefixLen = "json:".length();
    private final String hostName;

    public DefaultJsonLogEnhancer() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMapPriority() {
        return 100;
    }

    @Override
    public void map(Map<String, String> context, Map<String, Object> log, List<String> alreadyEncodedJsonObjects) {
        log.put("host", this.hostName);
        context.entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith("json:")) {
                alreadyEncodedJsonObjects.add("\"" + ((String)entry.getKey()).substring(prefixLen) + "\":" + (String)entry.getValue());
            } else {
                log.put((String)entry.getKey(), entry.getValue());
            }
        });
    }

    @Override
    public void failed(Map<String, String> context, Map<String, Object> log, List<String> alreadyEncodedJsonObjects, Throwable e) {
    }
}

