/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CustomList<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 10;
    private T[] items;
    private int size;

    public CustomList() {
        this(10);
    }

    public CustomList(int initialCapacity) {
        int cap = Math.max(1, initialCapacity);
        this.items = new Object[cap];
        this.size = 0;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.items == null) {
            this.items = new Object[Math.max(10, minCapacity)];
            return;
        }
        if (minCapacity <= this.items.length) {
            return;
        }
        int newCapacity = Math.max(this.items.length * 2, minCapacity);
        Object[] newItems = new Object[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        this.items = newItems;
    }

    public int getCapacity() {
        return this.items.length;
    }

    public void add(T item) {
        this.ensureCapacity(this.size + 1);
        this.items[this.size++] = item;
    }

    public void add(int index, T item) {
        this.checkPositionIndex(index);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.items, index, this.items, index + 1, this.size - index);
        this.items[index] = item;
        ++this.size;
    }

    public T get(int index) {
        this.checkElementIndex(index);
        return this.items[index];
    }

    public T get(T item) {
        int idx = this.indexOf(item);
        if (idx == -1) {
            return null;
        }
        return this.items[idx];
    }

    public T set(int index, T item) {
        this.checkElementIndex(index);
        T old = this.items[index];
        this.items[index] = item;
        return old;
    }

    public T remove(int index) {
        this.checkElementIndex(index);
        T old = this.items[index];
        int moved = this.size - index - 1;
        if (moved > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, moved);
        }
        this.items[--this.size] = null;
        return old;
    }

    public boolean remove(T item) {
        int idx = this.indexOf(item);
        if (idx == -1) {
            return false;
        }
        this.remove(idx);
        return true;
    }

    public boolean contains(T item) {
        return this.indexOf(item) >= 0;
    }

    public int indexOf(T item) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.items[i], item)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(T item) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(this.items[i], item)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = 0;
    }

    public void trimToSize() {
        if (this.items.length == this.size) {
            return;
        }
        Object[] newItems = new Object[Math.max(this.size, 1)];
        System.arraycopy(this.items, 0, newItems, 0, this.size);
        this.items = newItems;
    }

    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        System.arraycopy(this.items, 0, arr, 0, this.size);
        return arr;
    }

    public T[] toArray(T[] a) {
        if (a.length < this.size) {
            Object[] r = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            System.arraycopy(this.items, 0, r, 0, this.size);
            return r;
        }
        System.arraycopy(this.items, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Itr();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.items[i]);
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void checkElementIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void checkPositionIndex(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private class Itr
    implements Iterator<T> {
        private int cursor = 0;
        private int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CustomList.this.size;
        }

        @Override
        public T next() {
            if (this.cursor >= CustomList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor++;
            return CustomList.this.items[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            CustomList.this.remove(this.lastRet);
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }
    }
}

