/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.CacheEntry;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private final int maxSize;
    private final long defaultTtlMillis;
    private final Map<K, CacheEntry<V>> map;

    public LRUCache(int maxSize) {
        this(maxSize, 0L);
    }

    public LRUCache(int maxSize, long defaultTtlMillis) {
        this.maxSize = Math.max(1, maxSize);
        this.defaultTtlMillis = defaultTtlMillis;
        this.map = Collections.synchronizedMap(new LinkedHashMap<K, CacheEntry<V>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> eldest) {
                return this.size() > LRUCache.this.maxSize;
            }
        });
    }

    public void put(K key, V value) {
        this.put(key, value, this.defaultTtlMillis);
    }

    public void put(K key, V value, long ttlMillis) {
        long expiry = ttlMillis > 0L ? System.currentTimeMillis() + ttlMillis : Long.MAX_VALUE;
        this.map.put(key, new CacheEntry<V>(value, expiry));
    }

    public V get(K key) {
        CacheEntry<V> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            this.map.remove(key);
            return null;
        }
        return entry.getValue();
    }

    public V remove(K key) {
        CacheEntry<V> e = this.map.remove(key);
        return e == null ? null : (V)e.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, CacheEntry<V>> map = this.map;
        synchronized (map) {
            Iterator<Map.Entry<K, CacheEntry<V>>> it = this.map.entrySet().iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry<K, CacheEntry<V>> ent = it.next();
                if (ent.getValue().isExpired()) {
                    it.remove();
                    continue;
                }
                ++count;
            }
            return count;
        }
    }

    public void clear() {
        this.map.clear();
    }
}

