/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterUtils {
    public static List<String> filterContainsIgnoreCase(List<String> list, String query) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>(list);
        }
        String q = query.toLowerCase(Locale.ROOT);
        return list.stream().filter(Objects::nonNull).filter(s -> s.toLowerCase(Locale.ROOT).contains(q)).collect(Collectors.toList());
    }

    public static List<String> filterStartsWithIgnoreCase(List<String> list, String query) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>(list);
        }
        String q = query.toLowerCase(Locale.ROOT);
        return list.stream().filter(Objects::nonNull).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(q)).collect(Collectors.toList());
    }

    public static List<String> filterEndsWithIgnoreCase(List<String> list, String query) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>(list);
        }
        String q = query.toLowerCase(Locale.ROOT);
        return list.stream().filter(Objects::nonNull).filter(s -> s.toLowerCase(Locale.ROOT).endsWith(q)).collect(Collectors.toList());
    }

    public static List<String> filterExactMatchIgnoreCase(List<String> list, String query) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>(list);
        }
        String q = query.toLowerCase(Locale.ROOT);
        return list.stream().filter(Objects::nonNull).filter(s -> s.toLowerCase(Locale.ROOT).equals(q)).collect(Collectors.toList());
    }

    public static List<String> filterByLength(List<String> list, int length) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (length < 0) {
            return new ArrayList<String>(list);
        }
        return list.stream().filter(Objects::nonNull).filter(s -> s.length() == length).collect(Collectors.toList());
    }

    public static List<String> filterByRegex(List<String> list, String regex) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (regex == null || regex.isEmpty()) {
            return new ArrayList<String>(list);
        }
        return list.stream().filter(Objects::nonNull).filter(s -> s.matches(regex)).collect(Collectors.toList());
    }

    public static List<Integer> filterEvenNumbers(List<Integer> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n % 2 == 0).collect(Collectors.toList());
    }

    public static List<Integer> filterOddNumbers(List<Integer> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n % 2 != 0).collect(Collectors.toList());
    }

    public static List<Integer> filterGreaterThan(List<Integer> list, int threshold) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n > threshold).collect(Collectors.toList());
    }

    public static List<Integer> filterLessThan(List<Integer> list, int threshold) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n < threshold).collect(Collectors.toList());
    }

    public static List<Integer> filterBetween(List<Integer> list, int lower, int upper) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n >= lower && n <= upper).collect(Collectors.toList());
    }

    public static List<Integer> filterByDivisibility(List<Integer> list, int divisor) {
        if (list == null || divisor == 0) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n % divisor == 0).collect(Collectors.toList());
    }

    public static List<Integer> filterByDigitCount(List<Integer> list, int digitCount) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (digitCount < 0) {
            return new ArrayList<Integer>(list);
        }
        return list.stream().filter(Objects::nonNull).filter(n -> Integer.toString(Math.abs(n)).length() == digitCount).collect(Collectors.toList());
    }

    public static List<Integer> filterByRange(List<Integer> list, int min, int max) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n >= min && n <= max).collect(Collectors.toList());
    }

    public static List<Integer> filterEqualTo(List<Integer> list, int value) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n == value).collect(Collectors.toList());
    }

    public static List<Integer> filterNotEqualTo(List<Integer> list, int value) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n != value).collect(Collectors.toList());
    }

    public static List<Integer> filterByLastDigit(List<Integer> list, int lastDigit) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (lastDigit < 0 || lastDigit > 9) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> Math.abs(n % 10) == lastDigit).collect(Collectors.toList());
    }

    public static List<Integer> filterByFirstDigit(List<Integer> list, int firstDigit) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (firstDigit < 0 || firstDigit > 9) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> {
            int num;
            for (num = Math.abs(n); num >= 10; num /= 10) {
            }
            return num == firstDigit;
        }).collect(Collectors.toList());
    }

    public static List<Integer> filterByMultipleOf(List<Integer> list, int multiple) {
        if (list == null || multiple == 0) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).filter(n -> n % multiple == 0).collect(Collectors.toList());
    }
}

