/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.models.IsoTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public abstract class HistoryStorage
extends SynchronizationListener {
    protected Set<String> orderSynchronizationFinished = new HashSet<String>();
    protected Set<String> dealSynchronizationFinished = new HashSet<String>();

    public abstract CompletableFuture<Void> initialize();

    public abstract List<MetatraderDeal> getDeals();

    public abstract List<MetatraderOrder> getHistoryOrders();

    public abstract Map<String, Long> getLastDealTimeByInstanceIndex();

    public abstract Map<String, Long> getLastHistoryOrderTimeByInstanceIndex();

    public abstract CompletableFuture<Void> loadData();

    public abstract CompletableFuture<Void> updateStorage();

    public boolean isOrderSynchronizationFinished() {
        return !this.orderSynchronizationFinished.isEmpty();
    }

    public boolean isDealSynchronizationFinished() {
        return !this.dealSynchronizationFinished.isEmpty();
    }

    public abstract CompletableFuture<Void> clear();

    public CompletableFuture<IsoTime> getLastHistoryOrderTime() {
        return this.getLastHistoryOrderTime(null);
    }

    public abstract CompletableFuture<IsoTime> getLastHistoryOrderTime(Integer var1);

    public CompletableFuture<IsoTime> getLastDealTime() {
        return this.getLastDealTime(null);
    }

    public abstract CompletableFuture<IsoTime> getLastDealTime(Integer var1);

    @Override
    public abstract CompletableFuture<Void> onHistoryOrderAdded(String var1, MetatraderOrder var2);

    @Override
    public abstract CompletableFuture<Void> onDealAdded(String var1, MetatraderDeal var2);

    @Override
    public CompletableFuture<Void> onDealSynchronizationFinished(String instanceIndex, String synchronizationId) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        this.dealSynchronizationFinished.add("" + instance);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderSynchronizationFinished(String instanceIndex, String synchronizationId) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        this.orderSynchronizationFinished.add("" + instance);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onConnected(String instanceIndex, int replicas) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        this.orderSynchronizationFinished.remove("" + instance);
        this.dealSynchronizationFinished.remove("" + instance);
        return CompletableFuture.completedFuture(null);
    }
}

