/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.ProvisioningProfileClient;
import cloud.metaapi.sdk.clients.meta_api.models.NewProvisioningProfileDto;
import cloud.metaapi.sdk.clients.meta_api.models.ProvisioningProfileDto;
import cloud.metaapi.sdk.meta_api.ProvisioningProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ProvisioningProfileApi {
    private ProvisioningProfileClient provisioningProfileClient;

    public ProvisioningProfileApi(ProvisioningProfileClient provisioningProfileClient) {
        this.provisioningProfileClient = provisioningProfileClient;
    }

    public CompletableFuture<List<ProvisioningProfile>> getProvisioningProfiles() {
        return this.getProvisioningProfiles(null, null);
    }

    public CompletableFuture<List<ProvisioningProfile>> getProvisioningProfiles(Integer version, String status) {
        return this.provisioningProfileClient.getProvisioningProfiles(version, status).thenApply(profiles -> {
            ArrayList result = new ArrayList();
            profiles.forEach(profileDto -> result.add(new ProvisioningProfile((ProvisioningProfileDto)profileDto, this.provisioningProfileClient)));
            return result;
        });
    }

    public CompletableFuture<ProvisioningProfile> getProvisioningProfile(String provisioningProfileId) {
        return this.provisioningProfileClient.getProvisioningProfile(provisioningProfileId).thenApply(profile -> new ProvisioningProfile((ProvisioningProfileDto)profile, this.provisioningProfileClient));
    }

    public CompletableFuture<ProvisioningProfile> createProvisioningProfile(NewProvisioningProfileDto profile) {
        return this.provisioningProfileClient.createProvisioningProfile(profile).thenApply(id -> {
            ProvisioningProfileDto createdProfile = new ProvisioningProfileDto();
            createdProfile._id = id.id;
            createdProfile.status = "new";
            createdProfile.name = profile.name;
            createdProfile.version = profile.version;
            createdProfile.brokerTimezone = profile.brokerTimezone;
            createdProfile.brokerDSTSwitchTimezone = profile.brokerDSTSwitchTimezone;
            return new ProvisioningProfile(createdProfile, this.provisioningProfileClient);
        });
    }
}

