/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class Async {
    private static ExecutorService executor = null;

    public static ExecutorService getExecutor() {
        if (executor == null) {
            executor = Executors.newCachedThreadPool();
        }
        return executor;
    }

    public static void shutdownExecutor() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    public static CompletableFuture<Void> run(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, Async.getExecutor());
    }

    public static <U> CompletableFuture<U> supply(Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(supplier, Async.getExecutor());
    }
}

