/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.business;

import cn.authing.core.http.Call;
import cn.authing.core.http.Callback;
import cn.authing.core.result.ErrorInfo;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

class NormalCall<ResultType>
implements Call<ResultType> {
    private final Request request;
    private final Call.Factory callFactory;
    private final TypeAdapter<ResultType> adapter;
    private volatile boolean canceled;
    @Nullable
    @GuardedBy(value="this")
    private okhttp3.Call rawCall;
    @Nullable
    @GuardedBy(value="this")
    private Throwable creationFailure;
    @GuardedBy(value="this")
    private boolean executed;

    public NormalCall(Request request, Call.Factory callFactory, TypeAdapter<ResultType> adapter) {
        this.request = request;
        this.callFactory = callFactory;
        this.adapter = adapter;
    }

    @Override
    public synchronized Request request() {
        okhttp3.Call call = this.rawCall;
        if (call != null) {
            return call.request();
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw new RuntimeException("Unable to create request.", this.creationFailure);
            }
            if (this.creationFailure instanceof RuntimeException) {
                throw (RuntimeException)this.creationFailure;
            }
            throw (Error)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall.request();
        }
        catch (Error | RuntimeException e) {
            this.throwIfFatal(e);
            this.creationFailure = e;
            throw e;
        }
        catch (IOException e) {
            this.creationFailure = e;
            throw new RuntimeException("Unable to create request.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final @Nonnull Callback<ResultType> callback) {
        Throwable failure;
        okhttp3.Call call;
        NormalCall normalCall = this;
        synchronized (normalCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall;
            failure = this.creationFailure;
            if (call == null && failure == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (Throwable t) {
                    this.throwIfFatal(t);
                    failure = this.creationFailure = t;
                }
            }
        }
        if (failure != null) {
            callback.onFailure(ErrorInfo.generate(1, failure.getLocalizedMessage()));
            return;
        }
        if (this.canceled) {
            call.cancel();
        }
        call.enqueue(new okhttp3.Callback(){

            public void onResponse(okhttp3.Call call, Response rawResponse) {
                if (!rawResponse.isSuccessful()) {
                    String errMsg = null;
                    try {
                        errMsg = rawResponse.body().string();
                    }
                    catch (IOException e) {
                        errMsg = rawResponse.message();
                    }
                    callback.onFailure(ErrorInfo.generate(rawResponse.code(), errMsg));
                } else {
                    callback.onSuccess(NormalCall.this.parseResponse(rawResponse));
                }
            }

            public void onFailure(okhttp3.Call call, IOException e) {
                e.printStackTrace();
                callback.onFailure(ErrorInfo.generate(1, e.getLocalizedMessage()));
            }
        });
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultType execute() throws IOException {
        Response response;
        okhttp3.Call call;
        NormalCall normalCall = this;
        synchronized (normalCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            if (this.creationFailure != null) {
                if (this.creationFailure instanceof IOException) {
                    throw (IOException)this.creationFailure;
                }
                if (this.creationFailure instanceof RuntimeException) {
                    throw (RuntimeException)this.creationFailure;
                }
                throw (Error)this.creationFailure;
            }
            call = this.rawCall;
            if (call == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (IOException | Error | RuntimeException e) {
                    this.throwIfFatal(e);
                    this.creationFailure = e;
                    throw e;
                }
            }
        }
        if (this.canceled) {
            call.cancel();
        }
        return (response = call.execute()).isSuccessful() ? (ResultType)this.parseResponse(response) : null;
    }

    private okhttp3.Call createRawCall() throws IOException {
        okhttp3.Call call = this.callFactory.newCall(this.request);
        if (call == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return call;
    }

    private ResultType parseResponse(Response rawResponse) {
        if (rawResponse.body() == null) {
            return null;
        }
        Object result = null;
        try {
            result = this.adapter.fromJson(rawResponse.body().charStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ResultType)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        okhttp3.Call call;
        this.canceled = true;
        NormalCall normalCall = this;
        synchronized (normalCall) {
            call = this.rawCall;
        }
        if (call != null) {
            call.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        NormalCall normalCall = this;
        synchronized (normalCall) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }

    private void throwIfFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }
}

