/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.param;

import java.util.HashMap;
import java.util.Map;

public class LoginByOidcParam {
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_PHONE = "phone";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_UNION_ID = "unionid";
    private static final String KEY_PSD = "password";
    private Map<String, String> params = new HashMap<String, String>();

    LoginByOidcParam(Builder builder) {
        this.params.put(KEY_CLIENT_ID, builder.clientId);
        this.params.put(KEY_CLIENT_SECRET, builder.secret);
        this.params.put(KEY_GRANT_TYPE, builder.grantType);
        this.params.put(KEY_SCOPE, builder.scope);
        if (builder.initFlag == 1) {
            this.params.put(KEY_UNION_ID, builder.unionId);
        } else if (builder.initFlag == 2) {
            this.params.put(KEY_EMAIL, builder.email);
            this.params.put(KEY_PSD, builder.psd);
        } else if (builder.initFlag == 3) {
            this.params.put(KEY_PHONE, builder.phone);
            this.params.put(KEY_PSD, builder.psd);
        } else if (builder.initFlag == 4) {
            this.params.put(KEY_USERNAME, builder.username);
            this.params.put(KEY_PSD, builder.psd);
        }
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static class Builder {
        private String clientId;
        private String secret;
        private String scope = "openid profile email phone offline_access";
        private String grantType = "password";
        private String email;
        private String phone;
        private String username;
        private String unionId;
        private String psd;
        private int initFlag;

        public Builder(String oidcClientId, String oidcClientSecret) {
            this.clientId = oidcClientId;
            this.secret = oidcClientSecret;
        }

        public Builder initWithUnionId(String unionId) {
            if (this.initFlag > 0) {
                return this;
            }
            this.unionId = unionId;
            this.initFlag = 1;
            return this;
        }

        public Builder initWithEmail(String email, String psd) {
            if (this.initFlag > 0) {
                return this;
            }
            this.email = email;
            this.psd = psd;
            this.initFlag = 2;
            return this;
        }

        public Builder initWithPhone(String phone, String psd) {
            if (this.initFlag > 0) {
                return this;
            }
            this.phone = phone;
            this.psd = psd;
            this.initFlag = 3;
            return this;
        }

        public Builder initWithUsername(String username, String psd) {
            if (this.initFlag > 0) {
                return this;
            }
            this.username = username;
            this.psd = psd;
            this.initFlag = 4;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public LoginByOidcParam build() throws Exception {
            if (this.initFlag <= 0) {
                throw new Exception("please init first");
            }
            return new LoginByOidcParam(this);
        }
    }
}

