/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCEumeration;
import cn.beecloud.BCPayResult;
import cn.beecloud.BCQueryResult;
import cn.beecloud.BCQueryStatusResult;
import cn.beecloud.StrUtil;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ValidationUtil {
    private static final String BILL_NO_FORMAT_INVALID = "bill_no \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String BILL_NO_EMPTY = "bill_no \u5fc5\u586b\uff01";
    private static final String TITLE_EMPTY = "title \u5fc5\u586b\uff01";
    private static final String RETURN_URL_EMPTY = "return_url \u5fc5\u586b\uff01";
    private static final String REFUND_NO_EMPTY = "refund_no \u5fc5\u586b\uff01";
    private static final String CHANNEL_EMPTY = "channel \u5fc5\u586b\uff01";
    private static final String REFUND_NO_FORMAT_INVALID = "refund_no \u662f\u683c\u5f0f\u4e3a\u5f53\u524d\u65e5\u671f\u52a03-24\u4f4d\u6570\u5b57\u5b57\u6bcd\uff08\u4e0d\u80fd\u4e3a000\uff09\u6d41\u6c34\u53f7\u7684\u5b57\u7b26\u4e32\uff01 ";
    private static final String TITLE_FORMAT_INVALID = "title \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u8282\u7684\u5b57\u7b26\u4e32\uff01";
    private static final String LIMIT_FORMAT_INVALID = "limit \u7684\u6700\u5927\u957f\u5ea6\u4e3a50\uff01";
    private static final String OPENID_EMPTY = "openid \u5fc5\u586b\uff01";
    private static final String CHANNEL_INVALID_FOR_REFUND = "\u9000\u6b3e\u53ea\u652f\u6301WX, UN, ALI !";
    static final String PRE_REFUND_SUCCEED = "\u9884\u9000\u6b3e\u6210\u529f\uff01 ";
    static final String REFUND_REJECT = "\u9000\u6b3e\u88ab\u62d2\u7edd\uff01 ";
    static final String REFUND_ACCEPT = "\u9000\u6b3e\u88ab\u540c\u610f\uff01 ";

    public static BCPayResult validateResultFromBackend(Map<String, Object> ret) {
        BCPayResult bcPayResult = new BCPayResult();
        bcPayResult.setErrMsg(ret.get("errMsg").toString());
        bcPayResult.setErrDetail(ret.get("err_detail").toString());
        bcPayResult.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        return bcPayResult;
    }

    public static BCPayResult validateBCPay(BCEumeration.PAY_CHANNEL channel, String billNo, String title, String returnUrl, String openId) {
        block9: {
            if (channel == null) {
                return new BCPayResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(billNo)) {
                return new BCPayResult(BILL_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (!billNo.matches("[0-9A-Za-z]{1,32}")) {
                return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(title)) {
                return new BCPayResult(TITLE_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(returnUrl) && (channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB))) {
                return new BCPayResult(RETURN_URL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI) && StrUtil.empty(openId)) {
                return new BCPayResult(OPENID_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            try {
                if (title.getBytes("GBK").length > 32) {
                    return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (title.length() <= 16) break block9;
                return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCPayResult validateBCRefund(BCEumeration.PAY_CHANNEL channel, String refundNo, String billNo) {
        if (channel == null) {
            return new BCPayResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!(channel.equals((Object)BCEumeration.PAY_CHANNEL.WX) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI) || channel.equals((Object)BCEumeration.PAY_CHANNEL.UN))) {
            return new BCPayResult(CHANNEL_INVALID_FOR_REFUND, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (StrUtil.empty(refundNo)) {
            return new BCPayResult(REFUND_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!refundNo.startsWith(new SimpleDateFormat("yyyyMMdd").format(new Date()))) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!refundNo.substring(8, refundNo.length()).matches("[0-9A-Za-z]{3,24}") || refundNo.substring(8, refundNo.length()).matches("000")) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (StrUtil.empty(billNo)) {
            return new BCPayResult(BILL_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!billNo.matches("[0-9A-Za-z]{1,32}")) {
            return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryBill(BCEumeration.PAY_CHANNEL channel, String billNo, Integer limit) {
        if (channel == null) {
            return new BCQueryResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!StrUtil.empty(billNo) && !billNo.matches("[0-9A-Za-z]{1,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (limit != null && limit > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryRefund(BCEumeration.PAY_CHANNEL channel, String billNo, String refundNo, Integer limit) {
        if (channel == null) {
            return new BCQueryResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!StrUtil.empty(billNo) && !billNo.matches("[0-9A-Za-z]{1,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!(StrUtil.empty(refundNo) || refundNo.substring(8, refundNo.length()).matches("[0-9A-Za-z]{3,24}") && !refundNo.substring(8, refundNo.length()).matches("000"))) {
            return new BCQueryResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (limit != null && limit > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryStatusResult validateQueryRefundStatus(String refundNo) {
        if (StrUtil.empty(refundNo)) {
            return new BCQueryStatusResult(REFUND_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryStatusResult(BCEumeration.RESULT_TYPE.OK);
    }
}

