/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCAPIClient;
import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCPayResult;
import cn.beecloud.BCQueryResult;
import cn.beecloud.BCQueryStatusResult;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.MD5;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.BCOrderBean;
import cn.beecloud.bean.BCPayParameter;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefundBean;
import cn.beecloud.bean.BCRefundParameter;
import cn.beecloud.bean.BCRefundQueryParameter;
import cn.beecloud.bean.TransferData;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class BCPay {
    public static BCPayResult startBCPay(BCPayParameter para) {
        BCPayResult result = ValidationUtil.validateBCPay(para);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildPayParam(param, para);
        result = new BCPayResult();
        BCEumeration.PAY_CHANNEL channel = para.getChannel();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiPay());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setObjectId(ret.get("id").toString());
                    if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_NATIVE)) {
                        if (ret.containsKey("code_url") && null != ret.get("code_url")) {
                            result.setCodeUrl(ret.get("code_url").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI)) {
                        result.setType(BCEumeration.RESULT_TYPE.OK);
                        result.setWxJSAPIMap(BCPay.generateWXJSAPIMap(ret));
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WAP)) {
                        if (ret.containsKey("html") && null != ret.get("html") && ret.containsKey("url") && null != ret.get("url")) {
                            result.setHtml(ret.get("html").toString());
                            result.setUrl(ret.get("url").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.JD_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.JD_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN_WEB)) {
                        if (ret.containsKey("html") && null != ret.get("html")) {
                            result.setHtml(ret.get("html").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.BD_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.BD_WAP)) {
                        if (ret.containsKey("url") && null != ret.get("url")) {
                            result.setUrl(ret.get("url").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
                        result.setSucessMsg("\u652f\u4ed8\u6210\u529f\uff01 ");
                        result.setType(BCEumeration.RESULT_TYPE.OK);
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCPayResult startBCRefund(BCRefundParameter para) {
        BCPayResult result = ValidationUtil.validateBCRefund(para);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildRefundParam(para, param);
        result = new BCPayResult();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiRefund());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setObjectId(ret.get("id").toString());
                    if (ret.containsKey("url")) {
                        result.setUrl(ret.get("url").toString());
                    }
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    result.setSucessMsg("\u9000\u6b3e\u5df2\u7ecf\u6210\u529f\uff01 ");
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCQueryResult startQueryBill(BCQueryParameter para) {
        BCQueryResult result = ValidationUtil.validateQueryBill(para);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryParam(param, para);
        result = new BCQueryResult();
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryBill());
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("bills") && !StrUtil.empty(ret.get("bills"))) {
                        result.setBcOrders(BCPay.generateBCOrderList((List)ret.get("bills")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCQueryResult startQueryBillById(String objectId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        BCQueryResult result = new BCQueryResult();
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryBillById());
        try {
            sb.append("/" + objectId);
            sb.append("?para=");
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("pay") && ret.get("pay") != null) {
                        result.setOrder(BCPay.generateBCOrder((Map)ret.get("pay")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCQueryResult startQueryRefund(BCRefundQueryParameter para) {
        BCQueryResult result = ValidationUtil.validateQueryRefund(para);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        result = new BCQueryResult();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        BCPay.buildQueryParam(param, para);
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryRefund());
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("refunds") && ret.get("refunds") != null) {
                        result.setBcRefundList(BCPay.generateBCRefundList((List)ret.get("refunds")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCQueryResult startQueryRefundById(String objectId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        BCQueryResult result = new BCQueryResult();
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryRefundById());
        try {
            sb.append("/" + objectId);
            sb.append("?para=");
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("refund") && ret.get("refund") != null) {
                        result.setRefund(BCPay.generateBCRefund((Map)ret.get("refund")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCQueryStatusResult startRefundUpdate(BCEumeration.PAY_CHANNEL channel, String refundNo) {
        BCQueryStatusResult result = ValidationUtil.validateQueryRefundStatus(refundNo);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", channel.toString());
        param.put("refund_no", refundNo);
        result = new BCQueryStatusResult();
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiRefundUpdate());
        Client client = BCAPIClient.client;
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setRefundStatus(ret.get("refund_status").toString());
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static BCPayResult startTransfer(BCEumeration.PAY_CHANNEL channel, String batchNo, String accountName, List<TransferData> transferData) {
        BCPayResult result = ValidationUtil.validateBCTransfer(channel, batchNo, accountName, transferData);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", channel.toString());
        param.put("batch_no", batchNo);
        param.put("account_name", accountName);
        ArrayList transferList = new ArrayList();
        for (TransferData data : transferData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("transfer_id", data.getTransferId());
            map.put("receiver_account", data.getReceiverAccount());
            map.put("receiver_name", data.getReceiverName());
            map.put("transfer_fee", data.getTransferFee());
            map.put("transfer_note", data.getTransferNote());
            transferList.add(map);
        }
        param.put("transfer_data", transferList);
        result = new BCPayResult();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiTransfer());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setUrl(ret.get("url").toString());
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public static boolean verifySign(String sign, String timestamp) {
        String mySign = MD5.sign(BCCache.getAppID() + BCCache.getAppSecret(), timestamp, "UTF-8");
        return sign.equals(mySign);
    }

    private static void buildPayParam(Map<String, Object> param, BCPayParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", para.getChannel().toString());
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        if (para.getReturnUrl() != null) {
            param.put("return_url", para.getReturnUrl());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
        if (para.getOpenId() != null) {
            param.put("openid", para.getOpenId());
        }
        if (para.getShowUrl() != null) {
            param.put("show_url", para.getShowUrl());
        }
        if (para.getQrPayMode() != null) {
            if (para.getQrPayMode().ordinal() == 2) {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal() + 1));
            } else {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal()));
            }
        }
        if (para.getBillTimeout() != null) {
            param.put("bill_timeout", para.getBillTimeout());
        }
        if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
            param.put("cardno", para.getCardNo());
            param.put("cardpwd", para.getCardPwd());
            param.put("frqid", para.getFrqid());
        }
    }

    private static void buildRefundParam(BCRefundParameter para, Map<String, Object> param) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        param.put("refund_no", para.getRefundNo());
        param.put("bill_no", para.getBillNo());
        param.put("refund_fee", para.getRefundFee());
        if (para.getChannel() != null) {
            param.put("channel", para.getChannel().toString());
        }
        if (para.getNeedApproval() != null) {
            param.put("need_approval", para.getNeedApproval());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
    }

    private static void buildQueryParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(param.get("timestamp").toString()));
        if (para.getChannel() != null) {
            param.put("channel", para.getChannel().toString());
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getSkip() != null) {
            param.put("skip", para.getSkip());
        }
        if (para.getLimit() != null) {
            param.put("limit", para.getLimit());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
    }

    private static List<BCOrderBean> generateBCOrderList(List<Map<String, Object>> bills) {
        ArrayList<BCOrderBean> bcOrderList = new ArrayList<BCOrderBean>();
        for (Map<String, Object> bill : bills) {
            BCOrderBean bcOrder = new BCOrderBean();
            bcOrder.setBillNo(bill.get("bill_no").toString());
            bcOrder.setTotalFee(bill.get("total_fee").toString());
            bcOrder.setTitle(bill.get("title").toString());
            bcOrder.setChannel(bill.get("channel").toString());
            bcOrder.setSpayResult((Boolean)bill.get("spay_result"));
            bcOrder.setCreatedTime((Long)bill.get("created_time"));
            bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("created_time")));
            bcOrderList.add(bcOrder);
        }
        return bcOrderList;
    }

    private static List<BCRefundBean> generateBCRefundList(List<Map<String, Object>> refundList) {
        ArrayList<BCRefundBean> bcRefundList = new ArrayList<BCRefundBean>();
        for (Map<String, Object> refund : refundList) {
            BCRefundBean bcRefund = new BCRefundBean();
            bcRefund.setBillNo(refund.get("bill_no").toString());
            bcRefund.setRefundNo(refund.get("refund_no").toString());
            bcRefund.setTotalFee(refund.get("total_fee").toString());
            bcRefund.setRefundFee(refund.get("refund_fee").toString());
            bcRefund.setChannel(refund.get("channel").toString());
            bcRefund.setFinished((Boolean)refund.get("finish"));
            bcRefund.setRefunded((Boolean)refund.get("result"));
            bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("created_time")));
            bcRefundList.add(bcRefund);
        }
        return bcRefundList;
    }

    private static Map<String, Object> generateWXJSAPIMap(Map<String, Object> ret) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", ret.get("app_id"));
        map.put("package", ret.get("package"));
        map.put("nonceStr", ret.get("nonce_str"));
        map.put("timeStamp", ret.get("timestamp"));
        map.put("paySign", ret.get("pay_sign"));
        map.put("signType", ret.get("sign_type"));
        return map;
    }

    private static BCOrderBean generateBCOrder(Map<String, Object> bill) {
        BCOrderBean bcOrder = new BCOrderBean();
        bcOrder.setBillNo(bill.get("bill_no").toString());
        bcOrder.setTotalFee(bill.get("total_fee").toString());
        bcOrder.setTitle(bill.get("title").toString());
        bcOrder.setChannel(bill.get("channel").toString());
        bcOrder.setSpayResult((Boolean)bill.get("spay_result"));
        bcOrder.setSubChannel(bill.get("sub_channel").toString());
        bcOrder.setCreatedTime((Long)bill.get("createdat"));
        bcOrder.setUpdateTime((Long)bill.get("updatedat"));
        if (bill.containsKey("channel_trade_no") && bill.get("channel_trade_no") != null) {
            bcOrder.setChannelTradeNo(bill.get("channel_trade_no").toString());
        }
        bcOrder.setOptional(bill.get("optional").toString());
        bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("createdat")));
        bcOrder.setUpdateDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("updatedat")));
        return bcOrder;
    }

    private static BCRefundBean generateBCRefund(Map<String, Object> refund) {
        BCRefundBean bcRefund = new BCRefundBean();
        bcRefund.setBillNo(refund.get("bill_no").toString());
        bcRefund.setChannel(refund.get("channel").toString());
        bcRefund.setSubChannel(refund.get("sub_channel").toString());
        bcRefund.setFinished((Boolean)refund.get("finish"));
        bcRefund.setCreatedTime((Long)refund.get("createdat"));
        bcRefund.setUpdatedTime((Long)refund.get("updatedat"));
        bcRefund.setOptional(refund.get("optional").toString());
        bcRefund.setRefunded((Boolean)refund.get("result"));
        bcRefund.setTitle(refund.get("title").toString());
        bcRefund.setTotalFee(refund.get("total_fee").toString());
        bcRefund.setRefundFee(refund.get("refund_fee").toString());
        bcRefund.setRefundNo(refund.get("refund_no").toString());
        bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("createdat")));
        bcRefund.setUpdateDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("updatedat")));
        return bcRefund;
    }
}

