/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCAPIClient;
import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCPayResult;
import cn.beecloud.BCQueryResult;
import cn.beecloud.BCQueryStatusResult;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.MD5;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.BCOrderBean;
import cn.beecloud.bean.BCRefundBean;
import cn.beecloud.bean.TransferData;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class BCPayMultiApp {
    private String appId;
    private String appSecret;

    private String getAppSignature(String timeStamp) {
        String str = this.appId + timeStamp + this.appSecret;
        return BCUtilPrivate.getMessageDigest(str);
    }

    public BCPayMultiApp(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public BCPayResult startBCPay(BCEumeration.PAY_CHANNEL channel, int totalFee, String billNo, String title, Map<String, String> optional, String returnUrl, String openId, String showUrl, BCEumeration.QR_PAY_MODE qrPayMode) {
        BCPayResult result = ValidationUtil.validateBCPay(channel, billNo, title, returnUrl, openId);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", channel.toString());
        param.put("total_fee", totalFee);
        param.put("bill_no", billNo);
        param.put("title", title);
        if (optional != null && optional.size() > 0) {
            param.put("optional", optional);
        }
        if (!StrUtil.empty(returnUrl)) {
            param.put("return_url", returnUrl);
        }
        if (!StrUtil.empty(openId)) {
            param.put("openid", openId);
        }
        if (!StrUtil.empty(showUrl)) {
            param.put("show_url", showUrl);
        }
        if (qrPayMode != null) {
            if (qrPayMode.ordinal() == 2) {
                param.put("qr_pay_mode", String.valueOf(qrPayMode.ordinal() + 1));
            } else {
                param.put("qr_pay_mode", String.valueOf(qrPayMode.ordinal()));
            }
        }
        result = new BCPayResult();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiPay());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_NATIVE)) {
                        if (ret.containsKey("code_url") && null != ret.get("code_url")) {
                            result.setCodeUrl(ret.get("code_url").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI)) {
                        result.setType(BCEumeration.RESULT_TYPE.OK);
                        result.setWxJSAPIMap(BCPayMultiApp.generateWXJSAPIMap(ret));
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WAP)) {
                        if (ret.containsKey("html") && null != ret.get("html") && ret.containsKey("url") && null != ret.get("url")) {
                            result.setHtml(ret.get("html").toString());
                            result.setUrl(ret.get("url").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if (channel.equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.JD_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.JD_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN_WEB)) {
                        if (ret.containsKey("html") && null != ret.get("html")) {
                            result.setHtml(ret.get("html").toString());
                            result.setType(BCEumeration.RESULT_TYPE.OK);
                        }
                    } else if ((channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE_WAP) || channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE_WEB)) && ret.containsKey("url") && null != ret.get("url")) {
                        result.setUrl(ret.get("url").toString());
                        result.setType(BCEumeration.RESULT_TYPE.OK);
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public BCPayResult startBCRefund(BCEumeration.PAY_CHANNEL channel, String refundNo, String billNo, int refundFee, Map optional) {
        BCPayResult result = ValidationUtil.validateBCRefund(channel, refundNo, billNo);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        if (channel != null) {
            param.put("channel", channel.toString());
        }
        param.put("refund_no", refundNo);
        param.put("bill_no", billNo);
        param.put("refund_fee", refundFee);
        if (optional != null && optional.size() > 0) {
            param.put("optional", optional);
        }
        result = new BCPayResult();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiRefund());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    if (ret.containsKey("url")) {
                        result.setUrl(ret.get("url").toString());
                    }
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    result.setSucessMsg("\u9000\u6b3e\u5df2\u7ecf\u6210\u529f\uff01 ");
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public BCQueryResult startQueryBill(BCEumeration.PAY_CHANNEL channel, String billNo, Date startTime, Date endTime, Integer skip, Integer limit) {
        BCQueryResult result = ValidationUtil.validateQueryBill(billNo, limit);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        if (channel != null) {
            param.put("channel", channel.toString());
        }
        param.put("bill_no", billNo);
        param.put("skip", skip);
        param.put("limit", limit);
        if (startTime != null) {
            param.put("start_time", startTime.getTime());
        }
        if (endTime != null) {
            param.put("end_time", endTime.getTime());
        }
        result = new BCQueryResult();
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryBill());
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("bills") && !StrUtil.empty(ret.get("bills"))) {
                        result.setBcOrders(this.generateBCOrderList((List)ret.get("bills")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public BCQueryResult startQueryRefund(BCEumeration.PAY_CHANNEL channel, String billNo, String refundNo, Date startTime, Date endTime, Integer skip, Integer limit) {
        BCQueryResult result = ValidationUtil.validateQueryRefund(billNo, refundNo, limit);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        result = new BCQueryResult();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        if (channel != null) {
            param.put("channel", channel.toString());
        }
        param.put("bill_no", billNo);
        param.put("refund_no", refundNo);
        if (startTime != null) {
            param.put("start_time", startTime.getTime());
        }
        if (endTime != null) {
            param.put("end_time", endTime.getTime());
        }
        param.put("skip", skip);
        param.put("limit", limit);
        Client client = BCAPIClient.client;
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiQueryRefund());
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                    if (ret.containsKey("refunds") && ret.get("refunds") != null) {
                        result.setBcRefundList(this.generateBCRefundList((List)ret.get("refunds")));
                    }
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public BCQueryStatusResult startRefundUpdate(BCEumeration.PAY_CHANNEL channel, String refundNo) {
        BCQueryStatusResult result = ValidationUtil.validateQueryRefundStatus(refundNo);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", channel.toString());
        param.put("refund_no", refundNo);
        result = new BCQueryStatusResult();
        StringBuilder sb = new StringBuilder();
        sb.append(BCUtilPrivate.getkApiRefundUpdate());
        Client client = BCAPIClient.client;
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setRefundStatus(ret.get("refund_status").toString());
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setErrDetail("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setErrDetail(e.getMessage());
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public BCPayResult startTransfer(BCEumeration.PAY_CHANNEL channel, String batchNo, String accountName, List<TransferData> transferData) {
        BCPayResult result = ValidationUtil.validateBCTransfer(channel, batchNo, accountName, transferData);
        if (result.getType().ordinal() != 0) {
            return result;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(param.get("timestamp").toString()));
        param.put("channel", channel.toString());
        param.put("batch_no", batchNo);
        param.put("account_name", accountName);
        ArrayList transferList = new ArrayList();
        for (TransferData data : transferData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("transfer_id", data.getTransferId());
            map.put("receiver_account", data.getReceiverAccount());
            map.put("receiver_name", data.getReceiverName());
            map.put("transfer_fee", data.getTransferFee());
            map.put("transfer_note", data.getTransferNote());
            transferList.add(map);
        }
        param.put("transfer_data", transferList);
        result = new BCPayResult();
        Client client = BCAPIClient.client;
        WebTarget target = client.target(BCUtilPrivate.getkApiTransfer());
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                boolean bl = isSuccess = ret.containsKey("result_code") && StrUtil.toStr(ret.get("result_code")).equals("0");
                if (isSuccess) {
                    result.setUrl(ret.get("url").toString());
                    result.setType(BCEumeration.RESULT_TYPE.OK);
                } else {
                    result.setErrMsg(ret.get("result_msg").toString());
                    result.setErrDetail(ret.get("err_detail").toString());
                    result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
                }
            } else {
                result.setErrMsg("Not correct response!");
                result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
            }
        }
        catch (Exception e) {
            result.setErrMsg("Network error!");
            result.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        }
        return result;
    }

    public boolean verifySign(String sign, String timestamp) {
        String mySign = MD5.sign(BCCache.getAppID() + BCCache.getAppSecret(), timestamp, "UTF-8");
        return sign.equals(mySign);
    }

    private List<BCOrderBean> generateBCOrderList(List<Map<String, Object>> bills) {
        ArrayList<BCOrderBean> bcOrderList = new ArrayList<BCOrderBean>();
        for (Map<String, Object> bill : bills) {
            BCOrderBean bcOrder = new BCOrderBean();
            bcOrder.setBillNo(bill.get("bill_no").toString());
            bcOrder.setTotalFee(bill.get("total_fee").toString());
            bcOrder.setTitle(bill.get("title").toString());
            bcOrder.setChannel(bill.get("channel").toString());
            bcOrder.setSpayResult((Boolean)bill.get("spay_result"));
            bcOrder.setCreatedTime((Long)bill.get("created_time"));
            bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("created_time")));
            bcOrderList.add(bcOrder);
        }
        return bcOrderList;
    }

    private List<BCRefundBean> generateBCRefundList(List<Map<String, Object>> refundList) {
        ArrayList<BCRefundBean> bcRefundList = new ArrayList<BCRefundBean>();
        for (Map<String, Object> refund : refundList) {
            BCRefundBean bcRefund = new BCRefundBean();
            bcRefund.setBillNo(refund.get("bill_no").toString());
            bcRefund.setRefundNo(refund.get("refund_no").toString());
            bcRefund.setTotalFee(refund.get("total_fee").toString());
            bcRefund.setRefundFee(refund.get("refund_fee").toString());
            bcRefund.setChannel(refund.get("channel").toString());
            bcRefund.setFinished((Boolean)refund.get("finish"));
            bcRefund.setRefunded((Boolean)refund.get("result"));
            bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("created_time")));
            bcRefundList.add(bcRefund);
        }
        return bcRefundList;
    }

    private static Map<String, Object> generateWXJSAPIMap(Map<String, Object> ret) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", ret.get("app_id"));
        map.put("package", ret.get("package"));
        map.put("nonceStr", ret.get("nonce_str"));
        map.put("timeStamp", ret.get("timestamp"));
        map.put("paySign", ret.get("pay_sign"));
        map.put("signType", ret.get("sign_type"));
        return map;
    }
}

