/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCEumeration;
import cn.beecloud.BCPayResult;
import cn.beecloud.BCQueryResult;
import cn.beecloud.BCQueryStatusResult;
import cn.beecloud.StrUtil;
import cn.beecloud.bean.BCPayParameter;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefundParameter;
import cn.beecloud.bean.BCRefundQueryParameter;
import cn.beecloud.bean.TransferData;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationUtil {
    private static final String BILL_NO_FORMAT_INVALID = "billNo \u662f\u4e00\u4e2a\u957f\u5ea6\u4ecb\u4e8e8\u81f332\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String BATCH_NO_FORMAT_INVALID = "batchNo \u662f\u4e00\u4e2a\u957f\u5ea6\u572811\u523032\u4e2a\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String PAY_PARAM_EMPTY = "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_PARAM_EMPTY = "\u9000\u6b3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String BILL_NO_EMPTY = "billNo \u5fc5\u586b\uff01";
    private static final String BATCH_NO_EMPTY = "batchNo \u5fc5\u586b\uff01";
    private static final String TRANSFER_DATA_EMPTY = "transferData \u5fc5\u586b\uff01";
    private static final String TRANSFER_ID_EMPTY = "transferId \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String RECEIVER_ACCOUNT_EMPTY = "receiverAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String RECEIVER_NAME_EMPTY = "receiverName \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_FEE_EMPTY = "transferFee \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_NOTE_EMPTY = "transferNote \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ACCOUNT_NAME_EMPTY = "accountName \u5fc5\u586b\uff01";
    private static final String TITLE_EMPTY = "title \u5fc5\u586b\uff01";
    private static final String QR_PAY_MODE_EMPTY = "qrPayMode \u5fc5\u586b\uff01";
    private static final String RETURN_URL_EMPTY = "returnUrl \u5fc5\u586b\uff01";
    private static final String REFUND_NO_EMPTY = "refundNo \u5fc5\u586b\uff01";
    private static final String CHANNEL_EMPTY = "channel \u5fc5\u586b\uff01";
    private static final String YEE_NOBANCARD_FACTOR_EMPTY = "cardNo, cardPwd, frqid \u5fc5\u586b\uff01";
    private static final String REFUND_NO_FORMAT_INVALID = "refundNo \u662f\u683c\u5f0f\u4e3a\u5f53\u524d\u65e5\u671f\u52a03-24\u4f4d\u6570\u5b57\u5b57\u6bcd\uff08\u4e0d\u80fd\u4e3a000\uff09\u6d41\u6c34\u53f7\u7684\u5b57\u7b26\u4e32\uff01 ";
    private static final String TITLE_FORMAT_INVALID = "title \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u8282\u7684\u5b57\u7b26\u4e32\uff01";
    private static final String LIMIT_FORMAT_INVALID = "limit \u7684\u6700\u5927\u957f\u5ea6\u4e3a50\uff01";
    private static final String OPENID_EMPTY = "openid \u5fc5\u586b\uff01";
    private static final String CHANNEL_INVALID_FOR_REFUND = "\u9000\u6b3e\u53ea\u652f\u6301WX, UN, ALI !";
    private static final String TRANSFER_ID_FORMAT_EMPTY = "transferId \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String TRANSFER_LIST_SIZE_INVALID = "transferData \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71000\uff01";
    private static final String CHANNEL_SUPPORT_INVALID = "\u6279\u91cf\u6253\u6b3e\u4ec5\u652f\u6301ALI";
    static final String PRE_REFUND_SUCCEED = "\u9884\u9000\u6b3e\u6210\u529f\uff01 ";
    static final String REFUND_REJECT = "\u9000\u6b3e\u88ab\u62d2\u7edd\uff01 ";
    static final String REFUND_SUCCESS = "\u9000\u6b3e\u5df2\u7ecf\u6210\u529f\uff01 ";
    static final String PAY_SUCCESS = "\u652f\u4ed8\u6210\u529f\uff01 ";

    public static BCPayResult validateResultFromBackend(Map<String, Object> ret) {
        BCPayResult bcPayResult = new BCPayResult();
        bcPayResult.setErrMsg(ret.get("errMsg").toString());
        bcPayResult.setErrDetail(ret.get("err_detail").toString());
        bcPayResult.setType(BCEumeration.RESULT_TYPE.RUNTIME_ERROR);
        return bcPayResult;
    }

    public static BCPayResult validateBCPay(BCEumeration.PAY_CHANNEL channel, String billNo, String title, String returnUrl, String openId) {
        block9: {
            if (channel == null) {
                return new BCPayResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(billNo)) {
                return new BCPayResult(BILL_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (!billNo.matches("[0-9A-Za-z]{8,32}")) {
                return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(title)) {
                return new BCPayResult(TITLE_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(returnUrl) && (channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB))) {
                return new BCPayResult(RETURN_URL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (channel.equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI) && StrUtil.empty(openId)) {
                return new BCPayResult(OPENID_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            try {
                if (title.getBytes("GBK").length > 32) {
                    return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (title.length() <= 16) break block9;
                return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCPayResult validateBCRefund(BCEumeration.PAY_CHANNEL channel, String refundNo, String billNo) {
        if (!(channel == null || channel.equals((Object)BCEumeration.PAY_CHANNEL.WX) || channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI) || channel.equals((Object)BCEumeration.PAY_CHANNEL.UN) || channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.JD) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN) || channel.equals((Object)BCEumeration.PAY_CHANNEL.BD))) {
            return new BCPayResult(CHANNEL_INVALID_FOR_REFUND, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (StrUtil.empty(refundNo)) {
            return new BCPayResult(REFUND_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!refundNo.startsWith(new SimpleDateFormat("yyyyMMdd").format(new Date()))) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!refundNo.substring(8, refundNo.length()).matches("[0-9A-Za-z]{3,24}") || refundNo.substring(8, refundNo.length()).matches("000")) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (StrUtil.empty(billNo)) {
            return new BCPayResult(BILL_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!billNo.matches("[0-9A-Za-z]{8,32}")) {
            return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryBill(String billNo, Integer limit) {
        if (!StrUtil.empty(billNo) && !billNo.matches("[0-9A-Za-z]{8,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (limit != null && limit > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryRefund(String billNo, String refundNo, Integer limit) {
        if (!StrUtil.empty(billNo) && !billNo.matches("[0-9A-Za-z]{8,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!(StrUtil.empty(refundNo) || refundNo.substring(8, refundNo.length()).matches("[0-9A-Za-z]{3,24}") && !refundNo.substring(8, refundNo.length()).matches("000"))) {
            return new BCQueryResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (limit != null && limit > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryStatusResult validateQueryRefundStatus(String refundNo) {
        if (StrUtil.empty(refundNo)) {
            return new BCQueryStatusResult(REFUND_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryStatusResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCPayResult validateBCTransfer(BCEumeration.PAY_CHANNEL channel, String batchNo, String accountName, List<TransferData> transferData) {
        if (channel == null) {
            return new BCPayResult(CHANNEL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!channel.equals((Object)BCEumeration.PAY_CHANNEL.ALI)) {
            return new BCPayResult(CHANNEL_SUPPORT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (batchNo == null) {
            return new BCPayResult(BATCH_NO_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!batchNo.matches("[0-9A-Za-z]{11,32}")) {
            return new BCPayResult(BATCH_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (accountName == null) {
            return new BCPayResult(ACCOUNT_NAME_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (transferData == null) {
            return new BCPayResult(TRANSFER_DATA_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        for (TransferData data : transferData) {
            if (StrUtil.empty(data.getTransferId())) {
                return new BCPayResult(TRANSFER_ID_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (!data.getTransferId().matches("[0-9A-Za-z]{1,32}")) {
                return new BCPayResult(TRANSFER_ID_FORMAT_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(data.getReceiverAccount())) {
                return new BCPayResult(RECEIVER_ACCOUNT_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(data.getReceiverName())) {
                return new BCPayResult(RECEIVER_NAME_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(data.getTransferFee())) {
                return new BCPayResult(TRANSFER_FEE_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (!StrUtil.empty(data.getTransferNote())) continue;
            return new BCPayResult(TRANSFER_NOTE_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (transferData.size() > 1000) {
            return new BCPayResult(TRANSFER_LIST_SIZE_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCPayResult validateBCPay(BCPayParameter para) {
        block9: {
            if (para == null) {
                return new BCPayResult(PAY_PARAM_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (!para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
                return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (StrUtil.empty(para.getReturnUrl()) && (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD_WAP))) {
                return new BCPayResult(RETURN_URL_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI) && StrUtil.empty(para.getOpenId())) {
                return new BCPayResult(OPENID_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) && StrUtil.empty((Object)para.getQrPayMode())) {
                return new BCPayResult(QR_PAY_MODE_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD) && (para.getCardNo() == null || para.getCardPwd() == null || para.getFrqid() == null)) {
                return new BCPayResult(YEE_NOBANCARD_FACTOR_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
            try {
                if (para.getTitle().getBytes("GBK").length > 32) {
                    return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (para.getTitle().length() <= 16) break block9;
                return new BCPayResult(TITLE_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
            }
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCPayResult validateBCRefund(BCRefundParameter para) {
        if (para == null) {
            return new BCPayResult(REFUND_PARAM_EMPTY, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!(para.getChannel() == null || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.UN) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.BD))) {
            return new BCPayResult(CHANNEL_INVALID_FOR_REFUND, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!para.getRefundNo().startsWith(new SimpleDateFormat("yyyyMMdd").format(new Date()))) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!para.getRefundNo().substring(8, para.getRefundNo().length()).matches("[0-9A-Za-z]{3,24}") || para.getRefundNo().substring(8, para.getRefundNo().length()).matches("000")) {
            return new BCPayResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            return new BCPayResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCPayResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryBill(BCQueryParameter para) {
        if (!StrUtil.empty(para.getBillNo()) && !para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (para.getLimit() != null && para.getLimit() > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }

    public static BCQueryResult validateQueryRefund(BCRefundQueryParameter para) {
        if (!StrUtil.empty(para.getBillNo()) && !para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            return new BCQueryResult(BILL_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (!(StrUtil.empty(para.getRefundNo()) || para.getRefundNo().substring(8, para.getRefundNo().length()).matches("[0-9A-Za-z]{3,24}") && !para.getRefundNo().substring(8, para.getRefundNo().length()).matches("000"))) {
            return new BCQueryResult(REFUND_NO_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        if (para.getLimit() != null && para.getLimit() > 50) {
            return new BCQueryResult(LIMIT_FORMAT_INVALID, BCEumeration.RESULT_TYPE.VALIDATION_ERROR);
        }
        return new BCQueryResult(BCEumeration.RESULT_TYPE.OK);
    }
}

