/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCAPIClient;
import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.MD5;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.ALITransferData;
import cn.beecloud.bean.BCBatchRefund;
import cn.beecloud.bean.BCException;
import cn.beecloud.bean.BCInternationlOrder;
import cn.beecloud.bean.BCOrder;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefund;
import cn.beecloud.bean.TransferParameter;
import cn.beecloud.bean.TransfersParameter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class BCPay {
    private static final String NOT_REGISTER = "\u672a\u6ce8\u518c";
    private static final String NOT_CORRECT_RESPONSE = "\u54cd\u5e94\u4e0d\u6b63\u786e";
    private static final String NETWORK_ERROR = "\u7f51\u7edc\u9519\u8bef";
    private static final String TEST_MODE_SUPPORT_ERROR = "\u6d4b\u8bd5\u6a21\u5f0f\u4ec5\u652f\u6301\u56fd\u5185\u652f\u4ed8\u3001\u8ba2\u5355\u67e5\u8be2\u3001\u8ba2\u5355\u603b\u6570\u67e5\u8be2\u3001\u5355\u7b14\u8ba2\u5355\u67e5\u8be2";

    public static BCOrder startBCPay(BCOrder order) throws BCException {
        ValidationUtil.validateBCPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildPayParam(param, order);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getkSandboxApiPay(), param);
            BCPay.placeSandboxOrder(order, ret);
            return order;
        }
        Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getkApiPay(), param);
        BCPay.placeOrder(order, ret);
        return order;
    }

    public static BCRefund startBCRefund(BCRefund refund) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCRefund(refund);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildRefundParam(param, refund);
        Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getkApiRefund(), param);
        refund.setObjectId(StrUtil.toStr(ret.get("id")));
        if (ret.containsKey("url")) {
            refund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
        }
        return refund;
    }

    public static List<BCOrder> startQueryBill(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiSandboxQueryBill(), param);
            return BCPay.generateBCOrderList((List)ret.get("bills"));
        }
        Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiQueryBill(), param);
        return BCPay.generateBCOrderList((List)ret.get("bills"));
    }

    public static BCOrder startQueryBillById(String objectId) throws BCException {
        ValidationUtil.validateQueryById(objectId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        StringBuilder urlSb = new StringBuilder();
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
            urlSb.append(BCUtilPrivate.getkApiSandboxQueryBillById());
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
            urlSb.append(BCUtilPrivate.getkApiQueryBillById());
        }
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = BCPay.doGet(urlSb.toString(), param);
        return BCPay.generateBCOrder((Map)ret.get("pay"));
    }

    public static Integer startQueryBillCount(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryCountParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiSandboxQueryBillCount(), param);
            return (Integer)ret.get("count");
        }
        Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiQueryBillCount(), param);
        return (Integer)ret.get("count");
    }

    public static List<BCRefund> startQueryRefund(BCQueryParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryParam(param, para);
        Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiQueryRefund(), param);
        return BCPay.generateBCRefundList((List)ret.get("refunds"));
    }

    public static BCRefund startQueryRefundById(String objectId) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryById(objectId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(BCUtilPrivate.getkApiQueryRefundById());
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = BCPay.doGet(urlSb.toString(), param);
        return BCPay.generateBCRefund((Map)ret.get("refund"));
    }

    public static Integer startQueryRefundCount(BCQueryParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryCountParam(param, para);
        Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiQueryRefundCount(), param);
        return (Integer)ret.get("count");
    }

    public static String startRefundUpdate(BCEumeration.PAY_CHANNEL channel, String refundNo) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefundStatus(channel, refundNo);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)channel));
        param.put("refund_no", refundNo);
        Map<String, Object> ret = BCPay.doGet(BCUtilPrivate.getkApiRefundUpdate(), param);
        return StrUtil.toStr(ret.get("refund_status"));
    }

    public static BCInternationlOrder startBCInternatioalPay(BCInternationlOrder order) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCInternatioalPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildInternatioalPayParam(param, order);
        Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getApiInternationalPay(), param);
        BCPay.placePayPalOrder(order, ret);
        return order;
    }

    public static String startTransfer(TransferParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCTransfer(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildTransferParam(param, para);
        Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getkApiTransfer(), param);
        if (ret.containsKey("url")) {
            return StrUtil.toStr(ret.get("url"));
        }
        return "";
    }

    public static String startTransfers(TransfersParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCTransfers(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildTransfersParam(param, para);
        Map<String, Object> ret = BCPay.doPost(BCUtilPrivate.getkApiTransfers(), param);
        return StrUtil.toStr(ret.get("url"));
    }

    public static BCBatchRefund startBatchRefund(BCBatchRefund batchRefund) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBatchRefund(batchRefund);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channel", StrUtil.toStr((Object)batchRefund.getChannel()));
        param.put("agree", batchRefund.getAgree());
        param.put("ids", batchRefund.getIds());
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        Map<String, Object> ret = BCPay.doPut(BCUtilPrivate.getApiBatchRefund(), param);
        if (ret.containsKey("result_map")) {
            batchRefund.setIdResult((Map)ret.get("result_map"));
            if (ret.containsKey("url")) {
                batchRefund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
            }
        }
        return batchRefund;
    }

    public static boolean verifySign(String sign, String timestamp) {
        String mySign = MD5.sign(BCCache.getAppID() + BCCache.getAppSecret(), timestamp, "UTF-8");
        return sign.equals(mySign);
    }

    private static void buildPayParam(Map<String, Object> param, BCOrder para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        if (para.getReturnUrl() != null) {
            param.put("return_url", para.getReturnUrl());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
        if (para.getOpenId() != null) {
            param.put("openid", para.getOpenId());
        }
        if (para.getShowUrl() != null) {
            param.put("show_url", para.getShowUrl());
        }
        if (para.getQrPayMode() != null) {
            if (para.getQrPayMode().ordinal() == 2) {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal() + 1));
            } else {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal()));
            }
        }
        if (para.getBillTimeout() != null) {
            param.put("bill_timeout", para.getBillTimeout());
        }
        if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
            param.put("cardno", para.getCardNo());
            param.put("cardpwd", para.getCardPwd());
            param.put("frqid", para.getFrqid());
        }
    }

    private static void buildRefundParam(Map<String, Object> param, BCRefund para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("refund_no", para.getRefundNo());
        param.put("bill_no", para.getBillNo());
        param.put("refund_fee", para.getRefundFee());
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.isNeedApproval() != null) {
            param.put("need_approval", para.isNeedApproval());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
    }

    private static void buildQueryParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getSkip() != null) {
            param.put("skip", para.getSkip());
        }
        if (para.getLimit() != null) {
            param.put("limit", para.getLimit());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
        if (para.getPayResult() != null) {
            param.put("spay_result", para.getPayResult());
        }
        if (para.getNeedDetail() != null && para.getNeedDetail().booleanValue()) {
            param.put("need_detail", para.getNeedDetail());
        }
        if (para.getNeedApproval() != null && para.getNeedApproval().booleanValue()) {
            param.put("need_approval", para.getNeedApproval());
        }
    }

    private static void buildQueryCountParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
    }

    private static void buildInternatioalPayParam(Map<String, Object> param, BCInternationlOrder order) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)order.getChannel()));
        param.put("currency", StrUtil.toStr((Object)order.getCurrency()));
        param.put("bill_no", order.getBillNo());
        param.put("title", order.getTitle());
        param.put("total_fee", order.getTotalFee());
        if (order.getCreditCardInfo() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            param.put("credit_card_info", map);
            map.put("card_number", order.getCreditCardInfo().getCardNo());
            map.put("expire_month", order.getCreditCardInfo().getExpireMonth());
            map.put("expire_year", order.getCreditCardInfo().getExpireYear());
            map.put("cvv", order.getCreditCardInfo().getCvv());
            map.put("first_name", order.getCreditCardInfo().getFirstName());
            map.put("last_name", order.getCreditCardInfo().getLastName());
            map.put("card_type", StrUtil.toStr((Object)order.getCreditCardInfo().getCardType()));
        }
        if (order.getCreditCardId() != null) {
            param.put("credit_card_id", order.getCreditCardId());
        }
        if (order.getReturnUrl() != null) {
            param.put("return_url", order.getReturnUrl());
        }
    }

    private static void buildTransferParam(Map<String, Object> param, TransferParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("transfer_no", para.getTransferNo());
        param.put("total_fee", para.getTotalFee());
        param.put("desc", para.getDescription());
        param.put("channel_user_id", para.getChannelUserId());
        if (para.getChannelUserName() != null) {
            param.put("channel_user_name", para.getChannelUserName());
        }
        if (para.getRedpackInfo() != null) {
            HashMap<String, String> redpackInfo = new HashMap<String, String>();
            redpackInfo.put("send_name", para.getRedpackInfo().getSendName());
            redpackInfo.put("wishing", para.getRedpackInfo().getWishing());
            redpackInfo.put("act_name", para.getRedpackInfo().getActivityName());
            param.put("redpack_info", redpackInfo);
        }
        if (para.getAccountName() != null) {
            param.put("account_name", para.getAccountName());
        }
    }

    private static void buildTransfersParam(Map<String, Object> param, TransfersParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("batch_no", para.getBatchNo());
        param.put("account_name", para.getAccountName());
        ArrayList transferList = new ArrayList();
        for (ALITransferData data : para.getTransferDataList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("transfer_id", data.getTransferId());
            map.put("receiver_account", data.getReceiverAccount());
            map.put("receiver_name", data.getReceiverName());
            map.put("transfer_fee", data.getTransferFee());
            map.put("transfer_note", data.getTransferNote());
            transferList.add(map);
        }
        param.put("transfer_data", transferList);
    }

    private static List<BCOrder> generateBCOrderList(List<Map<String, Object>> bills) {
        ArrayList<BCOrder> bcOrderList = new ArrayList<BCOrder>();
        for (Map<String, Object> bill : bills) {
            BCOrder bcOrder = new BCOrder();
            BCPay.generateBCOrderBean(bill, bcOrder);
            bcOrderList.add(bcOrder);
        }
        return bcOrderList;
    }

    private static BCOrder generateBCOrder(Map<String, Object> bill) {
        BCOrder bcOrder = new BCOrder();
        BCPay.generateBCOrderBean(bill, bcOrder);
        return bcOrder;
    }

    private static List<BCRefund> generateBCRefundList(List<Map<String, Object>> refundList) {
        ArrayList<BCRefund> bcRefundList = new ArrayList<BCRefund>();
        for (Map<String, Object> refund : refundList) {
            BCRefund bcRefund = new BCRefund();
            BCPay.generateBCRefundBean(refund, bcRefund);
            bcRefundList.add(bcRefund);
        }
        return bcRefundList;
    }

    private static BCRefund generateBCRefund(Map<String, Object> refund) {
        BCRefund bcRefund = new BCRefund();
        BCPay.generateBCRefundBean(refund, bcRefund);
        return bcRefund;
    }

    private static void generateBCOrderBean(Map<String, Object> bill, BCOrder bcOrder) {
        bcOrder.setObjectId(StrUtil.toStr(bill.get("id")));
        bcOrder.setBillNo(StrUtil.toStr(bill.get("bill_no")));
        bcOrder.setTotalFee((Integer)bill.get("total_fee"));
        bcOrder.setTitle(StrUtil.toStr(bill.get("title")));
        bcOrder.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(bill.get("sub_channel"))));
        bcOrder.setResulted((Boolean)bill.get("spay_result"));
        if (bill.containsKey("trade_no") && bill.get("trade_no") != null) {
            bcOrder.setChannelTradeNo(StrUtil.toStr(bill.get("trade_no")));
        }
        bcOrder.setOptionalString(StrUtil.toStr(bill.get("optional")));
        bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("create_time")));
        if (bill.containsKey("message_detail")) {
            bcOrder.setMessageDetail(StrUtil.toStr(bill.get("message_detail")));
        }
        bcOrder.setRefundResult((Boolean)bill.get("refund_result"));
        bcOrder.setRevertResult((Boolean)bill.get("revert_result"));
    }

    private static void generateBCRefundBean(Map<String, Object> refund, BCRefund bcRefund) {
        bcRefund.setObjectId(StrUtil.toStr(refund.get("id")));
        bcRefund.setBillNo(StrUtil.toStr(refund.get("bill_no")));
        bcRefund.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(refund.get("sub_channel"))));
        bcRefund.setFinished((Boolean)refund.get("finish"));
        bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("create_time")));
        bcRefund.setOptionalString(StrUtil.toStr(refund.get("optional")));
        bcRefund.setRefunded((Boolean)refund.get("result"));
        bcRefund.setTitle(StrUtil.toStr(refund.get("title")));
        bcRefund.setTotalFee((Integer)refund.get("total_fee"));
        bcRefund.setRefundFee((Integer)refund.get("refund_fee"));
        bcRefund.setRefundNo(StrUtil.toStr(refund.get("refund_no")));
        if (refund.containsKey("message_detail")) {
            bcRefund.setMessageDetail(StrUtil.toStr(refund.get("message_detail")));
        }
    }

    private static Map<String, String> generateWXJSAPIMap(Map<String, Object> ret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", StrUtil.toStr(ret.get("app_id")));
        map.put("package", StrUtil.toStr(ret.get("package")));
        map.put("nonceStr", StrUtil.toStr(ret.get("nonce_str")));
        map.put("timeStamp", StrUtil.toStr(ret.get("timestamp")));
        map.put("paySign", StrUtil.toStr(ret.get("pay_sign")));
        map.put("signType", StrUtil.toStr(ret.get("sign_type")));
        return map;
    }

    private static Map<String, Object> doPost(String url, Map<String, Object> param) throws BCException {
        Client client = BCAPIClient.client;
        if (client == null) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), NOT_REGISTER);
        }
        WebTarget target = client.target(url);
        try {
            Response response = target.request().post(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                Integer resultCode = (Integer)ret.get("result_code");
                String resultMessage = StrUtil.toStr(ret.get("result_msg"));
                String errorDetail = StrUtil.toStr(ret.get("err_detail"));
                boolean bl = isSuccess = resultCode == 0;
                if (isSuccess) {
                    return ret;
                }
                throw new BCException(resultCode, resultMessage, errorDetail);
            }
            throw new BCException(-1, BCEumeration.RESULT_TYPE.NOT_CORRECT_RESPONSE.name(), NOT_CORRECT_RESPONSE);
        }
        catch (Exception e) {
            if (e instanceof BCException) {
                throw (BCException)e;
            }
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u7f51\u7edc\u9519\u8bef," + e.getMessage());
        }
    }

    private static Map<String, Object> doPut(String url, Map<String, Object> param) throws BCException {
        Client client = BCAPIClient.client;
        if (client == null) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), NOT_REGISTER);
        }
        WebTarget target = client.target(url);
        try {
            Response response = target.request().put(Entity.entity(param, (String)"application/json"));
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                Integer resultCode = (Integer)ret.get("result_code");
                String resultMessage = StrUtil.toStr(ret.get("result_msg"));
                String errorDetail = StrUtil.toStr(ret.get("err_detail"));
                boolean bl = isSuccess = resultCode == 0;
                if (isSuccess) {
                    return ret;
                }
                throw new BCException(resultCode, resultMessage, errorDetail);
            }
            throw new BCException(-1, BCEumeration.RESULT_TYPE.NOT_CORRECT_RESPONSE.name(), NOT_CORRECT_RESPONSE);
        }
        catch (Exception e) {
            if (e instanceof BCException) {
                throw (BCException)e;
            }
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), e.getMessage());
        }
    }

    private static Map<String, Object> doGet(String url, Map<String, Object> param) throws BCException {
        Client client = BCAPIClient.client;
        if (client == null) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), NOT_REGISTER);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        try {
            sb.append(URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8"));
            WebTarget target = client.target(sb.toString());
            Response response = target.request().get();
            if (response.getStatus() == 200) {
                boolean isSuccess;
                Map ret = (Map)response.readEntity(Map.class);
                Integer resultCode = (Integer)ret.get("result_code");
                String resultMessage = StrUtil.toStr(ret.get("result_msg"));
                String errorDetail = StrUtil.toStr(ret.get("err_detail"));
                boolean bl = isSuccess = resultCode == 0;
                if (isSuccess) {
                    return ret;
                }
                throw new BCException(resultCode, resultMessage, errorDetail);
            }
            throw new BCException(-1, BCEumeration.RESULT_TYPE.NOT_CORRECT_RESPONSE.name(), NOT_CORRECT_RESPONSE);
        }
        catch (Exception e) {
            if (e instanceof BCException) {
                throw (BCException)e;
            }
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), e.getMessage());
        }
    }

    private static void placeOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case WX_NATIVE: {
                if (!ret.containsKey("code_url") || null == ret.get("code_url")) break;
                order.setCodeUrl(StrUtil.toStr(ret.get("code_url")));
                break;
            }
            case WX_JSAPI: {
                order.setWxJSAPIMap(BCPay.generateWXJSAPIMap(ret));
                break;
            }
            case ALI_WEB: 
            case ALI_QRCODE: 
            case ALI_WAP: {
                if (!ret.containsKey("html") || null == ret.get("html") || !ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(StrUtil.toStr(ret.get("html")));
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case UN_WEB: 
            case JD_WAP: 
            case JD_WEB: 
            case KUAIQIAN_WAP: 
            case KUAIQIAN_WEB: {
                if (!ret.containsKey("html") || null == ret.get("html")) break;
                order.setHtml(StrUtil.toStr(ret.get("html")));
                break;
            }
            case YEE_WAP: 
            case YEE_WEB: 
            case BD_WEB: 
            case BD_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setUrl(StrUtil.toStr(ret.get("url")));
            }
        }
    }

    private static void placePayPalOrder(BCInternationlOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case PAYPAL_PAYPAL: {
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case PAYPAL_CREDITCARD: {
                order.setCreditCardId(StrUtil.toStr(ret.get("credit_card_id")));
                break;
            }
        }
    }

    private static void placeSandboxOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        order.setSandboxUrl(StrUtil.toStr(ret.get("url")));
    }

    private static void checkTestModeSwitch() throws BCException {
        if (BCCache.isSandbox()) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), TEST_MODE_SUPPORT_ERROR);
        }
    }
}

