/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCEumeration;
import cn.beecloud.StrUtil;
import cn.beecloud.bean.ALITransferData;
import cn.beecloud.bean.BCBatchRefund;
import cn.beecloud.bean.BCException;
import cn.beecloud.bean.BCInternationlOrder;
import cn.beecloud.bean.BCOrder;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefund;
import cn.beecloud.bean.TransferParameter;
import cn.beecloud.bean.TransfersParameter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValidationUtil {
    private static final String BILL_NO_FORMAT_INVALID = "billNo \u662f\u4e00\u4e2a\u957f\u5ea6\u4ecb\u4e8e8\u81f332\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String TRANSFERS_BATCH_NO_FORMAT_INVALID = "batchNo \u662f\u4e00\u4e2a\u957f\u5ea6\u572811\u523032\u4e2a\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String PAY_PARAM_EMPTY = "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String BATCH_REFUND_PARAM_EMPTY = "\u6279\u91cf\u5ba1\u6838\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_PARAM_EMPTY = "\u9000\u6b3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String QUERY_PARAM_EMPTY = "\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String BILL_NO_EMPTY = "billNo \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFERS_BATCH_NO_EMPTY = "\u6279\u91cf\u6253\u6b3ebatchNo \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_PARAM_EMPTY = "transfer\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_CHANNEL_EMPTY = "\u5355\u7b14\u6253\u6b3echannel \u4e0d\u80fd\u4e3a\u7a7a!";
    private static final String TRANSFER_TRANSFER_NO_EMPTY = "\u5355\u7b14\u6253\u6b3etransferNo \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_TOTAL_FEE_EMPTY = "\u5355\u7b14\u6253\u6b3etotalFee \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_DESC_EMPTY = "\u5355\u7b14\u6253\u6b3edescription \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_USER_ID_EMPTY = "\u5355\u7b14\u6253\u6b3echannelUserId \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_REDPACK_INFO_EMPTY = "\u5fae\u4fe1\u7ea2\u5305redpackInfo \u4e0d\u80fd\u4e3a\u7a7a! ";
    private static final String TRANSFER_USER_NAME_EMPTY = "\u652f\u4ed8\u5b9d\u5355\u7b14\u6253\u6b3echannelUserName \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_ACCOUNT_NAME_EMPTY = "\u652f\u4ed8\u5b9d\u5355\u7b14\u6253\u6b3eaccountName \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ALI_TRANSFER_NO_INVALID = "\u652f\u4ed8\u5b9d\u5355\u7b14\u6253\u6b3etransferNo \u662f\u4e00\u4e2a\u957f\u5ea6\u572811\u523032\u4e2a\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32";
    private static final String WX_TRANSFER_TOTAL_FEE_INVALID = "\u5fae\u4fe1\u6253\u6b3e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e1.00\u5143\uff0ctotalFee\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e100!";
    private static final String WX_REDPACK_TOTAL_FEE_INVALID = "\u53ea\u80fd\u53d1\u653e1.00\u5757\u5230200\u5757\u94b1\u7684\u7ea2\u5305\uff0ctotalFee\u8303\u56f4\u5fc5\u987b\u5728(100~20000)\u5185";
    private static final String ALI_TRANSFER_TOTAL_FEE_INVALID = "\u652f\u4ed8\u5b9d\u5355\u7b14\u6253\u6b3etotalFee \u5fc5\u987b\u5927\u4e8e 0\uff01";
    private static final String TRANSFER_REDPACK_INFO_FIELD_EMPTY = "\u5fae\u4fe1\u7ea2\u5305sendName\u3001wishing\u3001activityName \u4e0d\u80fd\u4e3a\u7a7a!";
    private static final String WX_TRANSFER_NO_INVALID = "\u5fae\u4fe1\u5355\u7b14\u6253\u6b3etransferNo \u662f\u4e00\u4e2a\u957f\u5ea6\u4e3a10\u7684\u6570\u5b57\uff01";
    private static final String TRANSFERS_PARAM_EMPTY = "\u6279\u91cf\u6253\u6b3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFERS_CHANNEL_EMPTY = "\u6279\u91cf\u6253\u6b3echannel \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFERS_DATA_LIST_EMPTY = "\u6279\u91cf\u6253\u6b3etransferDataList \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_ID_EMPTY = "transferId \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String RECEIVER_ACCOUNT_EMPTY = "receiverAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String RECEIVER_NAME_EMPTY = "receiverName \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_FEE_EMPTY = "transferFee \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFER_FEE_INVALID = "transferFee \u5fc5\u987b\u5927\u4e8e0\uff01";
    private static final String TRANSFER_NOTE_EMPTY = "transferNote \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TRANSFERS_ACCOUNT_NAME_EMPTY = "accountName \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TITLE_EMPTY = "title \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String TOTAL_FEE_EMPTY = "totalFee \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_FEE_EMPTY = "refundFee \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_FEE_INVALID = "refundFee \u5fc5\u987b\u5927\u4e8e\u96f6\uff01";
    private static final String QR_PAY_MODE_EMPTY = "qrPayMode \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String RETURN_URL_EMPTY = "returnUrl \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_NO_EMPTY = "refundNo \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String BATCH_REFUND_AGREE_EMPTY = "\u6279\u91cf\u5ba1\u6838agree\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String BATCH_REFUND_CHANNEL_EMPTY = "\u6279\u91cf\u5ba1\u6838channel\u4e0d\u80fd\u4e3a\u7a7a!";
    private static final String BATCH_REFUND_ID_LIST_EMPTY = "\u6279\u91cf\u5ba1\u6838ids\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String CHANNEL_EMPTY = "channel \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String YEE_NOBANCARD_FACTOR_EMPTY = "cardNo, cardPwd, frqid \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String REFUND_NO_FORMAT_INVALID = "refundNo \u662f\u683c\u5f0f\u4e3a\u5f53\u524d\u65e5\u671f\u52a03-24\u4f4d\u6570\u5b57\u5b57\u6bcd\uff08\u4e0d\u80fd\u4e3a000\uff09\u6d41\u6c34\u53f7\u7684\u5b57\u7b26\u4e32\uff01 ";
    private static final String TITLE_FORMAT_INVALID = "title \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u8282\u7684\u5b57\u7b26\u4e32\uff01";
    private static final String LIMIT_FORMAT_INVALID = "limit \u7684\u6700\u5927\u957f\u5ea6\u4e3a50\uff01 \u5e76\u4e14\u4e0d\u80fd\u5c0f\u4e8e10\uff01";
    private static final String OPENID_EMPTY = "openid \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String CHANNEL_INVALID_FOR_REFUND = "\u9000\u6b3e\u53ea\u652f\u6301WX, UN, ALI !";
    private static final String TRANSFER_ID_FORMAT_EMPTY = "transferId \u662f\u4e00\u4e2a\u957f\u5ea6\u4e0d\u8d85\u8fc732\u5b57\u7b26\u7684\u6570\u5b57\u5b57\u6bcd\u5b57\u7b26\u4e32\uff01";
    private static final String TRANSFERS_LIST_SIZE_INVALID = "transferDataList \u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71000\uff01";
    private static final String TRANSFERS_CHANNEL_SUPPORT_INVALID = "\u6279\u91cf\u6253\u6b3e\u4ec5\u652f\u6301ALI";
    private static final String BILL_TIME_OUT_ZERO = "billTimeout\u4e0d\u80fd\u4e3a0\uff01";
    private static final String OBJECT_ID_EMPTY = "objectId \u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String OBJECT_ID_INVALID = "objectId \u53ea\u80fd\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u6216\u8005-";
    private static final String REFUND_UPDATE_CHANNEL_INVALID = "\u9000\u6b3e\u66f4\u65b0\u4ec5\u652f\u6301\u5fae\u4fe1\u3001\u767e\u5ea6\u3001\u6613\u5b9d\u3001\u5feb\u94b1\uff01";
    private static final String INTERNATIONAL_PAY_PARAM_EMPTY = "\u5883\u5916\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String CURRENCY_EMPTY = "currency\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String CREDIT_CARD_INFO_EMPTY = "\u4fe1\u7528\u5361\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String CREDIT_CARD_ID_EMPTY = "\u5b58\u50a8\u7684\u4fe1\u7528\u5361ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String PAYPAL_RETURN_URL_EMPTY = "PAYPAL\u76f4\u63a5\u652f\u4ed8returnUrl\u4e0d\u80fd\u4e3a\u7a7a\uff01";

    static void validateQueryRefundStatus(BCEumeration.PAY_CHANNEL channel, String refundNo) throws BCException {
        if (channel == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CHANNEL_EMPTY);
        }
        if (!(channel.equals((Object)BCEumeration.PAY_CHANNEL.BD) || channel.equals((Object)BCEumeration.PAY_CHANNEL.WX) || channel.equals((Object)BCEumeration.PAY_CHANNEL.YEE) || channel.equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN))) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_UPDATE_CHANNEL_INVALID);
        }
        if (StrUtil.empty(refundNo)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_NO_EMPTY);
        }
    }

    static void validateBCTransfers(TransfersParameter para) throws BCException {
        if (para == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_PARAM_EMPTY);
        }
        if (para.getChannel() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_CHANNEL_EMPTY);
        }
        if (!para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_CHANNEL_SUPPORT_INVALID);
        }
        if (para.getBatchNo() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_BATCH_NO_EMPTY);
        }
        if (!para.getBatchNo().matches("[0-9A-Za-z]{11,32}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_BATCH_NO_FORMAT_INVALID);
        }
        if (para.getAccountName() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_ACCOUNT_NAME_EMPTY);
        }
        if (para.getTransferDataList() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_DATA_LIST_EMPTY);
        }
        for (ALITransferData data : para.getTransferDataList()) {
            if (StrUtil.empty(data.getTransferId())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_ID_EMPTY);
            }
            if (!data.getTransferId().matches("[0-9A-Za-z]{1,32}")) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_ID_FORMAT_EMPTY);
            }
            if (StrUtil.empty(data.getReceiverAccount())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), RECEIVER_ACCOUNT_EMPTY);
            }
            if (StrUtil.empty(data.getReceiverName())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), RECEIVER_NAME_EMPTY);
            }
            if (StrUtil.empty(data.getTransferFee())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_FEE_EMPTY);
            }
            if (data.getTransferFee() <= 0) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_FEE_INVALID);
            }
            if (!StrUtil.empty(data.getTransferNote())) continue;
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_NOTE_EMPTY);
        }
        if (para.getTransferDataList().size() > 1000) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFERS_LIST_SIZE_INVALID);
        }
    }

    static void validateBCPay(BCOrder para) throws BCException {
        block14: {
            if (para == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), PAY_PARAM_EMPTY);
            }
            if (para.getChannel() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CHANNEL_EMPTY);
            }
            if (StrUtil.empty(para.getBillNo())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_EMPTY);
            }
            if (StrUtil.empty(para.getTitle())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_EMPTY);
            }
            if (StrUtil.empty(para.getTotalFee())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TOTAL_FEE_EMPTY);
            }
            if (para.getBillTimeout() != null && para.getBillTimeout() == 0) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_TIME_OUT_ZERO);
            }
            if (para.getBillNo() != null && !para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_FORMAT_INVALID);
            }
            if (StrUtil.empty(para.getReturnUrl()) && (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.UN_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD_WEB) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD_WAP))) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), RETURN_URL_EMPTY);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI) && StrUtil.empty(para.getOpenId())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), OPENID_EMPTY);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI_QRCODE) && StrUtil.empty((Object)para.getQrPayMode())) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), QR_PAY_MODE_EMPTY);
            }
            if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD) && (para.getCardNo() == null || para.getCardPwd() == null || para.getFrqid() == null)) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), YEE_NOBANCARD_FACTOR_EMPTY);
            }
            try {
                if (para.getTitle().getBytes("GBK").length > 32) {
                    throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_FORMAT_INVALID);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (para.getTitle().length() <= 16) break block14;
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_FORMAT_INVALID);
            }
        }
    }

    static void validateBCRefund(BCRefund para) throws BCException {
        if (para == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_PARAM_EMPTY);
        }
        if (StrUtil.empty(para.getBillNo())) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_EMPTY);
        }
        if (StrUtil.empty(para.getRefundFee())) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_FEE_EMPTY);
        }
        if (para.getRefundFee() <= 0) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_FEE_INVALID);
        }
        if (StrUtil.empty(para.getRefundNo())) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_NO_EMPTY);
        }
        if (!(para.getChannel() == null || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.ALI) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.UN) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.JD) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.KUAIQIAN) || para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.BD))) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CHANNEL_INVALID_FOR_REFUND);
        }
        if (!para.getRefundNo().startsWith(new SimpleDateFormat("yyyyMMdd").format(new Date()))) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_NO_FORMAT_INVALID);
        }
        if (!para.getRefundNo().substring(8, para.getRefundNo().length()).matches("[0-9A-Za-z]{3,24}") || para.getRefundNo().substring(8, para.getRefundNo().length()).matches("000")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_NO_FORMAT_INVALID);
        }
        if (!para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_FORMAT_INVALID);
        }
    }

    static void validateQueryBill(BCQueryParameter para) throws BCException {
        if (para == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), QUERY_PARAM_EMPTY);
        }
        if (!StrUtil.empty(para.getBillNo()) && !para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_FORMAT_INVALID);
        }
        if (para.getLimit() != null && (para.getLimit() > 50 || para.getLimit() < 10)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), LIMIT_FORMAT_INVALID);
        }
    }

    static void validateQueryRefund(BCQueryParameter para) throws BCException {
        if (para == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), QUERY_PARAM_EMPTY);
        }
        if (!StrUtil.empty(para.getBillNo()) && !para.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_FORMAT_INVALID);
        }
        if (!(StrUtil.empty(para.getRefundNo()) || para.getRefundNo().substring(8, para.getRefundNo().length()).matches("[0-9A-Za-z]{3,24}") && !para.getRefundNo().substring(8, para.getRefundNo().length()).matches("000"))) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), REFUND_NO_FORMAT_INVALID);
        }
        if (para.getLimit() != null && (para.getLimit() > 50 || para.getLimit() < 10)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), LIMIT_FORMAT_INVALID);
        }
    }

    static void validateQueryById(String objectId) throws BCException {
        if (objectId == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), OBJECT_ID_EMPTY);
        }
        if (!objectId.matches("[0-9a-zA-Z\\-]+")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), OBJECT_ID_INVALID);
        }
    }

    static void validateBatchRefund(BCBatchRefund batchRefund) throws BCException {
        if (batchRefund == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BATCH_REFUND_PARAM_EMPTY);
        }
        if (batchRefund.getAgree() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BATCH_REFUND_AGREE_EMPTY);
        }
        if (batchRefund.getChannel() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BATCH_REFUND_CHANNEL_EMPTY);
        }
        if (batchRefund.getIds() == null || batchRefund.getIds().size() == 0) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BATCH_REFUND_ID_LIST_EMPTY);
        }
    }

    static void validateBCTransfer(TransferParameter para) throws BCException {
        if (para == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_PARAM_EMPTY);
        }
        if (para.getChannel() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_CHANNEL_EMPTY);
        }
        if (para.getTransferNo() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_TRANSFER_NO_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.ALI_TRANSFER) && !para.getTransferNo().matches("[0-9A-Za-z]{11,32}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), ALI_TRANSFER_NO_INVALID);
        }
        if (!para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.ALI_TRANSFER) && !para.getTransferNo().matches("[0-9]{10}")) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), WX_TRANSFER_NO_INVALID);
        }
        if (para.getTotalFee() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_TOTAL_FEE_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.WX_TRANSFER) && para.getTotalFee() < 100) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), WX_TRANSFER_TOTAL_FEE_INVALID);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.WX_REDPACK) && (para.getTotalFee() > 20000 || para.getTotalFee() < 100)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), WX_REDPACK_TOTAL_FEE_INVALID);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.ALI_TRANSFER) && para.getTotalFee() <= 0) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), ALI_TRANSFER_TOTAL_FEE_INVALID);
        }
        if (para.getDescription() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_DESC_EMPTY);
        }
        if (para.getChannelUserId() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_USER_ID_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.ALI_TRANSFER) && para.getChannelUserName() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_USER_NAME_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.WX_REDPACK) && para.getRedpackInfo() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_REDPACK_INFO_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.WX_REDPACK) && para.getRedpackInfo() != null && (para.getRedpackInfo().getSendName() == null || para.getRedpackInfo().getWishing() == null || para.getRedpackInfo().getActivityName() == null)) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_REDPACK_INFO_FIELD_EMPTY);
        }
        if (para.getChannel().equals((Object)BCEumeration.TRANSFER_CHANNEL.ALI_TRANSFER) && para.getAccountName() == null) {
            throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TRANSFER_ACCOUNT_NAME_EMPTY);
        }
    }

    static void validateBCInternatioalPay(BCInternationlOrder order) throws BCException {
        block13: {
            if (order == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), INTERNATIONAL_PAY_PARAM_EMPTY);
            }
            if (order.getBillNo() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_EMPTY);
            }
            if (order.getChannel() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CHANNEL_EMPTY);
            }
            if (order.getTotalFee() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TOTAL_FEE_EMPTY);
            }
            if (order.getBillNo() != null && !order.getBillNo().matches("[0-9A-Za-z]{8,32}")) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), BILL_NO_FORMAT_INVALID);
            }
            if (order.getCurrency() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CURRENCY_EMPTY);
            }
            if (order.getTitle() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_EMPTY);
            }
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.PAYPAL_CREDITCARD) && order.getCreditCardInfo() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CREDIT_CARD_INFO_EMPTY);
            }
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.PAYPAL_SAVED_CREDITCARD) && order.getCreditCardId() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), CREDIT_CARD_ID_EMPTY);
            }
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.PAYPAL_PAYPAL) && order.getReturnUrl() == null) {
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), PAYPAL_RETURN_URL_EMPTY);
            }
            try {
                if (order.getTitle().getBytes("GBK").length > 32) {
                    throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_FORMAT_INVALID);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (order.getTitle().length() <= 16) break block13;
                throw new BCException(BCEumeration.RESULT_TYPE.PARAM_INVALID.ordinal(), BCEumeration.RESULT_TYPE.PARAM_INVALID.name(), TITLE_FORMAT_INVALID);
            }
        }
    }
}

