/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCUtil;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.MD5;
import cn.beecloud.RequestUtil;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.ALITransferData;
import cn.beecloud.bean.BCBatchRefund;
import cn.beecloud.bean.BCException;
import cn.beecloud.bean.BCInternationlOrder;
import cn.beecloud.bean.BCOrder;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefund;
import cn.beecloud.bean.TransferParameter;
import cn.beecloud.bean.TransfersParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BCPayMultiApp {
    private static final String TEST_MODE_SUPPORT_ERROR = "\u6d4b\u8bd5\u6a21\u5f0f\u4ec5\u652f\u6301\u56fd\u5185\u652f\u4ed8(WX_JSAPI\u6682\u4e0d\u652f\u6301)\u3001\u8ba2\u5355\u67e5\u8be2\u3001\u8ba2\u5355\u603b\u6570\u67e5\u8be2\u3001\u5355\u7b14\u8ba2\u5355\u67e5\u8be2";
    private String appId;
    private String appSecret;
    private String testSecret;
    private String masterSecret;

    public BCPayMultiApp(String appId, String testSecret, String appSecret, String masterSecret) {
        this.appId = appId;
        this.testSecret = testSecret;
        this.appSecret = appSecret;
        this.masterSecret = masterSecret;
    }

    public BCOrder startBCPay(BCOrder order) throws BCException {
        ValidationUtil.validateBCPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildPayParam(param, order);
        if (BCCache.isSandbox()) {
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI)) {
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), TEST_MODE_SUPPORT_ERROR);
            }
            Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkSandboxApiPay(), param);
            BCPayMultiApp.placeSandboxOrder(order, ret);
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
                RequestUtil.doGet(BCUtilPrivate.getkApiSandboxNotify() + "/" + this.appId + "/" + order.getObjectId() + "?para=", new HashMap<String, Object>());
            }
            return order;
        }
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiPay(), param);
        BCPayMultiApp.placeOrder(order, ret);
        return order;
    }

    public BCRefund startBCRefund(BCRefund refund) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateBCRefund(refund);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildRefundParam(param, refund);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiRefund(), param);
        refund.setObjectId(StrUtil.toStr(ret.get("id")));
        if (ret.containsKey("url")) {
            refund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
        }
        return refund;
    }

    public List<BCOrder> startQueryBill(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildQueryParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiSandboxQueryBill(), param);
            return BCPayMultiApp.generateBCOrderList((List)ret.get("bills"));
        }
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryBill(), param);
        return BCPayMultiApp.generateBCOrderList((List)ret.get("bills"));
    }

    public BCOrder startQueryBillById(String objectId) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", this.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        StringBuilder urlSb = new StringBuilder();
        if (BCCache.isSandbox()) {
            urlSb.append(BCUtilPrivate.getkApiSandboxQueryBillById());
        } else {
            urlSb.append(BCUtilPrivate.getkApiQueryBillById());
        }
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = RequestUtil.doGet(urlSb.toString(), param);
        return BCPayMultiApp.generateBCOrder((Map)ret.get("pay"));
    }

    public Integer startQueryBillCount(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildQueryCountParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiSandboxQueryBillCount(), param);
            return (Integer)ret.get("count");
        }
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryBillCount(), param);
        return (Integer)ret.get("count");
    }

    public List<BCRefund> startQueryRefund(BCQueryParameter para) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildQueryParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryRefund(), param);
        return BCPayMultiApp.generateBCRefundList((List)ret.get("refunds"));
    }

    public BCRefund startQueryRefundById(String objectId) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(BCUtilPrivate.getkApiQueryRefundById());
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = RequestUtil.doGet(urlSb.toString(), param);
        return BCPayMultiApp.generateBCRefund((Map)ret.get("refund"));
    }

    public Integer startQueryRefundCount(BCQueryParameter para) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildQueryCountParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryBillCount(), param);
        return (Integer)ret.get("count");
    }

    public String startRefundUpdate(BCEumeration.PAY_CHANNEL channel, String refundNo) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateQueryRefundStatus(channel, refundNo);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)channel));
        param.put("refund_no", refundNo);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiRefundUpdate(), param);
        return StrUtil.toStr(ret.get("refund_status"));
    }

    public String startTransfer(TransferParameter para) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateBCTransfer(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildTransferParam(param, para);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiTransfer(), param);
        if (ret.containsKey("url")) {
            return StrUtil.toStr(ret.get("url"));
        }
        return "";
    }

    public String startTransfers(TransfersParameter para) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateBCTransfers(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildTransfersParam(param, para);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiTransfers(), param);
        return StrUtil.toStr(ret.get("url"));
    }

    public BCBatchRefund startBatchRefund(BCBatchRefund batchRefund) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channel", StrUtil.toStr((Object)batchRefund.getChannel()));
        param.put("agree", batchRefund.getAgree());
        param.put("ids", batchRefund.getIds());
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        Map<String, Object> ret = RequestUtil.doPut(BCUtilPrivate.getApiBatchRefund(), param);
        if (ret.containsKey("result_map")) {
            batchRefund.setIdResult((Map)ret.get("result_map"));
            if (ret.containsKey("url")) {
                batchRefund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
            }
        }
        return batchRefund;
    }

    public BCInternationlOrder startBCInternatioalPay(BCInternationlOrder order) throws BCException {
        BCPayMultiApp.checkTestModeSwitch();
        ValidationUtil.validateBCInternatioalPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.buildInternatioalPayParam(param, order);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getApiInternationalPay(), param);
        BCPayMultiApp.placePayPalOrder(order, ret);
        return order;
    }

    public static boolean verifySign(String sign, String timestamp) {
        String mySign = MD5.sign(BCCache.getAppID() + BCCache.getAppSecret(), timestamp, "UTF-8");
        return sign.equals(mySign);
    }

    private void buildPayParam(Map<String, Object> param, BCOrder para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", this.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        if (para.getReturnUrl() != null) {
            param.put("return_url", para.getReturnUrl());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
        if (para.getOpenId() != null) {
            param.put("openid", para.getOpenId());
        }
        if (para.getIdentityId() != null) {
            param.put("identity_id", para.getIdentityId());
        }
        if (para.getShowUrl() != null) {
            param.put("show_url", para.getShowUrl());
        }
        if (para.getQrPayMode() != null) {
            if (para.getQrPayMode().ordinal() == 2) {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal() + 1));
            } else {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal()));
            }
        }
        if (para.getBillTimeout() != null) {
            param.put("bill_timeout", para.getBillTimeout());
        }
        if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
            param.put("cardno", para.getCardNo());
            param.put("cardpwd", para.getCardPwd());
            param.put("frqid", para.getFrqid());
        }
        if (para.getGatewayBank() != null) {
            param.put("bank", StrUtil.toStr((Object)para.getGatewayBank()));
        }
    }

    private Object getAppSignatureWithTestSecret(String timestamp) {
        String str = this.appId + timestamp + this.testSecret;
        return BCUtilPrivate.getMessageDigest(str);
    }

    private void buildRefundParam(Map<String, Object> param, BCRefund para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("refund_no", para.getRefundNo());
        param.put("bill_no", para.getBillNo());
        param.put("refund_fee", para.getRefundFee());
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.isNeedApproval() != null) {
            param.put("need_approval", para.isNeedApproval());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
    }

    private void buildQueryParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", this.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getSkip() != null) {
            param.put("skip", para.getSkip());
        }
        if (para.getLimit() != null) {
            param.put("limit", para.getLimit());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
        if (para.getPayResult() != null) {
            param.put("spay_result", para.getPayResult());
        }
        if (para.getRefundResult() != null) {
            param.put("refund_result", para.getRefundResult());
        }
        if (para.getNeedDetail() != null && para.getNeedDetail().booleanValue()) {
            param.put("need_detail", para.getNeedDetail());
        }
        if (para.getNeedApproval() != null && para.getNeedApproval().booleanValue()) {
            param.put("need_approval", para.getNeedApproval());
        }
    }

    private void buildQueryCountParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", this.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
        if (para.getPayResult() != null) {
            param.put("spay_result", para.getPayResult());
        }
        if (para.getRefundResult() != null) {
            param.put("refund_result", para.getRefundResult());
        }
        if (para.getNeedApproval() != null && para.getNeedApproval().booleanValue()) {
            param.put("need_approval", para.getNeedApproval());
        }
    }

    private void buildInternatioalPayParam(Map<String, Object> param, BCInternationlOrder order) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)order.getChannel()));
        param.put("currency", StrUtil.toStr((Object)order.getCurrency()));
        param.put("bill_no", order.getBillNo());
        param.put("title", order.getTitle());
        param.put("total_fee", order.getTotalFee());
        if (order.getCreditCardInfo() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            param.put("credit_card_info", map);
            map.put("card_number", order.getCreditCardInfo().getCardNo());
            map.put("expire_month", order.getCreditCardInfo().getExpireMonth());
            map.put("expire_year", order.getCreditCardInfo().getExpireYear());
            map.put("cvv", order.getCreditCardInfo().getCvv());
            map.put("first_name", order.getCreditCardInfo().getFirstName());
            map.put("last_name", order.getCreditCardInfo().getLastName());
            map.put("card_type", StrUtil.toStr((Object)order.getCreditCardInfo().getCardType()));
        }
        if (order.getCreditCardId() != null) {
            param.put("credit_card_id", order.getCreditCardId());
        }
        if (order.getReturnUrl() != null) {
            param.put("return_url", order.getReturnUrl());
        }
    }

    private void buildTransferParam(Map<String, Object> param, TransferParameter para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("transfer_no", para.getTransferNo());
        param.put("total_fee", para.getTotalFee());
        param.put("desc", para.getDescription());
        param.put("channel_user_id", para.getChannelUserId());
        if (para.getChannelUserName() != null) {
            param.put("channel_user_name", para.getChannelUserName());
        }
        if (para.getRedpackInfo() != null) {
            HashMap<String, String> redpackInfo = new HashMap<String, String>();
            redpackInfo.put("send_name", para.getRedpackInfo().getSendName());
            redpackInfo.put("wishing", para.getRedpackInfo().getWishing());
            redpackInfo.put("act_name", para.getRedpackInfo().getActivityName());
            param.put("redpack_info", redpackInfo);
        }
        if (para.getAccountName() != null) {
            param.put("account_name", para.getAccountName());
        }
    }

    private void buildTransfersParam(Map<String, Object> param, TransfersParameter para) {
        param.put("app_id", this.appId);
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", this.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", "ALI");
        param.put("batch_no", para.getBatchNo());
        param.put("account_name", para.getAccountName());
        ArrayList transferList = new ArrayList();
        for (ALITransferData data : para.getTransferDataList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("transfer_id", data.getTransferId());
            map.put("receiver_account", data.getReceiverAccount());
            map.put("receiver_name", data.getReceiverName());
            map.put("transfer_fee", data.getTransferFee());
            map.put("transfer_note", data.getTransferNote());
            transferList.add(map);
        }
        param.put("transfer_data", transferList);
    }

    private static List<BCOrder> generateBCOrderList(List<Map<String, Object>> bills) {
        ArrayList<BCOrder> bcOrderList = new ArrayList<BCOrder>();
        for (Map<String, Object> bill : bills) {
            BCOrder bcOrder = new BCOrder();
            BCPayMultiApp.generateBCOrderBean(bill, bcOrder);
            bcOrderList.add(bcOrder);
        }
        return bcOrderList;
    }

    private static BCOrder generateBCOrder(Map<String, Object> bill) {
        BCOrder bcOrder = new BCOrder();
        BCPayMultiApp.generateBCOrderBean(bill, bcOrder);
        return bcOrder;
    }

    private static List<BCRefund> generateBCRefundList(List<Map<String, Object>> refundList) {
        ArrayList<BCRefund> bcRefundList = new ArrayList<BCRefund>();
        for (Map<String, Object> refund : refundList) {
            BCRefund bcRefund = new BCRefund();
            BCPayMultiApp.generateBCRefundBean(refund, bcRefund);
            bcRefundList.add(bcRefund);
        }
        return bcRefundList;
    }

    private static BCRefund generateBCRefund(Map<String, Object> refund) {
        BCRefund bcRefund = new BCRefund();
        BCPayMultiApp.generateBCRefundBean(refund, bcRefund);
        return bcRefund;
    }

    private static void generateBCOrderBean(Map<String, Object> bill, BCOrder bcOrder) {
        bcOrder.setObjectId(StrUtil.toStr(bill.get("id")));
        bcOrder.setBillNo(StrUtil.toStr(bill.get("bill_no")));
        bcOrder.setTotalFee((Integer)bill.get("total_fee"));
        bcOrder.setTitle(StrUtil.toStr(bill.get("title")));
        bcOrder.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(bill.get("sub_channel"))));
        bcOrder.setResult((Boolean)bill.get("spay_result"));
        if (bill.containsKey("trade_no") && bill.get("trade_no") != null) {
            bcOrder.setChannelTradeNo(StrUtil.toStr(bill.get("trade_no")));
        }
        bcOrder.setOptionalString(StrUtil.toStr(bill.get("optional")));
        bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("create_time")));
        if (bill.containsKey("message_detail")) {
            bcOrder.setMessageDetail(StrUtil.toStr(bill.get("message_detail")));
        }
        bcOrder.setRefundResult((Boolean)bill.get("refund_result"));
        bcOrder.setRevertResult((Boolean)bill.get("revert_result"));
    }

    private static void generateBCRefundBean(Map<String, Object> refund, BCRefund bcRefund) {
        bcRefund.setObjectId(StrUtil.toStr(refund.get("id")));
        bcRefund.setBillNo(StrUtil.toStr(refund.get("bill_no")));
        bcRefund.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(refund.get("sub_channel"))));
        bcRefund.setFinished((Boolean)refund.get("finish"));
        bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("create_time")));
        bcRefund.setOptionalString(StrUtil.toStr(refund.get("optional")));
        bcRefund.setRefunded((Boolean)refund.get("result"));
        bcRefund.setTitle(StrUtil.toStr(refund.get("title")));
        bcRefund.setTotalFee((Integer)refund.get("total_fee"));
        bcRefund.setRefundFee((Integer)refund.get("refund_fee"));
        bcRefund.setRefundNo(StrUtil.toStr(refund.get("refund_no")));
        bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("create_time")));
        if (refund.containsKey("message_detail")) {
            bcRefund.setMessageDetail(StrUtil.toStr(refund.get("message_detail")));
        }
    }

    private static Map<String, String> generateWXJSAPIMap(Map<String, Object> ret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", (String)ret.get("app_id"));
        map.put("package", (String)ret.get("package"));
        map.put("nonceStr", (String)ret.get("nonce_str"));
        map.put("timeStamp", (String)ret.get("timestamp"));
        map.put("paySign", (String)ret.get("pay_sign"));
        map.put("signType", (String)ret.get("sign_type"));
        return map;
    }

    private static void placeOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case WX_NATIVE: {
                if (!ret.containsKey("code_url") || null == ret.get("code_url")) break;
                order.setCodeUrl(StrUtil.toStr(ret.get("code_url")));
                break;
            }
            case WX_JSAPI: {
                order.setWxJSAPIMap(BCPayMultiApp.generateWXJSAPIMap(ret));
                break;
            }
            case ALI_WEB: 
            case ALI_QRCODE: 
            case ALI_WAP: {
                if (!ret.containsKey("html") || null == ret.get("html") || !ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(StrUtil.toStr(ret.get("html")));
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case UN_WEB: 
            case JD_WAP: 
            case JD_WEB: 
            case KUAIQIAN_WAP: 
            case KUAIQIAN_WEB: {
                if (!ret.containsKey("html") || null == ret.get("html")) break;
                order.setHtml(StrUtil.toStr(ret.get("html")));
                break;
            }
            case YEE_WAP: 
            case YEE_WEB: 
            case BD_WEB: 
            case BD_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setUrl(StrUtil.toStr(ret.get("url")));
            }
        }
    }

    private static void placePayPalOrder(BCInternationlOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case PAYPAL_PAYPAL: {
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case PAYPAL_CREDITCARD: {
                order.setCreditCardId(StrUtil.toStr(ret.get("credit_card_id")));
                break;
            }
        }
    }

    private static void placeSandboxOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case WX_NATIVE: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setCodeUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case WX_JSAPI: {
                order.setWxJSAPIMap(BCPayMultiApp.generateWXJSAPIMap(ret));
                break;
            }
            case ALI_WEB: 
            case ALI_QRCODE: 
            case ALI_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(BCUtil.generateSandboxHtmlWithUrl(StrUtil.toStr(ret.get("url"))));
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case UN_WEB: 
            case JD_WAP: 
            case JD_WEB: 
            case KUAIQIAN_WAP: 
            case KUAIQIAN_WEB: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(BCUtil.generateSandboxHtmlWithUrl(StrUtil.toStr(ret.get("url"))));
                break;
            }
            case YEE_WAP: 
            case YEE_WEB: 
            case BD_WEB: 
            case BD_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setUrl(StrUtil.toStr(ret.get("url")));
            }
        }
    }

    private static void checkTestModeSwitch() throws BCException {
        if (BCCache.isSandbox()) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), TEST_MODE_SUPPORT_ERROR);
        }
    }

    private String getAppSignature(String timeStamp) {
        String str = this.appId + timeStamp + this.appSecret;
        return BCUtilPrivate.getMessageDigest(str);
    }

    private String getAppSignatureWithMasterSecret(String timeStamp) {
        String str = this.appId + timeStamp + this.masterSecret;
        return BCUtilPrivate.getMessageDigest(str);
    }
}

