/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.RequestUtil;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.BCException;
import cn.beecloud.bean.BCUserInfo;
import cn.beecloud.bean.BCUsers;
import cn.beecloud.bean.BCUsersQuery;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;

public class BCUserManager {
    public static Map<String, Object> userRegister(BCUserInfo user) throws BCException {
        ValidationUtil.validateBCUserRegister(user);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCUserManager.buildUserRegisterParam(param, user);
        return RequestUtil.doPost(BCUtilPrivate.getApiUser(), param);
    }

    public static Map<String, Object> userBatchImport(BCUsers user) throws BCException {
        ValidationUtil.validateBCUsersImport(user);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCUserManager.buildUserBatchImportParam(param, user);
        return RequestUtil.doPost(BCUtilPrivate.getApiUsers(), param);
    }

    public static Map<String, Object> userBatchQuery(BCUsersQuery user) throws BCException {
        ValidationUtil.validateBCUsersQuery(user);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCUserManager.buildUserBatchQueryParam(param, user);
        String paramStr = "";
        try {
            paramStr = "?para=" + URLEncoder.encode(JSONObject.fromObject(param).toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u7f16\u7801\u9519\u8bef," + e.getMessage());
        }
        return RequestUtil.doGet(BCUtilPrivate.getApiUsers(), paramStr);
    }

    private static void buildUserRegisterParam(Map<String, Object> param, BCUserInfo para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", Long.valueOf(para.getTimeStamp()));
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("buyer_id", para.getBuyerId());
    }

    private static void buildUserBatchImportParam(Map<String, Object> param, BCUsers para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", Long.valueOf(para.getTimeStamp()));
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("email", para.getEmail());
        param.put("buyer_ids", para.getBuyerIds());
    }

    private static void buildUserBatchQueryParam(Map<String, Object> param, BCUsersQuery para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", Long.valueOf(para.getTimeStamp()));
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("email", para.getEmail());
        param.put("buyer_type", para.getBuyerType());
    }
}

