/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.model;

import cn.bugstack.chatglm.model.Model;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletionRequest {
    private static final Logger log = LoggerFactory.getLogger(ChatCompletionRequest.class);
    private Boolean isCompatible = true;
    private Model model = Model.GLM_3_5_TURBO;
    private List<Prompt> messages;
    @JsonProperty(value="request_id")
    private String requestId = String.format("xfg-%d", System.currentTimeMillis());
    @JsonProperty(value="do_sample")
    private Boolean doSample = true;
    private Boolean stream = true;
    private float temperature = 0.9f;
    @JsonProperty(value="top_p")
    private float topP = 0.7f;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens = 2048;
    private List<String> stop;
    private List<Tool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice = "auto";
    private List<Prompt> prompt;
    private boolean incremental = true;
    private String sseFormat = "data";

    public String toString() {
        try {
            if (Model.GLM_3_5_TURBO.equals((Object)this.model) || Model.GLM_4.equals((Object)this.model) || Model.GLM_4V.equals((Object)this.model)) {
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                paramsMap.put("model", this.model.getCode());
                if (null == this.messages && null == this.prompt) {
                    throw new RuntimeException("One of messages or prompt must not be empty\uff01");
                }
                paramsMap.put("messages", this.messages != null ? this.messages : this.prompt);
                if (null != this.requestId) {
                    paramsMap.put("request_id", this.requestId);
                }
                if (null != this.doSample) {
                    paramsMap.put("do_sample", this.doSample);
                }
                paramsMap.put("stream", this.stream);
                paramsMap.put("temperature", Float.valueOf(this.temperature));
                paramsMap.put("top_p", Float.valueOf(this.topP));
                paramsMap.put("max_tokens", this.maxTokens);
                if (null != this.stop && this.stop.size() > 0) {
                    paramsMap.put("stop", this.stop);
                }
                if (null != this.tools && this.tools.size() > 0) {
                    paramsMap.put("tools", this.tools);
                    paramsMap.put("tool_choice", this.toolChoice);
                }
                return new ObjectMapper().writeValueAsString(paramsMap);
            }
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("request_id", this.requestId);
            paramsMap.put("prompt", this.prompt);
            paramsMap.put("incremental", this.incremental);
            paramsMap.put("temperature", Float.valueOf(this.temperature));
            paramsMap.put("top_p", Float.valueOf(this.topP));
            paramsMap.put("sseFormat", this.sseFormat);
            return new ObjectMapper().writeValueAsString(paramsMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ChatCompletionRequestBuilder builder() {
        return new ChatCompletionRequestBuilder();
    }

    public Boolean getIsCompatible() {
        return this.isCompatible;
    }

    public Model getModel() {
        return this.model;
    }

    public List<Prompt> getMessages() {
        return this.messages;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Boolean getDoSample() {
        return this.doSample;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getTopP() {
        return this.topP;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public List<Prompt> getPrompt() {
        return this.prompt;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public String getSseFormat() {
        return this.sseFormat;
    }

    public void setIsCompatible(Boolean isCompatible) {
        this.isCompatible = isCompatible;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public void setMessages(List<Prompt> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @JsonProperty(value="do_sample")
    public void setDoSample(Boolean doSample) {
        this.doSample = doSample;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(float topP) {
        this.topP = topP;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="tool_choice")
    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    public void setPrompt(List<Prompt> prompt) {
        this.prompt = prompt;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setSseFormat(String sseFormat) {
        this.sseFormat = sseFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isIncremental() != other.isIncremental()) {
            return false;
        }
        Boolean this$isCompatible = this.getIsCompatible();
        Boolean other$isCompatible = other.getIsCompatible();
        if (this$isCompatible == null ? other$isCompatible != null : !((Object)this$isCompatible).equals(other$isCompatible)) {
            return false;
        }
        Boolean this$doSample = this.getDoSample();
        Boolean other$doSample = other.getDoSample();
        if (this$doSample == null ? other$doSample != null : !((Object)this$doSample).equals(other$doSample)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Model this$model = this.getModel();
        Model other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)((Object)this$model)).equals((Object)other$model)) {
            return false;
        }
        List<Prompt> this$messages = this.getMessages();
        List<Prompt> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        List<Tool> this$tools = this.getTools();
        List<Tool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        String this$toolChoice = this.getToolChoice();
        String other$toolChoice = other.getToolChoice();
        if (this$toolChoice == null ? other$toolChoice != null : !this$toolChoice.equals(other$toolChoice)) {
            return false;
        }
        List<Prompt> this$prompt = this.getPrompt();
        List<Prompt> other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
            return false;
        }
        String this$sseFormat = this.getSseFormat();
        String other$sseFormat = other.getSseFormat();
        return !(this$sseFormat == null ? other$sseFormat != null : !this$sseFormat.equals(other$sseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getTopP());
        result = result * 59 + (this.isIncremental() ? 79 : 97);
        Boolean $isCompatible = this.getIsCompatible();
        result = result * 59 + ($isCompatible == null ? 43 : ((Object)$isCompatible).hashCode());
        Boolean $doSample = this.getDoSample();
        result = result * 59 + ($doSample == null ? 43 : ((Object)$doSample).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Model $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)((Object)$model)).hashCode());
        List<Prompt> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        List<Tool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        String $toolChoice = this.getToolChoice();
        result = result * 59 + ($toolChoice == null ? 43 : $toolChoice.hashCode());
        List<Prompt> $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        String $sseFormat = this.getSseFormat();
        result = result * 59 + ($sseFormat == null ? 43 : $sseFormat.hashCode());
        return result;
    }

    public ChatCompletionRequest() {
    }

    public ChatCompletionRequest(Boolean isCompatible, Model model, List<Prompt> messages, String requestId, Boolean doSample, Boolean stream, float temperature, float topP, Integer maxTokens, List<String> stop, List<Tool> tools, String toolChoice, List<Prompt> prompt, boolean incremental, String sseFormat) {
        this.isCompatible = isCompatible;
        this.model = model;
        this.messages = messages;
        this.requestId = requestId;
        this.doSample = doSample;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.stop = stop;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.prompt = prompt;
        this.incremental = incremental;
        this.sseFormat = sseFormat;
    }

    public static class ChatCompletionRequestBuilder {
        private Boolean isCompatible;
        private Model model;
        private List<Prompt> messages;
        private String requestId;
        private Boolean doSample;
        private Boolean stream;
        private float temperature;
        private float topP;
        private Integer maxTokens;
        private List<String> stop;
        private List<Tool> tools;
        private String toolChoice;
        private List<Prompt> prompt;
        private boolean incremental;
        private String sseFormat;

        ChatCompletionRequestBuilder() {
        }

        public ChatCompletionRequestBuilder isCompatible(Boolean isCompatible) {
            this.isCompatible = isCompatible;
            return this;
        }

        public ChatCompletionRequestBuilder model(Model model) {
            this.model = model;
            return this;
        }

        public ChatCompletionRequestBuilder messages(List<Prompt> messages) {
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="request_id")
        public ChatCompletionRequestBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="do_sample")
        public ChatCompletionRequestBuilder doSample(Boolean doSample) {
            this.doSample = doSample;
            return this;
        }

        public ChatCompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatCompletionRequestBuilder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionRequestBuilder topP(float topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public ChatCompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public ChatCompletionRequestBuilder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        @JsonProperty(value="tool_choice")
        public ChatCompletionRequestBuilder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ChatCompletionRequestBuilder prompt(List<Prompt> prompt) {
            this.prompt = prompt;
            return this;
        }

        public ChatCompletionRequestBuilder incremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public ChatCompletionRequestBuilder sseFormat(String sseFormat) {
            this.sseFormat = sseFormat;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this.isCompatible, this.model, this.messages, this.requestId, this.doSample, this.stream, this.temperature, this.topP, this.maxTokens, this.stop, this.tools, this.toolChoice, this.prompt, this.incremental, this.sseFormat);
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestBuilder(isCompatible=" + this.isCompatible + ", model=" + (Object)((Object)this.model) + ", messages=" + this.messages + ", requestId=" + this.requestId + ", doSample=" + this.doSample + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", stop=" + this.stop + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", prompt=" + this.prompt + ", incremental=" + this.incremental + ", sseFormat=" + this.sseFormat + ")";
        }
    }

    public static class Tool {
        private Type type;
        private Function function;
        private Retrieval retrieval;
        @JsonProperty(value="web_search")
        private WebSearch webSearch;

        public String getType() {
            return this.type.code;
        }

        public static ToolBuilder builder() {
            return new ToolBuilder();
        }

        public Function getFunction() {
            return this.function;
        }

        public Retrieval getRetrieval() {
            return this.retrieval;
        }

        public WebSearch getWebSearch() {
            return this.webSearch;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public void setRetrieval(Retrieval retrieval) {
            this.retrieval = retrieval;
        }

        @JsonProperty(value="web_search")
        public void setWebSearch(WebSearch webSearch) {
            this.webSearch = webSearch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tool)) {
                return false;
            }
            Tool other = (Tool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Function this$function = this.getFunction();
            Function other$function = other.getFunction();
            if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
                return false;
            }
            Retrieval this$retrieval = this.getRetrieval();
            Retrieval other$retrieval = other.getRetrieval();
            if (this$retrieval == null ? other$retrieval != null : !((Object)this$retrieval).equals(other$retrieval)) {
                return false;
            }
            WebSearch this$webSearch = this.getWebSearch();
            WebSearch other$webSearch = other.getWebSearch();
            return !(this$webSearch == null ? other$webSearch != null : !((Object)this$webSearch).equals(other$webSearch));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Function $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
            Retrieval $retrieval = this.getRetrieval();
            result = result * 59 + ($retrieval == null ? 43 : ((Object)$retrieval).hashCode());
            WebSearch $webSearch = this.getWebSearch();
            result = result * 59 + ($webSearch == null ? 43 : ((Object)$webSearch).hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionRequest.Tool(type=" + this.getType() + ", function=" + this.getFunction() + ", retrieval=" + this.getRetrieval() + ", webSearch=" + this.getWebSearch() + ")";
        }

        public Tool() {
        }

        public Tool(Type type, Function function, Retrieval retrieval, WebSearch webSearch) {
            this.type = type;
            this.function = function;
            this.retrieval = retrieval;
            this.webSearch = webSearch;
        }

        public static class ToolBuilder {
            private Type type;
            private Function function;
            private Retrieval retrieval;
            private WebSearch webSearch;

            ToolBuilder() {
            }

            public ToolBuilder type(Type type) {
                this.type = type;
                return this;
            }

            public ToolBuilder function(Function function) {
                this.function = function;
                return this;
            }

            public ToolBuilder retrieval(Retrieval retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            @JsonProperty(value="web_search")
            public ToolBuilder webSearch(WebSearch webSearch) {
                this.webSearch = webSearch;
                return this;
            }

            public Tool build() {
                return new Tool(this.type, this.function, this.retrieval, this.webSearch);
            }

            public String toString() {
                return "ChatCompletionRequest.Tool.ToolBuilder(type=" + (Object)((Object)this.type) + ", function=" + this.function + ", retrieval=" + this.retrieval + ", webSearch=" + this.webSearch + ")";
            }
        }

        public static class WebSearch {
            private Boolean enable = true;
            @JsonProperty(value="search_query")
            private String searchQuery;

            public static WebSearchBuilder builder() {
                return new WebSearchBuilder();
            }

            public Boolean getEnable() {
                return this.enable;
            }

            public String getSearchQuery() {
                return this.searchQuery;
            }

            public void setEnable(Boolean enable) {
                this.enable = enable;
            }

            @JsonProperty(value="search_query")
            public void setSearchQuery(String searchQuery) {
                this.searchQuery = searchQuery;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebSearch)) {
                    return false;
                }
                WebSearch other = (WebSearch)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enable = this.getEnable();
                Boolean other$enable = other.getEnable();
                if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
                    return false;
                }
                String this$searchQuery = this.getSearchQuery();
                String other$searchQuery = other.getSearchQuery();
                return !(this$searchQuery == null ? other$searchQuery != null : !this$searchQuery.equals(other$searchQuery));
            }

            protected boolean canEqual(Object other) {
                return other instanceof WebSearch;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enable = this.getEnable();
                result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
                String $searchQuery = this.getSearchQuery();
                result = result * 59 + ($searchQuery == null ? 43 : $searchQuery.hashCode());
                return result;
            }

            public String toString() {
                return "ChatCompletionRequest.Tool.WebSearch(enable=" + this.getEnable() + ", searchQuery=" + this.getSearchQuery() + ")";
            }

            public WebSearch() {
            }

            public WebSearch(Boolean enable, String searchQuery) {
                this.enable = enable;
                this.searchQuery = searchQuery;
            }

            public static class WebSearchBuilder {
                private Boolean enable;
                private String searchQuery;

                WebSearchBuilder() {
                }

                public WebSearchBuilder enable(Boolean enable) {
                    this.enable = enable;
                    return this;
                }

                @JsonProperty(value="search_query")
                public WebSearchBuilder searchQuery(String searchQuery) {
                    this.searchQuery = searchQuery;
                    return this;
                }

                public WebSearch build() {
                    return new WebSearch(this.enable, this.searchQuery);
                }

                public String toString() {
                    return "ChatCompletionRequest.Tool.WebSearch.WebSearchBuilder(enable=" + this.enable + ", searchQuery=" + this.searchQuery + ")";
                }
            }
        }

        public static class Retrieval {
            @JsonProperty(value="knowledge_id")
            private String knowledgeId;
            @JsonProperty(value="prompt_template")
            private String promptTemplate = "\"\"\"\n{{ knowledge}}\n\"\"\"\n\u4e2d\u627e\u95ee\u9898\n\"\"\"\n{{question}}\n\"\"\"";

            public static RetrievalBuilder builder() {
                return new RetrievalBuilder();
            }

            public String getKnowledgeId() {
                return this.knowledgeId;
            }

            public String getPromptTemplate() {
                return this.promptTemplate;
            }

            @JsonProperty(value="knowledge_id")
            public void setKnowledgeId(String knowledgeId) {
                this.knowledgeId = knowledgeId;
            }

            @JsonProperty(value="prompt_template")
            public void setPromptTemplate(String promptTemplate) {
                this.promptTemplate = promptTemplate;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Retrieval)) {
                    return false;
                }
                Retrieval other = (Retrieval)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$knowledgeId = this.getKnowledgeId();
                String other$knowledgeId = other.getKnowledgeId();
                if (this$knowledgeId == null ? other$knowledgeId != null : !this$knowledgeId.equals(other$knowledgeId)) {
                    return false;
                }
                String this$promptTemplate = this.getPromptTemplate();
                String other$promptTemplate = other.getPromptTemplate();
                return !(this$promptTemplate == null ? other$promptTemplate != null : !this$promptTemplate.equals(other$promptTemplate));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Retrieval;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $knowledgeId = this.getKnowledgeId();
                result = result * 59 + ($knowledgeId == null ? 43 : $knowledgeId.hashCode());
                String $promptTemplate = this.getPromptTemplate();
                result = result * 59 + ($promptTemplate == null ? 43 : $promptTemplate.hashCode());
                return result;
            }

            public String toString() {
                return "ChatCompletionRequest.Tool.Retrieval(knowledgeId=" + this.getKnowledgeId() + ", promptTemplate=" + this.getPromptTemplate() + ")";
            }

            public Retrieval() {
            }

            public Retrieval(String knowledgeId, String promptTemplate) {
                this.knowledgeId = knowledgeId;
                this.promptTemplate = promptTemplate;
            }

            public static class RetrievalBuilder {
                private String knowledgeId;
                private String promptTemplate;

                RetrievalBuilder() {
                }

                @JsonProperty(value="knowledge_id")
                public RetrievalBuilder knowledgeId(String knowledgeId) {
                    this.knowledgeId = knowledgeId;
                    return this;
                }

                @JsonProperty(value="prompt_template")
                public RetrievalBuilder promptTemplate(String promptTemplate) {
                    this.promptTemplate = promptTemplate;
                    return this;
                }

                public Retrieval build() {
                    return new Retrieval(this.knowledgeId, this.promptTemplate);
                }

                public String toString() {
                    return "ChatCompletionRequest.Tool.Retrieval.RetrievalBuilder(knowledgeId=" + this.knowledgeId + ", promptTemplate=" + this.promptTemplate + ")";
                }
            }
        }

        public static class Function {
            private String name;
            private String description;
            private Object parameters;

            public static FunctionBuilder builder() {
                return new FunctionBuilder();
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public Object getParameters() {
                return this.parameters;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setParameters(Object parameters) {
                this.parameters = parameters;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Function)) {
                    return false;
                }
                Function other = (Function)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                Object this$parameters = this.getParameters();
                Object other$parameters = other.getParameters();
                return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Function;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                Object $parameters = this.getParameters();
                result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
                return result;
            }

            public String toString() {
                return "ChatCompletionRequest.Tool.Function(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
            }

            public Function() {
            }

            public Function(String name, String description, Object parameters) {
                this.name = name;
                this.description = description;
                this.parameters = parameters;
            }

            public static class FunctionBuilder {
                private String name;
                private String description;
                private Object parameters;

                FunctionBuilder() {
                }

                public FunctionBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                public FunctionBuilder description(String description) {
                    this.description = description;
                    return this;
                }

                public FunctionBuilder parameters(Object parameters) {
                    this.parameters = parameters;
                    return this;
                }

                public Function build() {
                    return new Function(this.name, this.description, this.parameters);
                }

                public String toString() {
                    return "ChatCompletionRequest.Tool.Function.FunctionBuilder(name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ")";
                }
            }
        }

        public static enum Type {
            function("function", "\u51fd\u6570\u529f\u80fd"),
            retrieval("retrieval", "\u77e5\u8bc6\u5e93"),
            web_search("web_search", "\u8054\u7f51");

            private final String code;
            private final String info;

            public String getCode() {
                return this.code;
            }

            public String getInfo() {
                return this.info;
            }

            private Type(String code, String info) {
                this.code = code;
                this.info = info;
            }
        }
    }

    public static class Prompt {
        private String role;
        private String content;

        public static PromptBuilder builder() {
            return new PromptBuilder();
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionRequest.Prompt(role=" + this.getRole() + ", content=" + this.getContent() + ")";
        }

        public Prompt() {
        }

        public Prompt(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public static class Content {
            private String type = Type.access$000(Type.text);
            private String text;
            @JsonProperty(value="image_url")
            private ImageUrl imageUrl;

            public static ContentBuilder builder() {
                return new ContentBuilder();
            }

            public String getType() {
                return this.type;
            }

            public String getText() {
                return this.text;
            }

            public ImageUrl getImageUrl() {
                return this.imageUrl;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setText(String text) {
                this.text = text;
            }

            @JsonProperty(value="image_url")
            public void setImageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Content)) {
                    return false;
                }
                Content other = (Content)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$text = this.getText();
                String other$text = other.getText();
                if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                    return false;
                }
                ImageUrl this$imageUrl = this.getImageUrl();
                ImageUrl other$imageUrl = other.getImageUrl();
                return !(this$imageUrl == null ? other$imageUrl != null : !((Object)this$imageUrl).equals(other$imageUrl));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Content;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $text = this.getText();
                result = result * 59 + ($text == null ? 43 : $text.hashCode());
                ImageUrl $imageUrl = this.getImageUrl();
                result = result * 59 + ($imageUrl == null ? 43 : ((Object)$imageUrl).hashCode());
                return result;
            }

            public String toString() {
                return "ChatCompletionRequest.Prompt.Content(type=" + this.getType() + ", text=" + this.getText() + ", imageUrl=" + this.getImageUrl() + ")";
            }

            public Content() {
            }

            public Content(String type, String text, ImageUrl imageUrl) {
                this.type = type;
                this.text = text;
                this.imageUrl = imageUrl;
            }

            public static class ContentBuilder {
                private String type;
                private String text;
                private ImageUrl imageUrl;

                ContentBuilder() {
                }

                public ContentBuilder type(String type) {
                    this.type = type;
                    return this;
                }

                public ContentBuilder text(String text) {
                    this.text = text;
                    return this;
                }

                @JsonProperty(value="image_url")
                public ContentBuilder imageUrl(ImageUrl imageUrl) {
                    this.imageUrl = imageUrl;
                    return this;
                }

                public Content build() {
                    return new Content(this.type, this.text, this.imageUrl);
                }

                public String toString() {
                    return "ChatCompletionRequest.Prompt.Content.ContentBuilder(type=" + this.type + ", text=" + this.text + ", imageUrl=" + this.imageUrl + ")";
                }
            }

            public static class ImageUrl {
                private String url;

                public static ImageUrlBuilder builder() {
                    return new ImageUrlBuilder();
                }

                public String getUrl() {
                    return this.url;
                }

                public void setUrl(String url) {
                    this.url = url;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ImageUrl)) {
                        return false;
                    }
                    ImageUrl other = (ImageUrl)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$url = this.getUrl();
                    String other$url = other.getUrl();
                    return !(this$url == null ? other$url != null : !this$url.equals(other$url));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ImageUrl;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $url = this.getUrl();
                    result = result * 59 + ($url == null ? 43 : $url.hashCode());
                    return result;
                }

                public String toString() {
                    return "ChatCompletionRequest.Prompt.Content.ImageUrl(url=" + this.getUrl() + ")";
                }

                public ImageUrl() {
                }

                public ImageUrl(String url) {
                    this.url = url;
                }

                public static class ImageUrlBuilder {
                    private String url;

                    ImageUrlBuilder() {
                    }

                    public ImageUrlBuilder url(String url) {
                        this.url = url;
                        return this;
                    }

                    public ImageUrl build() {
                        return new ImageUrl(this.url);
                    }

                    public String toString() {
                        return "ChatCompletionRequest.Prompt.Content.ImageUrl.ImageUrlBuilder(url=" + this.url + ")";
                    }
                }
            }

            public static enum Type {
                text("text", "\u6587\u672c"),
                image_url("image_url", "\u56fe");

                private final String code;
                private final String info;

                public String getCode() {
                    return this.code;
                }

                public String getInfo() {
                    return this.info;
                }

                private Type(String code, String info) {
                    this.code = code;
                    this.info = info;
                }

                static /* synthetic */ String access$000(Type x0) {
                    return x0.code;
                }
            }
        }

        public static class PromptBuilder {
            private String role;
            private String content;

            PromptBuilder() {
            }

            public PromptBuilder role(String role) {
                this.role = role;
                return this;
            }

            public PromptBuilder content(String content) {
                this.content = content;
                return this;
            }

            public PromptBuilder content(Content content) {
                this.content = JSON.toJSONString((Object)content);
                return this;
            }

            public Prompt build() {
                return new Prompt(this.role, this.content);
            }

            public String toString() {
                return "ChatCompletionRequest.Prompt.PromptBuilder(role=" + this.role + ", content=" + this.content + ")";
            }
        }
    }
}

