/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google.valobj.request;

import cn.bugstack.openai.executor.model.google.valobj.request.TextPrompt;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PalmTextRequest {
    private static final Logger log = LoggerFactory.getLogger(PalmTextRequest.class);
    private TextPrompt prompt;
    private Double temperature = 0.1;
    @JsonProperty(value="candidate_count")
    private Integer candidateCount = 1;
    private Double topP = 0.8;
    private Integer topK = 10;

    public static PalmTextRequestBuilder builder() {
        return new PalmTextRequestBuilder();
    }

    public TextPrompt getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setPrompt(TextPrompt prompt) {
        this.prompt = prompt;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="candidate_count")
    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PalmTextRequest)) {
            return false;
        }
        PalmTextRequest other = (PalmTextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$candidateCount = this.getCandidateCount();
        Integer other$candidateCount = other.getCandidateCount();
        if (this$candidateCount == null ? other$candidateCount != null : !((Object)this$candidateCount).equals(other$candidateCount)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        TextPrompt this$prompt = this.getPrompt();
        TextPrompt other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PalmTextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $candidateCount = this.getCandidateCount();
        result = result * 59 + ($candidateCount == null ? 43 : ((Object)$candidateCount).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        TextPrompt $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        return result;
    }

    public String toString() {
        return "PalmTextRequest(prompt=" + this.getPrompt() + ", temperature=" + this.getTemperature() + ", candidateCount=" + this.getCandidateCount() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ")";
    }

    public PalmTextRequest() {
    }

    public PalmTextRequest(TextPrompt prompt, Double temperature, Integer candidateCount, Double topP, Integer topK) {
        this.prompt = prompt;
        this.temperature = temperature;
        this.candidateCount = candidateCount;
        this.topP = topP;
        this.topK = topK;
    }

    public static class PalmTextRequestBuilder {
        private TextPrompt prompt;
        private Double temperature;
        private Integer candidateCount;
        private Double topP;
        private Integer topK;

        PalmTextRequestBuilder() {
        }

        public PalmTextRequestBuilder prompt(TextPrompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public PalmTextRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="candidate_count")
        public PalmTextRequestBuilder candidateCount(Integer candidateCount) {
            this.candidateCount = candidateCount;
            return this;
        }

        public PalmTextRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public PalmTextRequestBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public PalmTextRequest build() {
            return new PalmTextRequest(this.prompt, this.temperature, this.candidateCount, this.topP, this.topK);
        }

        public String toString() {
            return "PalmTextRequest.PalmTextRequestBuilder(prompt=" + this.prompt + ", temperature=" + this.temperature + ", candidateCount=" + this.candidateCount + ", topP=" + this.topP + ", topK=" + this.topK + ")";
        }
    }
}

