/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.session;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.aliyun.AliModelExecutor;
import cn.bugstack.openai.executor.model.aliyun.config.AliModelConfig;
import cn.bugstack.openai.executor.model.baidu.BaiduModelExecutor;
import cn.bugstack.openai.executor.model.baidu.config.BaiduConfig;
import cn.bugstack.openai.executor.model.brain360.Brain360ModelExecutor;
import cn.bugstack.openai.executor.model.brain360.config.Brain360Config;
import cn.bugstack.openai.executor.model.chatglm.ChatGLMModelExecutor;
import cn.bugstack.openai.executor.model.chatglm.config.ChatGLMConfig;
import cn.bugstack.openai.executor.model.chatgpt.ChatGPTModelExecutor;
import cn.bugstack.openai.executor.model.chatgpt.config.ChatGPTConfig;
import cn.bugstack.openai.executor.model.claude.config.ClaudeConfig;
import cn.bugstack.openai.executor.model.google.GeminiProTextModelExecutor;
import cn.bugstack.openai.executor.model.google.PalmChatModelExecutor;
import cn.bugstack.openai.executor.model.google.PalmTextModelExecutor;
import cn.bugstack.openai.executor.model.google.config.GeminiProConfig;
import cn.bugstack.openai.executor.model.google.config.PalmConfig;
import cn.bugstack.openai.executor.model.tencent.TencentModelExecutor;
import cn.bugstack.openai.executor.model.tencent.config.TencentConfig;
import cn.bugstack.openai.executor.model.xunfei.XunFeiModelExecutor;
import cn.bugstack.openai.executor.model.xunfei.config.XunFeiConfig;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import java.util.HashMap;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private ChatGLMConfig chatGLMConfig;
    private ChatGPTConfig chatGPTConfig;
    private XunFeiConfig xunFeiConfig;
    private AliModelConfig aliModelConfig;
    private BaiduConfig baiduConfig;
    private TencentConfig tencentConfig;
    private PalmConfig palmConfig;
    private Brain360Config brain360Config;
    private ClaudeConfig claudeConfig;
    private GeminiProConfig geminiProConfig;
    private OkHttpClient okHttpClient;
    private HashMap<String, Executor> executorGroup;
    private HttpLoggingInterceptor.Level level = HttpLoggingInterceptor.Level.HEADERS;
    private long connectTimeout = 4500L;
    private long writeTimeout = 4500L;
    private long readTimeout = 4500L;
    public static final String SSE_CONTENT_TYPE = "text/event-stream";
    public static final String DEFAULT_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)";
    public static final String APPLICATION_JSON = "application/json";
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";

    public EventSource.Factory createRequestFactory() {
        return EventSources.createFactory((OkHttpClient)this.okHttpClient);
    }

    public HashMap<String, Executor> newExecutorGroup() {
        this.executorGroup = new HashMap();
        ChatGLMModelExecutor chatGLMModelExecutor = new ChatGLMModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.CHATGLM_TURBO.getCode(), chatGLMModelExecutor);
        ChatGPTModelExecutor chatGPTModelExecutor = new ChatGPTModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.GPT_3_5_TURBO.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.GPT_3_5_TURBO_1106.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.GPT_3_5_TURBO_16K.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.GPT_4.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.GPT_4_32K.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.DALL_E_2.getCode(), chatGPTModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.DALL_E_3.getCode(), chatGPTModelExecutor);
        XunFeiModelExecutor xunfeiModelExecutor = new XunFeiModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.XUNFEI.getCode(), xunfeiModelExecutor);
        AliModelExecutor aliModelExecutor = new AliModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.QWEN_TURBO.getCode(), aliModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.QWEN_PLUS.getCode(), aliModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.QWEN_MAX.getCode(), aliModelExecutor);
        BaiduModelExecutor wenXinModelExecutor = new BaiduModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.ERNIE_BOT_TURBO.getCode(), wenXinModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.ERNIE_BOT.getCode(), wenXinModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.ERNIE_Bot_4.getCode(), wenXinModelExecutor);
        this.executorGroup.put(CompletionRequest.Model.ERNIE_Bot_8K.getCode(), wenXinModelExecutor);
        TencentModelExecutor tencentExecutor = new TencentModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.HUNYUAN_CHATSTD.getCode(), tencentExecutor);
        this.executorGroup.put(CompletionRequest.Model.HUNYUAN_CHATPRO.getCode(), tencentExecutor);
        Brain360ModelExecutor brain360Executor = new Brain360ModelExecutor(this);
        this.executorGroup.put(CompletionRequest.Model.Brain_360GPT_S2_V9.getCode(), brain360Executor);
        this.executorGroup.put(CompletionRequest.Model.PALM_CHAT.getCode(), new PalmChatModelExecutor(this));
        this.executorGroup.put(CompletionRequest.Model.PALM_TEXT.getCode(), new PalmTextModelExecutor(this));
        this.executorGroup.put(CompletionRequest.Model.TEXT_GEMINI_PRO.getCode(), new GeminiProTextModelExecutor(this));
        return this.executorGroup;
    }

    public ChatGLMConfig getChatGLMConfig() {
        return this.chatGLMConfig;
    }

    public ChatGPTConfig getChatGPTConfig() {
        return this.chatGPTConfig;
    }

    public XunFeiConfig getXunFeiConfig() {
        return this.xunFeiConfig;
    }

    public AliModelConfig getAliModelConfig() {
        return this.aliModelConfig;
    }

    public BaiduConfig getBaiduConfig() {
        return this.baiduConfig;
    }

    public TencentConfig getTencentConfig() {
        return this.tencentConfig;
    }

    public PalmConfig getPalmConfig() {
        return this.palmConfig;
    }

    public Brain360Config getBrain360Config() {
        return this.brain360Config;
    }

    public ClaudeConfig getClaudeConfig() {
        return this.claudeConfig;
    }

    public GeminiProConfig getGeminiProConfig() {
        return this.geminiProConfig;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public HashMap<String, Executor> getExecutorGroup() {
        return this.executorGroup;
    }

    public HttpLoggingInterceptor.Level getLevel() {
        return this.level;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setChatGLMConfig(ChatGLMConfig chatGLMConfig) {
        this.chatGLMConfig = chatGLMConfig;
    }

    public void setChatGPTConfig(ChatGPTConfig chatGPTConfig) {
        this.chatGPTConfig = chatGPTConfig;
    }

    public void setXunFeiConfig(XunFeiConfig xunFeiConfig) {
        this.xunFeiConfig = xunFeiConfig;
    }

    public void setAliModelConfig(AliModelConfig aliModelConfig) {
        this.aliModelConfig = aliModelConfig;
    }

    public void setBaiduConfig(BaiduConfig baiduConfig) {
        this.baiduConfig = baiduConfig;
    }

    public void setTencentConfig(TencentConfig tencentConfig) {
        this.tencentConfig = tencentConfig;
    }

    public void setPalmConfig(PalmConfig palmConfig) {
        this.palmConfig = palmConfig;
    }

    public void setBrain360Config(Brain360Config brain360Config) {
        this.brain360Config = brain360Config;
    }

    public void setClaudeConfig(ClaudeConfig claudeConfig) {
        this.claudeConfig = claudeConfig;
    }

    public void setGeminiProConfig(GeminiProConfig geminiProConfig) {
        this.geminiProConfig = geminiProConfig;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public void setExecutorGroup(HashMap<String, Executor> executorGroup) {
        this.executorGroup = executorGroup;
    }

    public void setLevel(HttpLoggingInterceptor.Level level) {
        this.level = level;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        ChatGLMConfig this$chatGLMConfig = this.getChatGLMConfig();
        ChatGLMConfig other$chatGLMConfig = other.getChatGLMConfig();
        if (this$chatGLMConfig == null ? other$chatGLMConfig != null : !this$chatGLMConfig.equals(other$chatGLMConfig)) {
            return false;
        }
        ChatGPTConfig this$chatGPTConfig = this.getChatGPTConfig();
        ChatGPTConfig other$chatGPTConfig = other.getChatGPTConfig();
        if (this$chatGPTConfig == null ? other$chatGPTConfig != null : !this$chatGPTConfig.equals(other$chatGPTConfig)) {
            return false;
        }
        XunFeiConfig this$xunFeiConfig = this.getXunFeiConfig();
        XunFeiConfig other$xunFeiConfig = other.getXunFeiConfig();
        if (this$xunFeiConfig == null ? other$xunFeiConfig != null : !((Object)this$xunFeiConfig).equals(other$xunFeiConfig)) {
            return false;
        }
        AliModelConfig this$aliModelConfig = this.getAliModelConfig();
        AliModelConfig other$aliModelConfig = other.getAliModelConfig();
        if (this$aliModelConfig == null ? other$aliModelConfig != null : !this$aliModelConfig.equals(other$aliModelConfig)) {
            return false;
        }
        BaiduConfig this$baiduConfig = this.getBaiduConfig();
        BaiduConfig other$baiduConfig = other.getBaiduConfig();
        if (this$baiduConfig == null ? other$baiduConfig != null : !this$baiduConfig.equals(other$baiduConfig)) {
            return false;
        }
        TencentConfig this$tencentConfig = this.getTencentConfig();
        TencentConfig other$tencentConfig = other.getTencentConfig();
        if (this$tencentConfig == null ? other$tencentConfig != null : !((Object)this$tencentConfig).equals(other$tencentConfig)) {
            return false;
        }
        PalmConfig this$palmConfig = this.getPalmConfig();
        PalmConfig other$palmConfig = other.getPalmConfig();
        if (this$palmConfig == null ? other$palmConfig != null : !this$palmConfig.equals(other$palmConfig)) {
            return false;
        }
        Brain360Config this$brain360Config = this.getBrain360Config();
        Brain360Config other$brain360Config = other.getBrain360Config();
        if (this$brain360Config == null ? other$brain360Config != null : !this$brain360Config.equals(other$brain360Config)) {
            return false;
        }
        ClaudeConfig this$claudeConfig = this.getClaudeConfig();
        ClaudeConfig other$claudeConfig = other.getClaudeConfig();
        if (this$claudeConfig == null ? other$claudeConfig != null : !this$claudeConfig.equals(other$claudeConfig)) {
            return false;
        }
        GeminiProConfig this$geminiProConfig = this.getGeminiProConfig();
        GeminiProConfig other$geminiProConfig = other.getGeminiProConfig();
        if (this$geminiProConfig == null ? other$geminiProConfig != null : !this$geminiProConfig.equals(other$geminiProConfig)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        HashMap<String, Executor> this$executorGroup = this.getExecutorGroup();
        HashMap<String, Executor> other$executorGroup = other.getExecutorGroup();
        if (this$executorGroup == null ? other$executorGroup != null : !((Object)this$executorGroup).equals(other$executorGroup)) {
            return false;
        }
        HttpLoggingInterceptor.Level this$level = this.getLevel();
        HttpLoggingInterceptor.Level other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $connectTimeout = this.getConnectTimeout();
        result = result * 59 + (int)($connectTimeout >>> 32 ^ $connectTimeout);
        long $writeTimeout = this.getWriteTimeout();
        result = result * 59 + (int)($writeTimeout >>> 32 ^ $writeTimeout);
        long $readTimeout = this.getReadTimeout();
        result = result * 59 + (int)($readTimeout >>> 32 ^ $readTimeout);
        ChatGLMConfig $chatGLMConfig = this.getChatGLMConfig();
        result = result * 59 + ($chatGLMConfig == null ? 43 : $chatGLMConfig.hashCode());
        ChatGPTConfig $chatGPTConfig = this.getChatGPTConfig();
        result = result * 59 + ($chatGPTConfig == null ? 43 : $chatGPTConfig.hashCode());
        XunFeiConfig $xunFeiConfig = this.getXunFeiConfig();
        result = result * 59 + ($xunFeiConfig == null ? 43 : ((Object)$xunFeiConfig).hashCode());
        AliModelConfig $aliModelConfig = this.getAliModelConfig();
        result = result * 59 + ($aliModelConfig == null ? 43 : $aliModelConfig.hashCode());
        BaiduConfig $baiduConfig = this.getBaiduConfig();
        result = result * 59 + ($baiduConfig == null ? 43 : $baiduConfig.hashCode());
        TencentConfig $tencentConfig = this.getTencentConfig();
        result = result * 59 + ($tencentConfig == null ? 43 : ((Object)$tencentConfig).hashCode());
        PalmConfig $palmConfig = this.getPalmConfig();
        result = result * 59 + ($palmConfig == null ? 43 : $palmConfig.hashCode());
        Brain360Config $brain360Config = this.getBrain360Config();
        result = result * 59 + ($brain360Config == null ? 43 : $brain360Config.hashCode());
        ClaudeConfig $claudeConfig = this.getClaudeConfig();
        result = result * 59 + ($claudeConfig == null ? 43 : $claudeConfig.hashCode());
        GeminiProConfig $geminiProConfig = this.getGeminiProConfig();
        result = result * 59 + ($geminiProConfig == null ? 43 : $geminiProConfig.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        HashMap<String, Executor> $executorGroup = this.getExecutorGroup();
        result = result * 59 + ($executorGroup == null ? 43 : ((Object)$executorGroup).hashCode());
        HttpLoggingInterceptor.Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(chatGLMConfig=" + this.getChatGLMConfig() + ", chatGPTConfig=" + this.getChatGPTConfig() + ", xunFeiConfig=" + this.getXunFeiConfig() + ", aliModelConfig=" + this.getAliModelConfig() + ", baiduConfig=" + this.getBaiduConfig() + ", tencentConfig=" + this.getTencentConfig() + ", palmConfig=" + this.getPalmConfig() + ", brain360Config=" + this.getBrain360Config() + ", claudeConfig=" + this.getClaudeConfig() + ", geminiProConfig=" + this.getGeminiProConfig() + ", okHttpClient=" + this.getOkHttpClient() + ", executorGroup=" + this.getExecutorGroup() + ", level=" + this.getLevel() + ", connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }
}

