/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.service;

import cn.eppdev.jee.conf.entity.EppdevConf;
import cn.eppdev.jee.conf.param.EppdevConfParam;
import cn.eppdev.jee.conf.service.auto._EppdevConfService;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EppdevConfService
extends _EppdevConfService {
    static ConcurrentHashMap<String, String> CACHED_MAP = new ConcurrentHashMap();
    @Value(value="${eppdev.author.name:#{null}}")
    String authorName;
    @Value(value="${eppdev.author.mail:#{null}}")
    String authorMail;
    @Value(value="${eppdev.project.path:#{null}}")
    String projectPath;
    @Value(value="${eppdev.git.path:#{null}}")
    String gitPath;
    @Value(value="${eppdev.git.auto-push:#{null}}")
    String gitAuthPush;
    @Value(value="${eppdev.git.use-new-branch:#{null}}")
    String gitUseNewBrach;
    @Value(value="${eppdev.git.main-branch-name:#{null}}")
    String gitMainBranchName;
    @Value(value="${spring.datasource.url:#{null}}")
    String dbUrl;
    @Value(value="${spring.datasource.username:#{null}}")
    String dbUsername;
    @Value(value="${spring.datasource.password:#{null}}")
    String dbPassword;

    @Override
    public void customeInit(EppdevConf entity) {
    }

    public String getConf(String key) {
        return this.getAllConf().get(key);
    }

    @Override
    public PageInfo<EppdevConf> listAll() {
        PageInfo pageInfo = super.listAll();
        return this.loadLocalConfig(pageInfo);
    }

    @Override
    public PageInfo<EppdevConf> list(EppdevConfParam param) {
        PageInfo pageInfo = super.list(param);
        return this.loadLocalConfig(pageInfo);
    }

    PageInfo<EppdevConf> loadLocalConfig(PageInfo<EppdevConf> pageInfo) {
        for (EppdevConf conf : pageInfo.getList()) {
            if (conf.getConfName().equals("AUTHOR_NAME") && this.authorName != null && this.authorName.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.authorName);
                continue;
            }
            if (conf.getConfName().equals("AUTHOR_EMAIL") && this.authorMail != null && this.authorMail.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.authorMail);
                continue;
            }
            if (conf.getConfName().equals("PROJECT_PATH") && this.projectPath != null && this.projectPath.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.projectPath);
                continue;
            }
            if (conf.getConfName().equals("GIT_PATH") && this.gitPath != null && this.gitPath.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.gitPath);
                continue;
            }
            if (conf.getConfName().equals("GIT_AUTO_PUSH") && this.gitAuthPush != null && this.gitAuthPush.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.gitAuthPush);
                continue;
            }
            if (conf.getConfName().equals("GIT_USE_NEW_BRANCH") && this.gitUseNewBrach != null && this.gitUseNewBrach.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.gitUseNewBrach);
                continue;
            }
            if (conf.getConfName().equals("GIT_MAIN_BRANCH_NAME") && this.gitMainBranchName != null && this.gitMainBranchName.trim().length() > 0) {
                conf.setOverrided(true);
                conf.setConfValue(this.gitMainBranchName);
                continue;
            }
            conf.setOverrided(false);
        }
        return pageInfo;
    }

    public Map<String, String> getAllConf() {
        if (((ConcurrentHashMap.CollectionView)((Object)CACHED_MAP.keySet())).size() == 0) {
            for (EppdevConf conf : this.listAll().getList()) {
                CACHED_MAP.put(conf.getConfName(), conf.getConfValue());
            }
            if (this.dbUrl != null) {
                CACHED_MAP.put("dbUrl", this.dbUrl);
            }
            if (this.dbUsername != null) {
                CACHED_MAP.put("dbUsername", this.dbUsername);
            }
            if (this.dbPassword != null) {
                CACHED_MAP.put("dbPassword", this.dbPassword);
            }
        }
        return CACHED_MAP;
    }

    public String getDbType() {
        return this.getAllConf().get("DB_TYPE");
    }

    public String getProjectPath() {
        return this.getAllConf().get("PROJECT_PATH");
    }

    public String getBasicPackageName() {
        return this.getAllConf().get("BASIC_PACKAGE_NAME");
    }

    public String getGitPath() {
        return this.getAllConf().get("GIT_PATH");
    }

    public String getGitAutoPush() {
        return this.getAllConf().get("GIT_AUTO_PUSH");
    }

    public String getGitUseNewBranch() {
        return this.getAllConf().get("GIT_USE_NEW_BRANCH");
    }

    public String getGitMainBranchName() {
        return this.getAllConf().get("GIT_MAIN_BRANCH_NAME");
    }

    @Override
    public int update(EppdevConf entity) {
        int cnt = super.update(entity);
        if (cnt > 0) {
            CACHED_MAP.put(entity.getConfName(), entity.getConfValue());
        }
        return cnt;
    }
}

