/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.pool;

import ai.djl.inference.Predictor;
import ai.djl.repository.zoo.ZooModel;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredictorFactory<I, O>
extends BasePooledObjectFactory<Predictor<I, O>> {
    private static final Logger log = LoggerFactory.getLogger(PredictorFactory.class);
    private final ZooModel<I, O> model;

    public PredictorFactory(ZooModel<I, O> model) {
        this.model = model;
    }

    public Predictor<I, O> create() {
        log.debug("create predictor");
        return this.model.newPredictor();
    }

    public PooledObject<Predictor<I, O>> wrap(Predictor<I, O> predictor) {
        return new DefaultPooledObject(predictor);
    }

    public void destroyObject(PooledObject<Predictor<I, O>> p) {
        log.debug("close predictor");
        ((Predictor)p.getObject()).close();
    }
}

