/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.utils;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;

public class SVDUtils {
    public static NDArray transformationFromPoints(NDManager manager, NDArray points1, NDArray points2) {
        int j;
        int i;
        NDArray c1 = points1.mean(new int[]{0});
        NDArray c2 = points2.mean(new int[]{0});
        points1 = points1.sub(c1);
        points2 = points2.sub(c2);
        double s1 = SVDUtils.std(points1);
        double s2 = SVDUtils.std(points2);
        NDArray djl_s1 = manager.create(s1);
        NDArray djl_s2 = manager.create(s2);
        points1 = points1.div(djl_s1);
        points2 = points2.div(djl_s2);
        double[] points1D = points1.toDoubleArray();
        double[] points2D = points2.toDoubleArray();
        double[][] m1 = new double[5][2];
        double[][] m2 = new double[5][2];
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 2; ++j) {
                m1[i][j] = points1D[i * 2 + j];
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 2; ++j) {
                m2[i][j] = points2D[i * 2 + j];
            }
        }
        Matrix p1 = new Matrix(m1);
        Matrix p2 = new Matrix(m2);
        Matrix p3 = p1.transpose().times(p2);
        SingularValueDecomposition s = p3.svd();
        Matrix U = s.getU();
        Matrix S = s.getS();
        Matrix V = s.getV();
        m1 = U.getArray();
        m1[0][1] = -m1[0][1];
        m1[1][1] = -m1[1][1];
        m2 = V.getArray();
        m2[0][1] = -m2[0][1];
        m2[1][1] = -m2[1][1];
        Matrix R2 = U.times(V).transpose();
        double[][] rArray = R2.getArray();
        NDArray newR = manager.create(rArray);
        NDArray leftPart = djl_s2.div(djl_s1).mul(newR);
        NDArray rightPart = c2.reshape(new long[]{2L, 1L}).sub(leftPart.matMul(c1.reshape(new long[]{2L, 1L})));
        NDArray upPart = leftPart.concat(rightPart, 1);
        double[] downArray = new double[]{0.0, 0.0, 1.0};
        NDArray downPart = manager.create(downArray).reshape(new long[]{1L, 3L});
        NDArray all = upPart.concat(downPart, 0);
        return upPart;
    }

    public static double std(NDArray points) {
        points = points.square();
        double[] doubleResult = points.toDoubleArray();
        double std = 0.0;
        for (int i = 0; i < doubleResult.length; ++i) {
            std += doubleResult[i];
        }
        std = (float)Math.sqrt(std / (double)doubleResult.length);
        return std;
    }
}

