/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.utils;

import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;

public class VideoUtils {
    public static void rotateVideo(String inputPath, String outputPath, int angle, String format, int videoCodec) throws FFmpegFrameRecorder.Exception, FFmpegFrameGrabber.Exception {
        Frame frame;
        FFmpegFrameGrabber grabber = new FFmpegFrameGrabber(inputPath);
        grabber.start();
        int inputWidth = grabber.getImageWidth();
        int inputHeight = grabber.getImageHeight();
        int outputWidth = inputWidth;
        int outputHeight = inputHeight;
        if (angle == 90 || angle == 270) {
            outputWidth = inputHeight;
            outputHeight = inputWidth;
        }
        FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputPath, outputWidth, outputHeight, grabber.getAudioChannels());
        recorder.setVideoCodec(videoCodec);
        recorder.setFormat(format);
        recorder.start();
        OpenCVFrameConverter.ToMat converter = new OpenCVFrameConverter.ToMat();
        while ((frame = grabber.grab()) != null) {
            if (frame.image == null) continue;
            Mat mat = converter.convert(frame);
            Mat rotated = new Mat();
            switch (angle) {
                case 90: {
                    opencv_core.transpose((Mat)mat, (Mat)rotated);
                    opencv_core.flip((Mat)rotated, (Mat)rotated, (int)1);
                    break;
                }
                case 180: {
                    opencv_core.flip((Mat)mat, (Mat)rotated, (int)-1);
                    break;
                }
                case 270: {
                    opencv_core.transpose((Mat)mat, (Mat)rotated);
                    opencv_core.flip((Mat)rotated, (Mat)rotated, (int)0);
                    break;
                }
                default: {
                    rotated = mat.clone();
                }
            }
            frame = converter.convert(rotated);
            recorder.record(frame);
        }
        recorder.stop();
        recorder.release();
        grabber.stop();
        grabber.release();
    }
}

