/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.config;

import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.config.FaceExtractConfig;
import cn.smartjavaai.face.enums.FaceModelEnum;

public class FaceModelConfig {
    private FaceModelEnum modelEnum;
    private double confidenceThreshold = 0.85f;
    private double similarityThreshold = 0.0;
    private double nmsThresh = 0.45f;
    private String modelPath;
    private String faceDbPath;
    private DeviceEnum device;
    private int gpuId = 0;
    private FaceExtractConfig extractConfig;

    public FaceModelConfig() {
    }

    public FaceModelConfig(FaceModelEnum modelEnum) {
        this.modelEnum = modelEnum;
    }

    public FaceModelConfig(FaceModelEnum modelEnum, String modelPath) {
        this.modelEnum = modelEnum;
        this.modelPath = modelPath;
    }

    public FaceModelEnum getModelEnum() {
        return this.modelEnum;
    }

    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public double getNmsThresh() {
        return this.nmsThresh;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getFaceDbPath() {
        return this.faceDbPath;
    }

    public DeviceEnum getDevice() {
        return this.device;
    }

    public int getGpuId() {
        return this.gpuId;
    }

    public FaceExtractConfig getExtractConfig() {
        return this.extractConfig;
    }

    public void setModelEnum(FaceModelEnum modelEnum) {
        this.modelEnum = modelEnum;
    }

    public void setConfidenceThreshold(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public void setSimilarityThreshold(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public void setNmsThresh(double nmsThresh) {
        this.nmsThresh = nmsThresh;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public void setFaceDbPath(String faceDbPath) {
        this.faceDbPath = faceDbPath;
    }

    public void setDevice(DeviceEnum device) {
        this.device = device;
    }

    public void setGpuId(int gpuId) {
        this.gpuId = gpuId;
    }

    public void setExtractConfig(FaceExtractConfig extractConfig) {
        this.extractConfig = extractConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FaceModelConfig)) {
            return false;
        }
        FaceModelConfig other = (FaceModelConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FaceModelEnum this$modelEnum = this.getModelEnum();
        FaceModelEnum other$modelEnum = other.getModelEnum();
        if (this$modelEnum == null ? other$modelEnum != null : !((Object)((Object)this$modelEnum)).equals((Object)other$modelEnum)) {
            return false;
        }
        if (Double.compare(this.getConfidenceThreshold(), other.getConfidenceThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getSimilarityThreshold(), other.getSimilarityThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getNmsThresh(), other.getNmsThresh()) != 0) {
            return false;
        }
        String this$modelPath = this.getModelPath();
        String other$modelPath = other.getModelPath();
        if (this$modelPath == null ? other$modelPath != null : !this$modelPath.equals(other$modelPath)) {
            return false;
        }
        String this$faceDbPath = this.getFaceDbPath();
        String other$faceDbPath = other.getFaceDbPath();
        if (this$faceDbPath == null ? other$faceDbPath != null : !this$faceDbPath.equals(other$faceDbPath)) {
            return false;
        }
        DeviceEnum this$device = this.getDevice();
        DeviceEnum other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        if (this.getGpuId() != other.getGpuId()) {
            return false;
        }
        FaceExtractConfig this$extractConfig = this.getExtractConfig();
        FaceExtractConfig other$extractConfig = other.getExtractConfig();
        return !(this$extractConfig == null ? other$extractConfig != null : !((Object)this$extractConfig).equals(other$extractConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FaceModelConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FaceModelEnum $modelEnum = this.getModelEnum();
        result = result * 59 + ($modelEnum == null ? 43 : ((Object)((Object)$modelEnum)).hashCode());
        long $confidenceThreshold = Double.doubleToLongBits(this.getConfidenceThreshold());
        result = result * 59 + (int)($confidenceThreshold >>> 32 ^ $confidenceThreshold);
        long $similarityThreshold = Double.doubleToLongBits(this.getSimilarityThreshold());
        result = result * 59 + (int)($similarityThreshold >>> 32 ^ $similarityThreshold);
        long $nmsThresh = Double.doubleToLongBits(this.getNmsThresh());
        result = result * 59 + (int)($nmsThresh >>> 32 ^ $nmsThresh);
        String $modelPath = this.getModelPath();
        result = result * 59 + ($modelPath == null ? 43 : $modelPath.hashCode());
        String $faceDbPath = this.getFaceDbPath();
        result = result * 59 + ($faceDbPath == null ? 43 : $faceDbPath.hashCode());
        DeviceEnum $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        result = result * 59 + this.getGpuId();
        FaceExtractConfig $extractConfig = this.getExtractConfig();
        result = result * 59 + ($extractConfig == null ? 43 : ((Object)$extractConfig).hashCode());
        return result;
    }

    public String toString() {
        return "FaceModelConfig(modelEnum=" + (Object)((Object)this.getModelEnum()) + ", confidenceThreshold=" + this.getConfidenceThreshold() + ", similarityThreshold=" + this.getSimilarityThreshold() + ", nmsThresh=" + this.getNmsThresh() + ", modelPath=" + this.getModelPath() + ", faceDbPath=" + this.getFaceDbPath() + ", device=" + this.getDevice() + ", gpuId=" + this.getGpuId() + ", extractConfig=" + this.getExtractConfig() + ")";
    }
}

