/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.config;

import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.face.enums.LivenessModelEnum;

public class LivenessConfig {
    private LivenessModelEnum modelEnum = LivenessModelEnum.SEETA_FACE6_MODEL;
    private String modelPath;
    private DeviceEnum device;
    private int gpuId = 0;
    private float faceClarityThreshold = 0.3f;
    private float realityThreshold = 0.8f;
    private int frameCount = 10;

    public LivenessConfig() {
    }

    public LivenessConfig(LivenessModelEnum modelEnum) {
        this.modelEnum = modelEnum;
    }

    public LivenessConfig(LivenessModelEnum modelEnum, String modelPath) {
        this.modelEnum = modelEnum;
        this.modelPath = modelPath;
    }

    public LivenessConfig(String modelPath) {
        this.modelPath = modelPath;
    }

    public LivenessModelEnum getModelEnum() {
        return this.modelEnum;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public DeviceEnum getDevice() {
        return this.device;
    }

    public int getGpuId() {
        return this.gpuId;
    }

    public float getFaceClarityThreshold() {
        return this.faceClarityThreshold;
    }

    public float getRealityThreshold() {
        return this.realityThreshold;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setModelEnum(LivenessModelEnum modelEnum) {
        this.modelEnum = modelEnum;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public void setDevice(DeviceEnum device) {
        this.device = device;
    }

    public void setGpuId(int gpuId) {
        this.gpuId = gpuId;
    }

    public void setFaceClarityThreshold(float faceClarityThreshold) {
        this.faceClarityThreshold = faceClarityThreshold;
    }

    public void setRealityThreshold(float realityThreshold) {
        this.realityThreshold = realityThreshold;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LivenessConfig)) {
            return false;
        }
        LivenessConfig other = (LivenessConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LivenessModelEnum this$modelEnum = this.getModelEnum();
        LivenessModelEnum other$modelEnum = other.getModelEnum();
        if (this$modelEnum == null ? other$modelEnum != null : !((Object)((Object)this$modelEnum)).equals((Object)other$modelEnum)) {
            return false;
        }
        String this$modelPath = this.getModelPath();
        String other$modelPath = other.getModelPath();
        if (this$modelPath == null ? other$modelPath != null : !this$modelPath.equals(other$modelPath)) {
            return false;
        }
        DeviceEnum this$device = this.getDevice();
        DeviceEnum other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        if (this.getGpuId() != other.getGpuId()) {
            return false;
        }
        if (Float.compare(this.getFaceClarityThreshold(), other.getFaceClarityThreshold()) != 0) {
            return false;
        }
        if (Float.compare(this.getRealityThreshold(), other.getRealityThreshold()) != 0) {
            return false;
        }
        return this.getFrameCount() == other.getFrameCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LivenessConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LivenessModelEnum $modelEnum = this.getModelEnum();
        result = result * 59 + ($modelEnum == null ? 43 : ((Object)((Object)$modelEnum)).hashCode());
        String $modelPath = this.getModelPath();
        result = result * 59 + ($modelPath == null ? 43 : $modelPath.hashCode());
        DeviceEnum $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        result = result * 59 + this.getGpuId();
        result = result * 59 + Float.floatToIntBits(this.getFaceClarityThreshold());
        result = result * 59 + Float.floatToIntBits(this.getRealityThreshold());
        result = result * 59 + this.getFrameCount();
        return result;
    }

    public String toString() {
        return "LivenessConfig(modelEnum=" + (Object)((Object)this.getModelEnum()) + ", modelPath=" + this.getModelPath() + ", device=" + this.getDevice() + ", gpuId=" + this.getGpuId() + ", faceClarityThreshold=" + this.getFaceClarityThreshold() + ", realityThreshold=" + this.getRealityThreshold() + ", frameCount=" + this.getFrameCount() + ")";
    }
}

