/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.dao;

import cn.smartjavaai.face.entity.FaceData;
import cn.smartjavaai.face.sqllite.RowMapper;
import cn.smartjavaai.face.sqllite.SqliteHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDao {
    private static final Logger log = LoggerFactory.getLogger(FaceDao.class);
    private static final String TABLE_NAME_IMG = "face";
    private String dbFilePath;

    public FaceDao(String dbFilePath) {
        this.dbFilePath = dbFilePath;
    }

    public void save(FaceData faceData) throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        sqliteHelper.executeUpdate("INSERT OR REPLACE INTO face (\"index\",\"key\",\"img_data\",\"width\",\"height\",\"channel\") VALUES (?,?,?,?,?,?)", new Object[]{faceData.getIndex(), faceData.getKey(), faceData.getImgData(), faceData.getWidth(), faceData.getHeight(), faceData.getChannel()});
    }

    public String findKeyByIndex(long index) throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        return sqliteHelper.executeQuery("select \"key\" from face where \"index\"=" + index);
    }

    public long deleteAll() throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        long rows = sqliteHelper.executeUpdate("delete from face");
        return rows;
    }

    public List<Long> findIndexList(String ... keys) throws SQLException, ClassNotFoundException {
        String inKeys = Arrays.stream(keys).map(s -> "'" + s + "'").reduce((s1, s2) -> s1 + "," + s2).orElse("");
        String sql = "select \"index\" from face where \"key\" in (" + inKeys + ")";
        log.info("sql\uff1a{}", (Object)sql.toString());
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        return sqliteHelper.executeQuery(sql, new RowMapper<Long>(){

            @Override
            public Long mapRow(ResultSet rs, int index) throws SQLException {
                return rs.getLong(1);
            }
        });
    }

    public boolean deleteFace(String ... keys) throws SQLException, ClassNotFoundException {
        String inKeys = Arrays.stream(keys).map(s -> "'" + s + "'").reduce((s1, s2) -> s1 + "," + s2).orElse("");
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        String sql = "delete from face where \"key\" in (" + inKeys + ")";
        log.info("sql\uff1a{}", (Object)sql.toString());
        sqliteHelper.executeUpdate(sql);
        return true;
    }

    public List<FaceData> findFace(int pageNo, int pageSize) throws SQLException, ClassNotFoundException {
        String sql = "select \"key\",\"img_data\",\"width\",\"height\",\"channel\" from face limit " + pageNo * pageSize + "," + pageSize;
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        return sqliteHelper.executeQuery(sql, new RowMapper<FaceData>(){

            @Override
            public FaceData mapRow(ResultSet rs, int index) throws SQLException {
                FaceData face = new FaceData();
                face.setKey(rs.getString("key"));
                face.setImgData(rs.getBytes("img_data"));
                face.setWidth(rs.getInt("width"));
                face.setHeight(rs.getInt("height"));
                face.setChannel(rs.getInt("channel"));
                return face;
            }
        });
    }

    public int updateIndex(long index, FaceData faceData) throws SQLException, ClassNotFoundException {
        SqliteHelper sqliteHelper = new SqliteHelper(this.dbFilePath);
        return sqliteHelper.executeUpdate("INSERT OR REPLACE INTO face (\"index\",\"key\",\"img_data\",\"width\",\"height\",\"channel\") VALUES (?,?,?,?,?,?)", new Object[]{index, faceData.getKey(), faceData.getImgData(), faceData.getWidth(), faceData.getHeight(), faceData.getChannel()});
    }
}

