/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceAttributeConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.attribute.FaceAttributeModel;
import cn.smartjavaai.face.model.attribute.Seetaface6FaceAttributeModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceAttributeModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceAttributeModelFactory.class);
    private static volatile FaceAttributeModelFactory instance;
    private static final ConcurrentHashMap<String, FaceAttributeModel> modelMap;
    private static final Map<String, Class<? extends FaceAttributeModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceAttributeModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceAttributeModelFactory> clazz = FaceAttributeModelFactory.class;
        synchronized (FaceAttributeModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceAttributeModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(String name, Class<? extends FaceAttributeModel> clazz) {
        registry.put(name.toLowerCase(), clazz);
    }

    public FaceAttributeModel getModel(FaceAttributeConfig config) {
        if (Objects.isNull(config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> this.createFaceModel(config));
    }

    private FaceAttributeModel createFaceModel(FaceAttributeConfig config) {
        Class<? extends FaceAttributeModel> clazz = registry.get(config.getModelEnum().getModelClassName().toLowerCase());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        FaceAttributeModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<String, Class<? extends FaceAttributeModel>>();
        FaceAttributeModelFactory.registerModel("seetaface6model", Seetaface6FaceAttributeModel.class);
        log.info("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

