/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceModelConfig;
import cn.smartjavaai.face.enums.FaceModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facerec.FaceModel;
import cn.smartjavaai.face.model.facerec.FeatureExtractionModel;
import cn.smartjavaai.face.model.facerec.RetinaFaceModel;
import cn.smartjavaai.face.model.facerec.SeetaFace6Model;
import cn.smartjavaai.face.model.facerec.UltraLightFastGenericFaceModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceModelFactory.class);
    private static volatile FaceModelFactory instance;
    private static final ConcurrentHashMap<String, FaceModel> modelMap;
    private static final Map<String, Class<? extends FaceModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceModelFactory> clazz = FaceModelFactory.class;
        synchronized (FaceModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerAlgorithm(String name, Class<? extends FaceModel> clazz) {
        registry.put(name.toLowerCase(), clazz);
    }

    public FaceModel getModel(FaceModelConfig config) {
        if (Objects.isNull(config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u4eba\u8138\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> this.createFaceModel(config));
    }

    public FaceModel getModel() {
        FaceModelConfig config = new FaceModelConfig();
        config.setModelEnum(FaceModelEnum.RETINA_FACE);
        config.setConfidenceThreshold(0.85f);
        config.setNmsThresh(0.45f);
        return this.getModel(config);
    }

    private FaceModel createFaceModel(FaceModelConfig config) {
        Class<? extends FaceModel> clazz = registry.get(config.getModelEnum().getModelClassName().toLowerCase());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        FaceModel algorithm = null;
        try {
            algorithm = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        algorithm.loadModel(config);
        return algorithm;
    }

    public FaceModel getLightFaceModel() {
        FaceModelConfig config = new FaceModelConfig();
        config.setModelEnum(FaceModelEnum.ULTRA_LIGHT_FAST_GENERIC_FACE);
        config.setConfidenceThreshold(0.85f);
        config.setNmsThresh(0.45f);
        return this.getModel(config);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<String, Class<? extends FaceModel>>();
        FaceModelFactory.registerAlgorithm("retinafacemodel", RetinaFaceModel.class);
        FaceModelFactory.registerAlgorithm("ultralightfastgenericfacemodel", UltraLightFastGenericFaceModel.class);
        FaceModelFactory.registerAlgorithm("featureextractionmodel", FeatureExtractionModel.class);
        FaceModelFactory.registerAlgorithm("seetaface6model", SeetaFace6Model.class);
        log.info("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

