/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.liveness.LivenessDetModel;
import cn.smartjavaai.face.model.liveness.Seetaface6LivenessModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivenessModelFactory {
    private static final Logger log = LoggerFactory.getLogger(LivenessModelFactory.class);
    private static volatile LivenessModelFactory instance;
    private static final ConcurrentHashMap<String, LivenessDetModel> modelMap;
    private static final Map<String, Class<? extends LivenessDetModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LivenessModelFactory getInstance() {
        if (instance != null) return instance;
        Class<LivenessModelFactory> clazz = LivenessModelFactory.class;
        synchronized (LivenessModelFactory.class) {
            if (instance != null) return instance;
            instance = new LivenessModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(String name, Class<? extends LivenessDetModel> clazz) {
        registry.put(name.toLowerCase(), clazz);
    }

    public LivenessDetModel getModel(LivenessConfig config) {
        if (Objects.isNull(config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> this.createFaceModel(config));
    }

    private LivenessDetModel createFaceModel(LivenessConfig config) {
        Class<? extends LivenessDetModel> clazz = registry.get(config.getModelEnum().getModelClassName().toLowerCase());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        LivenessDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<String, Class<? extends LivenessDetModel>>();
        LivenessModelFactory.registerModel("seetaface6model", Seetaface6LivenessModel.class);
        log.info("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

