/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facerec;

import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.FaceModelConfig;
import cn.smartjavaai.face.dao.FaceDao;
import cn.smartjavaai.face.entity.FaceData;
import cn.smartjavaai.face.entity.FaceResult;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facerec.AbstractFaceModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.FaceUtils;
import com.seeta.pool.FaceDatabasePool;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.FaceRecognizerPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.FaceDatabase;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.FaceRecognizer;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeetaFace6Model
extends AbstractFaceModel {
    private static final Logger log = LoggerFactory.getLogger(SeetaFace6Model.class);
    private FaceModelConfig config;
    private FaceDetectorPool faceDetectorPool;
    private FaceRecognizerPool faceRecognizerPool;
    private FaceLandmarkerPool faceLandmarkerPool;
    private FaceDatabasePool faceDatabasePool;
    public static final float SEETAFACE_DEFAULT_SIMILARITY_THRESHOLD = 0.62f;

    @Override
    public void loadModel(FaceModelConfig config) {
        this.config = config;
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        if (config.getSimilarityThreshold() <= 0.0) {
            config.setSimilarityThreshold(0.62f);
        }
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.info("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceRecognizerModelPath = new String[]{config.getModelPath() + File.separator + "face_recognizer.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = 0;
        if (Objects.nonNull(config.getDevice())) {
            SeetaDevice seetaDevice = device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
            if (config.getGpuId() >= 0 && device == SeetaDevice.SEETA_DEVICE_GPU) {
                gpuId = config.getGpuId();
            }
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceRecognizerPoolSetting = new SeetaModelSetting(gpuId, faceRecognizerModelPath, device);
            SeetaConfSetting faceRecognizerPoolConfSetting = new SeetaConfSetting(faceRecognizerPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            SeetaModelSetting faceDatabasePoolSetting = new SeetaModelSetting(gpuId, faceRecognizerModelPath, device);
            SeetaConfSetting faceDatabasePoolConfSetting = new SeetaConfSetting(faceDatabasePoolSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceRecognizerPool = new FaceRecognizerPool(faceRecognizerPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            this.faceDatabasePool = new FaceDatabasePool(faceDatabasePoolConfSetting);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info("start load faceDb...");
                        SeetaFace6Model.this.loadFaceDb();
                        log.info("Load faceDb success!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    @Override
    public DetectionResponse detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image);
    }

    @Override
    public DetectionResponse detect(InputStream imageInputStream) {
        if (Objects.isNull(imageInputStream)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageInputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.detect(image);
    }

    @Override
    public DetectionResponse detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
        imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
        FaceDetector predictor = null;
        FaceLandmarker faceLandmarker = null;
        try {
            predictor = (FaceDetector)this.faceDetectorPool.borrowObject();
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            DetectionResponse seetaResult = predictor.Detect(imageData);
            ArrayList<SeetaPointF[]> seetaPointFSList = new ArrayList<SeetaPointF[]>();
            for (SeetaRect seetaRect : seetaResult) {
                SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData, seetaRect, pointFS);
                seetaPointFSList.add(pointFS);
            }
            DetectionResponse detectionResponse = FaceUtils.convertToDetectionResponse((SeetaRect[])seetaResult, this.config, seetaPointFSList);
            return detectionResponse;
        }
        catch (Exception e) {
            throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.faceDetectorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public DetectionResponse detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public void detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            Path imageOutputPath = Paths.get(outputPath, new String[0]);
            BufferedImage image = null;
            try {
                image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
            }
            catch (IOException e) {
                throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
            }
            DetectionResponse result = this.detect(image);
            if (Objects.isNull(result) || Objects.isNull(result.getDetectionInfoList()) || result.getDetectionInfoList().isEmpty()) {
                throw new FaceException("\u672a\u8bc6\u522b\u5230\u4eba\u8138");
            }
            FaceUtils.drawBoundingBoxes(image, result, imageOutputPath.toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
    }

    @Override
    public BufferedImage detectAndDraw(BufferedImage sourceImage) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        DetectionResponse detectedObjects = this.detect(sourceImage);
        if (Objects.isNull(detectedObjects) || Objects.isNull(detectedObjects.getDetectionInfoList()) || detectedObjects.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u672a\u8bc6\u522b\u5230\u4eba\u8138");
        }
        try {
            return FaceUtils.drawBoundingBoxes(sourceImage, detectedObjects);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SeetaPointF[] getMaskPoint(SeetaImageData imageData) {
        FaceDetector faceDetector = null;
        FaceLandmarker faceLandmarker = null;
        try {
            faceDetector = (FaceDetector)this.faceDetectorPool.borrowObject();
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            SeetaRect[] seetaResult = faceDetector.Detect(imageData);
            if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
                throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
            }
            SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
            faceLandmarker.mark(imageData, seetaResult[0], pointFS);
            SeetaPointF[] seetaPointFArray = pointFS;
            return seetaPointFArray;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceDetector != null) {
                try {
                    this.faceDetectorPool.returnObject((Object)faceDetector);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private SeetaImageData getMaxCropFace(SeetaImageData imageData) {
        FaceRecognizer faceRecognizer = null;
        try {
            faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
            SeetaPointF[] pointFS = this.getMaskPoint(imageData);
            SeetaImageData cropImageData = new SeetaImageData(faceRecognizer.GetCropFaceWidthV2(), faceRecognizer.GetCropFaceHeightV2(), faceRecognizer.GetCropFaceChannelsV2());
            faceRecognizer.CropFaceV2(imageData, pointFS, cropImageData);
            SeetaImageData seetaImageData = cropImageData;
            return seetaImageData;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceRecognizer != null) {
                try {
                    this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public float calculSimilar(float[] feature1, float[] feature2) {
        if (Objects.isNull(feature1) || Objects.isNull(feature2)) {
            throw new FaceException("\u7279\u5f81\u5411\u91cf\u65e0\u6548");
        }
        FaceRecognizer faceRecognizer = null;
        try {
            faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
            float f = faceRecognizer.CalculateSimilarity(feature1, feature2);
            return f;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceRecognizer != null) {
                try {
                    this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public float featureComparison(String imagePath1, String imagePath2) {
        if (!FileUtils.isFileExists((String)imagePath1) || !FileUtils.isFileExists((String)imagePath2)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(new File(Paths.get(imagePath1, new String[0]).toAbsolutePath().toString()));
            image2 = ImageIO.read(new File(Paths.get(imagePath2, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.featureComparison(image1, image2);
    }

    @Override
    public float featureComparison(InputStream inputStream1, InputStream inputStream2) {
        if (Objects.isNull(inputStream1) || Objects.isNull(inputStream2)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(inputStream1);
            image2 = ImageIO.read(inputStream2);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.featureComparison(image1, image2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float featureComparison(BufferedImage image1, BufferedImage image2) {
        float f;
        FaceLandmarker faceLandmarker;
        FaceDatabase faceDatabase;
        FaceRecognizer faceRecognizer;
        block29: {
            if (!ImageUtils.isImageValid((BufferedImage)image1)) throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            if (!ImageUtils.isImageValid((BufferedImage)image2)) {
                throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            }
            SeetaImageData imageData1 = new SeetaImageData(image1.getWidth(), image1.getHeight(), 3);
            imageData1.data = ImageUtils.getMatrixBGR((BufferedImage)image1);
            SeetaImageData imageData2 = new SeetaImageData(image2.getWidth(), image2.getHeight(), 3);
            imageData2.data = ImageUtils.getMatrixBGR((BufferedImage)image2);
            faceRecognizer = null;
            faceDatabase = null;
            faceLandmarker = null;
            FaceDetector faceDetector = null;
            try {
                faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
                faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                faceDetector = (FaceDetector)this.faceDetectorPool.borrowObject();
                SeetaRect[] seetaResult = faceDetector.Detect(imageData1);
                if (Objects.isNull(seetaResult)) throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                if (seetaResult.length == 0) {
                    throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                }
                SeetaPointF[] pointFS1 = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData1, seetaResult[0], pointFS1);
                SeetaImageData cropImageData1 = new SeetaImageData(faceRecognizer.GetCropFaceWidthV2(), faceRecognizer.GetCropFaceHeightV2(), faceRecognizer.GetCropFaceChannelsV2());
                faceRecognizer.CropFaceV2(imageData1, pointFS1, cropImageData1);
                SeetaRect[] seetaResult2 = faceDetector.Detect(imageData2);
                if (Objects.isNull(seetaResult2)) throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                if (seetaResult2.length == 0) {
                    throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                }
                SeetaPointF[] pointFS2 = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData2, seetaResult2[0], pointFS2);
                SeetaImageData cropImageData2 = new SeetaImageData(faceRecognizer.GetCropFaceWidthV2(), faceRecognizer.GetCropFaceHeightV2(), faceRecognizer.GetCropFaceChannelsV2());
                faceRecognizer.CropFaceV2(imageData2, pointFS2, cropImageData2);
                f = faceDatabase.CompareByCroppedFace(cropImageData1, cropImageData2);
                if (faceDetector == null) break block29;
            }
            catch (FaceException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new FaceException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (faceDetector != null) {
                        try {
                            this.faceDetectorPool.returnObject(faceDetector);
                        }
                        catch (Exception e3) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        }
                    }
                    if (faceLandmarker != null) {
                        try {
                            this.faceLandmarkerPool.returnObject(faceLandmarker);
                        }
                        catch (Exception e4) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                        }
                    }
                    if (faceRecognizer != null) {
                        try {
                            this.faceRecognizerPool.returnObject((Object)faceRecognizer);
                        }
                        catch (Exception e5) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e5);
                        }
                    }
                    if (faceDatabase == null) throw throwable;
                    try {
                        this.faceDatabasePool.returnObject((Object)faceDatabase);
                        throw throwable;
                    }
                    catch (Exception e6) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e6);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)faceDetector);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker != null) {
            try {
                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceRecognizer != null) {
            try {
                this.faceRecognizerPool.returnObject((Object)faceRecognizer);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceDatabase == null) return f;
        try {
            this.faceDatabasePool.returnObject((Object)faceDatabase);
            return f;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return f;
    }

    @Override
    public float featureComparison(byte[] imageData1, byte[] imageData2) {
        if (Objects.isNull(imageData1) || Objects.isNull(imageData2)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(new ByteArrayInputStream(imageData1));
            image2 = ImageIO.read(new ByteArrayInputStream(imageData2));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247", e);
        }
        return this.featureComparison(image1, image2);
    }

    @Override
    public boolean register(String key, String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.register(key, bufferedImage);
    }

    @Override
    public boolean register(String key, BufferedImage image) {
        if (!this.checkFaceDb()) {
            throw new FaceException("\u672a\u627e\u5230\u4eba\u8138\u5e93\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff08\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4eba\u8138\u5e93\u8def\u5f84\uff09");
        }
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
        imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
        FaceDatabase faceDatabase = null;
        try {
            faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
            SeetaImageData cropImageData = this.getMaxCropFace(imageData);
            long index = faceDatabase.RegisterByCroppedFace(cropImageData);
            if (index < 0L) {
                log.info("register face fail: key={}, index={}", (Object)key, (Object)index);
                boolean bl = false;
                return bl;
            }
            FaceData face = new FaceData();
            face.setKey(key);
            face.setIndex(index);
            face.setImgData(cropImageData.data);
            try {
                new FaceDao(this.config.getFaceDbPath()).save(face);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new FaceException("\u4fdd\u5b58\u4eba\u8138\u5e93\u5931\u8d25", e);
            }
            boolean bl = true;
            return bl;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceDatabase != null) {
                try {
                    this.faceDatabasePool.returnObject((Object)faceDatabase);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean register(String key, byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        return this.register(key, bufferedImage);
    }

    @Override
    public boolean register(String key, InputStream inputStream) {
        if (!this.checkFaceDb()) {
            throw new FaceException("\u672a\u627e\u5230\u4eba\u8138\u5e93\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff08\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4eba\u8138\u5e93\u8def\u5f84\uff09");
        }
        if (Objects.isNull(inputStream)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u7684\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.register(key, image);
    }

    private boolean registerCroppedFace(String key, FaceData faceData) {
        FaceDatabase faceDatabase = null;
        try {
            faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
            SeetaImageData cropImageData = new SeetaImageData(faceData.getWidth(), faceData.getHeight(), faceData.getChannel());
            cropImageData.data = faceData.getImgData();
            long index = faceDatabase.RegisterByCroppedFace(cropImageData);
            if (index < 0L) {
                log.info("register face fail: key={}, index={}", (Object)key, (Object)index);
                boolean bl = false;
                return bl;
            }
            int rows = 0;
            try {
                rows = new FaceDao(this.config.getFaceDbPath()).updateIndex(index, faceData);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new FaceException(e);
            }
            boolean bl = rows > 0;
            return bl;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceDatabase != null) {
                try {
                    this.faceDatabasePool.returnObject((Object)faceDatabase);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public FaceResult search(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.search(bufferedImage);
    }

    @Override
    public FaceResult search(InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        if (!this.checkFaceDb()) {
            throw new FaceException("\u672a\u627e\u5230\u4eba\u8138\u5e93\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff08\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4eba\u8138\u5e93\u8def\u5f84\uff09");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.search(image);
    }

    @Override
    public FaceResult search(BufferedImage image) {
        long time1 = System.currentTimeMillis();
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
        imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
        FaceDatabase faceDatabase = null;
        try {
            faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
            SeetaPointF[] points = this.getMaskPoint(imageData);
            long[] index = new long[1];
            float[] similarity = new float[1];
            long result = faceDatabase.QueryTop(imageData, points, 1L, index, similarity);
            if (result < 1L) {
                FaceResult faceResult = null;
                return faceResult;
            }
            if ((double)similarity[0] < this.config.getSimilarityThreshold()) {
                FaceResult faceResult = null;
                return faceResult;
            }
            long time2 = System.currentTimeMillis();
            System.out.println("\u603b\u8017\u65f61\uff1a" + (time2 - time1) + " ms");
            FaceResult faceResult = this.searchFaceDb(index[0], similarity[0]);
            long time3 = System.currentTimeMillis();
            System.out.println("\u603b\u8017\u65f62\uff1a" + (time3 - time2) + " ms");
            FaceResult faceResult2 = faceResult;
            return faceResult2;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceDatabase != null) {
                try {
                    this.faceDatabasePool.returnObject((Object)faceDatabase);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public FaceResult search(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            throw new FaceException(e);
        }
        return this.search(bufferedImage);
    }

    /*
     * Loose catch block
     */
    @Override
    public long removeRegister(String ... keys) {
        long l;
        FaceDatabase faceDatabase;
        block17: {
            List<Long> list;
            block15: {
                long l2;
                block16: {
                    if (keys == null || keys.length == 0) {
                        throw new FaceException("keys\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                    }
                    if (!this.checkFaceDb()) {
                        throw new FaceException("\u672a\u627e\u5230\u4eba\u8138\u5e93\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff08\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4eba\u8138\u5e93\u8def\u5f84\uff09");
                    }
                    faceDatabase = null;
                    list = new FaceDao(this.config.getFaceDbPath()).findIndexList(keys);
                    if (list != null) break block15;
                    l2 = 0L;
                    if (faceDatabase == null) break block16;
                    try {
                        this.faceDatabasePool.returnObject((Object)faceDatabase);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
                return l2;
            }
            faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
            int rows = 0;
            for (long index : list) {
                int row = faceDatabase.Delete(index);
                rows += row;
            }
            new FaceDao(this.config.getFaceDbPath()).deleteFace(keys);
            l = rows;
            if (faceDatabase == null) break block17;
            try {
                this.faceDatabasePool.returnObject((Object)faceDatabase);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        return l;
        catch (Exception e) {
            try {
                throw new FaceException(e);
            }
            catch (Throwable throwable) {
                if (faceDatabase != null) {
                    try {
                        this.faceDatabasePool.returnObject(faceDatabase);
                    }
                    catch (Exception e2) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public long clearFace() {
        if (!this.checkFaceDb()) {
            throw new FaceException("\u672a\u627e\u5230\u4eba\u8138\u5e93\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u529f\u80fd\uff08\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4eba\u8138\u5e93\u8def\u5f84\uff09");
        }
        FaceDatabase faceDatabase = null;
        try {
            faceDatabase = (FaceDatabase)this.faceDatabasePool.borrowObject();
            faceDatabase.Clear();
            long rows = 0L;
            try {
                rows = new FaceDao(this.config.getFaceDbPath()).deleteAll();
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new FaceException("\u5220\u9664\u4eba\u8138\u5e93\u5931\u8d25", e);
            }
            long l = rows;
            return l;
        }
        catch (FaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceDatabase != null) {
                try {
                    this.faceDatabasePool.returnObject((Object)faceDatabase);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private boolean checkFaceDb() {
        if (Objects.nonNull(this.config) && StringUtils.isNotBlank((CharSequence)this.config.getFaceDbPath())) {
            File file = new File(this.config.getFaceDbPath());
            return file.exists() && file.isFile();
        }
        return false;
    }

    private FaceResult searchFaceDb(long index, float similar) {
        if (index >= 0L) {
            String key = null;
            try {
                key = new FaceDao(this.config.getFaceDbPath()).findKeyByIndex(index);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new FaceException("\u67e5\u8be2\u4eba\u8138\u5e93\u5931\u8d25", e);
            }
            return new FaceResult(key, similar);
        }
        return null;
    }

    private void loadFaceDb() {
        if (!this.checkFaceDb()) {
            log.info("\u672a\u914d\u7f6e\u4eba\u8138\u5e93");
            return;
        }
        int pageNo = 0;
        int pageSize = 100;
        while (true) {
            List<FaceData> list = null;
            try {
                list = new FaceDao(this.config.getFaceDbPath()).findFace(pageNo, pageSize);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new FaceException("\u67e5\u8be2\u4eba\u8138\u5e93\u5931\u8d25", e);
            }
            if (list == null) break;
            list.forEach(face -> {
                try {
                    this.registerCroppedFace(face.getKey(), (FaceData)face);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            if (list.size() < pageSize) break;
            ++pageNo;
        }
    }

    @Override
    public List<float[]> extractFeatures(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractFeatures(image);
    }

    @Override
    public List<float[]> extractFeatures(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.extractFeatures(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<float[]> extractFeatures(BufferedImage image) {
        FaceRecognizer faceRecognizer;
        FaceLandmarker faceLandmarker;
        ArrayList<float[]> featureList;
        block24: {
            if (!ImageUtils.isImageValid((BufferedImage)image)) {
                throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            }
            featureList = new ArrayList<float[]>();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            FaceDetector faceDetector = null;
            faceLandmarker = null;
            faceRecognizer = null;
            try {
                faceDetector = (FaceDetector)this.faceDetectorPool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
                SeetaRect[] seetaResult = faceDetector.Detect(imageData);
                if (Objects.isNull(seetaResult)) throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                if (seetaResult.length == 0) {
                    throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                }
                for (SeetaRect seetaRect : seetaResult) {
                    SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, pointFS);
                    float[] features = new float[faceRecognizer.GetExtractFeatureSize()];
                    boolean isSuccess = faceRecognizer.Extract(imageData, pointFS, features);
                    if (!isSuccess) {
                        throw new FaceException("\u4eba\u8138\u7279\u5f81\u63d0\u53d6\u5931\u8d25");
                    }
                    featureList.add(features);
                }
                if (faceDetector == null) break block24;
            }
            catch (FaceException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (faceDetector != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)faceDetector);
                        }
                        catch (Exception e3) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        }
                    }
                    if (faceLandmarker != null) {
                        try {
                            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                        }
                        catch (Exception e4) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                        }
                    }
                    if (faceRecognizer == null) throw throwable;
                    try {
                        this.faceRecognizerPool.returnObject(faceRecognizer);
                        throw throwable;
                    }
                    catch (Exception e5) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e5);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)faceDetector);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker != null) {
            try {
                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceRecognizer == null) return featureList;
        try {
            this.faceRecognizerPool.returnObject((Object)faceRecognizer);
            return featureList;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            return featureList;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float[] extractTopFaceFeature(BufferedImage image) {
        FaceRecognizer faceRecognizer;
        FaceLandmarker faceLandmarker;
        float[] features;
        block23: {
            if (!ImageUtils.isImageValid((BufferedImage)image)) {
                throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            }
            features = null;
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            FaceDetector faceDetector = null;
            faceLandmarker = null;
            faceRecognizer = null;
            try {
                faceDetector = (FaceDetector)this.faceDetectorPool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                faceRecognizer = (FaceRecognizer)this.faceRecognizerPool.borrowObject();
                SeetaRect[] seetaResult = faceDetector.Detect(imageData);
                if (Objects.isNull(seetaResult)) throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                if (seetaResult.length == 0) {
                    throw new FaceException("\u672a\u68c0\u6d4b\u5230\u4eba\u8138");
                }
                SeetaPointF[] pointFS = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData, seetaResult[0], pointFS);
                features = new float[faceRecognizer.GetExtractFeatureSize()];
                boolean isSuccess = faceRecognizer.Extract(imageData, pointFS, features);
                if (!isSuccess) {
                    throw new FaceException("\u4eba\u8138\u7279\u5f81\u63d0\u53d6\u5931\u8d25");
                }
                if (faceDetector == null) break block23;
            }
            catch (FaceException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new FaceException("\u76ee\u6807\u68c0\u6d4b\u9519\u8bef", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (faceDetector != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)faceDetector);
                        }
                        catch (Exception e3) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        }
                    }
                    if (faceLandmarker != null) {
                        try {
                            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                        }
                        catch (Exception e4) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                        }
                    }
                    if (faceRecognizer == null) throw throwable;
                    try {
                        this.faceRecognizerPool.returnObject(faceRecognizer);
                        throw throwable;
                    }
                    catch (Exception e5) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e5);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)faceDetector);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker != null) {
            try {
                this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceRecognizer == null) return features;
        try {
            this.faceRecognizerPool.returnObject((Object)faceRecognizer);
            return features;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            return features;
        }
    }

    @Override
    public float[] extractTopFaceFeature(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractTopFaceFeature(image);
    }

    @Override
    public float[] extractTopFaceFeature(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.extractTopFaceFeature(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }
}

