/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.liveness;

import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.FaceInfo;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.enums.DeviceEnum;
import cn.smartjavaai.common.enums.LivenessStatus;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.liveness.LivenessDetModel;
import cn.smartjavaai.face.seetaface.NativeLoader;
import cn.smartjavaai.face.utils.FaceUtils;
import com.seeta.pool.FaceAntiSpoofingPool;
import com.seeta.pool.FaceDetectorPool;
import com.seeta.pool.FaceLandmarkerPool;
import com.seeta.pool.SeetaConfSetting;
import com.seeta.sdk.FaceAntiSpoofing;
import com.seeta.sdk.FaceDetector;
import com.seeta.sdk.FaceLandmarker;
import com.seeta.sdk.SeetaDevice;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaModelSetting;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Seetaface6LivenessModel
implements LivenessDetModel {
    private static final Logger log = LoggerFactory.getLogger(Seetaface6LivenessModel.class);
    private FaceDetectorPool faceDetectorPool;
    private FaceAntiSpoofingPool faceAntiSpoofingPool;
    private FaceLandmarkerPool faceLandmarkerPool;

    @Override
    public void loadModel(LivenessConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new FaceException("modelPath is null");
        }
        NativeLoader.loadNativeLibraries(config.getDevice());
        log.info("Loading seetaFace6 library successfully.");
        String[] faceDetectorModelPath = new String[]{config.getModelPath() + File.separator + "face_detector.csta"};
        String[] faceAntiSpoofingModelPath = new String[]{config.getModelPath() + File.separator + "fas_first.csta", config.getModelPath() + File.separator + "fas_second.csta"};
        String[] faceLandmarkerModelPath = new String[]{config.getModelPath() + File.separator + "face_landmarker_pts5.csta"};
        SeetaDevice device = SeetaDevice.SEETA_DEVICE_AUTO;
        int gpuId = 0;
        if (Objects.nonNull(config.getDevice())) {
            SeetaDevice seetaDevice = device = config.getDevice() == DeviceEnum.CPU ? SeetaDevice.SEETA_DEVICE_CPU : SeetaDevice.SEETA_DEVICE_GPU;
            if (config.getGpuId() >= 0 && device == SeetaDevice.SEETA_DEVICE_GPU) {
                gpuId = config.getGpuId();
            }
        }
        try {
            SeetaModelSetting faceDetectorPoolSetting = new SeetaModelSetting(gpuId, faceDetectorModelPath, device);
            SeetaConfSetting faceDetectorPoolConfSetting = new SeetaConfSetting(faceDetectorPoolSetting);
            SeetaModelSetting faceLandmarkerPoolSetting = new SeetaModelSetting(gpuId, faceLandmarkerModelPath, device);
            SeetaConfSetting faceLandmarkerPoolConfSetting = new SeetaConfSetting(faceLandmarkerPoolSetting);
            SeetaModelSetting faceAntiSpoofingSetting = new SeetaModelSetting(gpuId, faceAntiSpoofingModelPath, device);
            SeetaConfSetting faceAntiSpoofingPoolConfSetting = new SeetaConfSetting(faceAntiSpoofingSetting);
            this.faceDetectorPool = new FaceDetectorPool(faceDetectorPoolConfSetting);
            this.faceAntiSpoofingPool = new FaceAntiSpoofingPool(faceAntiSpoofingPoolConfSetting);
            this.faceLandmarkerPool = new FaceLandmarkerPool(faceLandmarkerPoolConfSetting);
            FaceAntiSpoofing faceAntiSpoofing = null;
            try {
                faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
                if (config.getFaceClarityThreshold() > 0.0f && config.getRealityThreshold() > 0.0f) {
                    faceAntiSpoofing.SetThreshold(config.getFaceClarityThreshold(), config.getRealityThreshold());
                }
                if (config.getFrameCount() > 0) {
                    faceAntiSpoofing.SetVideoFrameCount(config.getFrameCount());
                }
            }
            catch (Exception e) {
                throw new FaceException(e);
            }
            finally {
                if (faceAntiSpoofing != null) {
                    try {
                        this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                    }
                    catch (Exception e) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FaceException(e);
        }
    }

    @Override
    public DetectionResponse detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image);
    }

    @Override
    public DetectionResponse detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DetectionResponse detect(BufferedImage image) {
        DetectionResponse detectionResponse;
        FaceLandmarker faceLandmarker;
        FaceAntiSpoofing faceAntiSpoofing;
        block22: {
            if (!ImageUtils.isImageValid((BufferedImage)image)) {
                throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            }
            FaceAntiSpoofing.Status status = null;
            faceAntiSpoofing = null;
            faceLandmarker = null;
            FaceDetector detectPredictor = null;
            ArrayList<SeetaPointF[]> seetaPointFSList = new ArrayList<SeetaPointF[]>();
            ArrayList<LivenessStatus> livenessStatusList = new ArrayList<LivenessStatus>();
            try {
                detectPredictor = (FaceDetector)this.faceDetectorPool.borrowObject();
                faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
                DetectionResponse seetaResult = detectPredictor.Detect(imageData);
                if (Objects.isNull(seetaResult)) {
                    throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
                }
                for (SeetaRect seetaRect : seetaResult) {
                    SeetaPointF[] landmarks = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, landmarks);
                    seetaPointFSList.add(landmarks);
                    status = faceAntiSpoofing.Predict(imageData, seetaRect, landmarks);
                    livenessStatusList.add(FaceUtils.convertToLivenessStatus(status));
                }
                detectionResponse = FaceUtils.convertToDetectionResponse((SeetaRect[])seetaResult, seetaPointFSList, livenessStatusList);
                if (detectPredictor == null) break block22;
            }
            catch (Exception e) {
                try {
                    throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    if (detectPredictor != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)detectPredictor);
                        }
                        catch (Exception e2) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                        }
                    }
                    if (faceAntiSpoofing != null) {
                        try {
                            this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                        }
                        catch (Exception e3) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        }
                    }
                    if (faceLandmarker == null) throw throwable;
                    try {
                        this.faceLandmarkerPool.returnObject(faceLandmarker);
                        throw throwable;
                    }
                    catch (Exception e4) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)detectPredictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceAntiSpoofing != null) {
            try {
                this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker == null) return detectionResponse;
        try {
            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            return detectionResponse;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return detectionResponse;
    }

    @Override
    public List<LivenessStatus> detect(String imagePath, DetectionResponse faceDetectionResponse) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionResponse);
    }

    @Override
    public LivenessStatus detect(String imagePath, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detect(image, faceDetectionRectangle, keyPoints);
    }

    private List<LivenessStatus> detect(BufferedImage image, DetectionResponse faceDetectionResponse, boolean isImage) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(faceDetectionResponse) || Objects.isNull(faceDetectionResponse.getDetectionInfoList()) || faceDetectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
        }
        FaceAntiSpoofing.Status status = null;
        FaceAntiSpoofing faceAntiSpoofing = null;
        FaceLandmarker faceLandmarker = null;
        ArrayList<LivenessStatus> livenessStatusList = new ArrayList<LivenessStatus>();
        try {
            for (DetectionInfo detectionInfo : faceDetectionResponse.getDetectionInfoList()) {
                faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
                SeetaRect seetaRect = FaceUtils.convertToSeetaRect(detectionInfo.getDetectionRectangle());
                SeetaPointF[] landmarks = null;
                FaceInfo faceInfo = detectionInfo.getFaceInfo();
                if (faceInfo == null || faceInfo.getKeyPoints() == null || faceInfo.getKeyPoints().isEmpty()) {
                    landmarks = new SeetaPointF[faceLandmarker.number()];
                    faceLandmarker.mark(imageData, seetaRect, landmarks);
                } else {
                    landmarks = FaceUtils.convertToSeetaPointF(faceInfo.getKeyPoints());
                }
                status = isImage ? faceAntiSpoofing.Predict(imageData, seetaRect, landmarks) : faceAntiSpoofing.PredictVideo(imageData, seetaRect, landmarks);
                livenessStatusList.add(FaceUtils.convertToLivenessStatus(status));
            }
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceAntiSpoofing != null) {
                try {
                    this.faceAntiSpoofingPool.returnObject(faceAntiSpoofing);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject(faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return livenessStatusList;
    }

    @Override
    public List<LivenessStatus> detect(BufferedImage image, DetectionResponse faceDetectionResponse) {
        return this.detect(image, faceDetectionResponse, true);
    }

    private LivenessStatus detect(BufferedImage image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints, boolean isImage) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(faceDetectionRectangle)) {
            throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
        }
        FaceAntiSpoofing.Status status = null;
        FaceAntiSpoofing faceAntiSpoofing = null;
        FaceLandmarker faceLandmarker = null;
        try {
            faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
            faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
            SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
            imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
            SeetaRect seetaRect = FaceUtils.convertToSeetaRect(faceDetectionRectangle);
            SeetaPointF[] landmarks = null;
            if (keyPoints == null || keyPoints.isEmpty()) {
                throw new FaceException("\u4eba\u8138\u5173\u952e\u70b9keyPoints\u4e3a\u7a7a");
            }
            landmarks = FaceUtils.convertToSeetaPointF(keyPoints);
            status = isImage ? faceAntiSpoofing.Predict(imageData, seetaRect, landmarks) : faceAntiSpoofing.PredictVideo(imageData, seetaRect, landmarks);
            LivenessStatus livenessStatus = FaceUtils.convertToLivenessStatus(status);
            return livenessStatus;
        }
        catch (Exception e) {
            throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (faceAntiSpoofing != null) {
                try {
                    this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
            if (faceLandmarker != null) {
                try {
                    this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public LivenessStatus detect(BufferedImage image, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        return this.detect(image, faceDetectionRectangle, keyPoints, true);
    }

    @Override
    public List<LivenessStatus> detect(byte[] imageData, DetectionResponse faceDetectionResponse) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionResponse);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public LivenessStatus detect(byte[] imageData, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(imageData)), faceDetectionRectangle, keyPoints);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public LivenessStatus detectTopFace(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.detectTopFace(image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LivenessStatus detectTopFace(BufferedImage image, boolean isImage) {
        LivenessStatus livenessStatus;
        FaceLandmarker faceLandmarker;
        FaceAntiSpoofing faceAntiSpoofing;
        block21: {
            if (!ImageUtils.isImageValid((BufferedImage)image)) {
                throw new FaceException("\u56fe\u50cf\u65e0\u6548");
            }
            FaceAntiSpoofing.Status status = null;
            faceAntiSpoofing = null;
            faceLandmarker = null;
            FaceDetector detectPredictor = null;
            try {
                detectPredictor = (FaceDetector)this.faceDetectorPool.borrowObject();
                faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
                faceLandmarker = (FaceLandmarker)this.faceLandmarkerPool.borrowObject();
                SeetaImageData imageData = new SeetaImageData(image.getWidth(), image.getHeight(), 3);
                imageData.data = ImageUtils.getMatrixBGR((BufferedImage)image);
                SeetaRect[] seetaResult = detectPredictor.Detect(imageData);
                if (Objects.isNull(seetaResult)) {
                    throw new FaceException("\u65e0\u4eba\u8138\u6570\u636e");
                }
                SeetaPointF[] landmarks = new SeetaPointF[faceLandmarker.number()];
                faceLandmarker.mark(imageData, seetaResult[0], landmarks);
                status = isImage ? faceAntiSpoofing.Predict(imageData, seetaResult[0], landmarks) : faceAntiSpoofing.PredictVideo(imageData, seetaResult[0], landmarks);
                livenessStatus = FaceUtils.convertToLivenessStatus(status);
                if (detectPredictor == null) break block21;
            }
            catch (Exception e) {
                try {
                    throw new FaceException("\u6d3b\u4f53\u68c0\u6d4b\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    if (detectPredictor != null) {
                        try {
                            this.faceDetectorPool.returnObject((Object)detectPredictor);
                        }
                        catch (Exception e2) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e2);
                        }
                    }
                    if (faceAntiSpoofing != null) {
                        try {
                            this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                        }
                        catch (Exception e3) {
                            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e3);
                        }
                    }
                    if (faceLandmarker == null) throw throwable;
                    try {
                        this.faceLandmarkerPool.returnObject(faceLandmarker);
                        throw throwable;
                    }
                    catch (Exception e4) {
                        log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e4);
                    }
                    throw throwable;
                }
            }
            try {
                this.faceDetectorPool.returnObject((Object)detectPredictor);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceAntiSpoofing != null) {
            try {
                this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
            }
            catch (Exception e) {
                log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
            }
        }
        if (faceLandmarker == null) return livenessStatus;
        try {
            this.faceLandmarkerPool.returnObject((Object)faceLandmarker);
            return livenessStatus;
        }
        catch (Exception e) {
            log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
        }
        return livenessStatus;
    }

    @Override
    public LivenessStatus detectTopFace(BufferedImage image) {
        return this.detectTopFace(image, true);
    }

    @Override
    public LivenessStatus detectTopFace(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detectTopFace(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public LivenessStatus detectVideoByFrame(BufferedImage frameImage, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (!ImageUtils.isImageValid((BufferedImage)frameImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        return this.detect(frameImage, faceDetectionRectangle, keyPoints, false);
    }

    @Override
    public LivenessStatus detectVideoByFrame(byte[] frameData, DetectionRectangle faceDetectionRectangle, List<Point> keyPoints) {
        if (Objects.isNull(frameData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detect(ImageIO.read(new ByteArrayInputStream(frameData)), faceDetectionRectangle, keyPoints, false);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public LivenessStatus detectVideoByFrame(byte[] frameImageData) {
        if (Objects.isNull(frameImageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            return this.detectVideoByFrame(ImageIO.read(new ByteArrayInputStream(frameImageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public LivenessStatus detectVideoByFrame(BufferedImage frameImageData) {
        return this.detectTopFace(frameImageData, false);
    }

    @Override
    public LivenessStatus detectVideo(InputStream videoInputStream) {
        if (Objects.isNull(videoInputStream)) {
            throw new FaceException("\u89c6\u9891\u65e0\u6548");
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoInputStream));
    }

    @Override
    public LivenessStatus detectVideo(String videoPath) {
        if (!FileUtils.isFileExists((String)videoPath)) {
            throw new FaceException("\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return this.detectVideo(new FFmpegFrameGrabber(videoPath));
    }

    private LivenessStatus detectVideo(FFmpegFrameGrabber grabber) {
        FaceAntiSpoofing faceAntiSpoofing = null;
        try {
            faceAntiSpoofing = (FaceAntiSpoofing)this.faceAntiSpoofingPool.borrowObject();
            grabber.start();
            int totalFrames = grabber.getLengthInFrames();
            int videoFrameCountConfig = faceAntiSpoofing.GetVideoFrameCount();
            log.info("\u89c6\u9891\u603b\u5e27\u6570\uff1a{}\uff0c\u68c0\u6d4b\u5e27\u6570\uff1a{}", (Object)totalFrames, (Object)videoFrameCountConfig);
            if (totalFrames < videoFrameCountConfig) {
                throw new FaceException("\u89c6\u9891\u5e27\u6570\u4f4e\u4e8e\u68c0\u6d4b\u5e27\u6570");
            }
            for (int frameIndex = 0; frameIndex < totalFrames; ++frameIndex) {
                BufferedImage bufferedImage;
                LivenessStatus livenessStatus;
                Frame frame = grabber.grabImage();
                if (frame == null || (livenessStatus = this.detectVideoByFrame(bufferedImage = Java2DFrameUtils.toBufferedImage((Frame)frame))) == LivenessStatus.DETECTING) continue;
                LivenessStatus livenessStatus2 = livenessStatus;
                return livenessStatus2;
            }
            grabber.stop();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new FaceException(e);
        }
        catch (Exception e) {
            throw new FaceException(e);
        }
        finally {
            if (faceAntiSpoofing != null) {
                try {
                    this.faceAntiSpoofingPool.returnObject((Object)faceAntiSpoofing);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return LivenessStatus.UNKNOWN;
    }
}

