/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.sqllite;

import cn.smartjavaai.face.sqllite.ResultSetExtractor;
import cn.smartjavaai.face.sqllite.RowMapper;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteHelper {
    private static final Logger log = LoggerFactory.getLogger(SqliteHelper.class);
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private String dbFilePath;

    public SqliteHelper(String dbFilePath) throws ClassNotFoundException, SQLException {
        this.dbFilePath = dbFilePath;
        this.connection = this.getConnection(dbFilePath);
    }

    public Connection getConnection(String dbFilePath) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        Class.forName("org.sqlite.JDBC");
        conn = DriverManager.getConnection("jdbc:sqlite:" + dbFilePath);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(String sql, ResultSetExtractor<T> rse) throws SQLException, ClassNotFoundException {
        try {
            T rs;
            this.resultSet = this.getStatement().executeQuery(sql);
            T t = rs = rse.extractData(this.resultSet);
            return t;
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeQuery(String sql, RowMapper<T> rm) throws SQLException, ClassNotFoundException {
        ArrayList<T> rsList = new ArrayList<T>();
        try {
            this.resultSet = this.getStatement().executeQuery(sql);
            while (this.resultSet.next()) {
                rsList.add(rm.mapRow(this.resultSet, this.resultSet.getRow()));
            }
        }
        finally {
            this.destroyed();
        }
        return rsList;
    }

    public String executeQuery(String sql) throws SQLException, ClassNotFoundException {
        try {
            this.resultSet = this.getStatement().executeQuery(sql);
            if (this.resultSet.next()) {
                String string = this.resultSet.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException, ClassNotFoundException {
        try {
            int c;
            int n = c = this.getStatement().executeUpdate(sql);
            return n;
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String ... sqls) throws SQLException, ClassNotFoundException {
        try {
            for (String sql : sqls) {
                this.getStatement().executeUpdate(sql);
            }
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(List<String> sqls) throws SQLException, ClassNotFoundException {
        try {
            for (String sql : sqls) {
                this.getStatement().executeUpdate(sql);
            }
        }
        finally {
            this.destroyed();
        }
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        if (null == this.connection) {
            this.connection = this.getConnection(this.dbFilePath);
        }
        return this.connection;
    }

    private Statement getStatement() throws SQLException, ClassNotFoundException {
        if (null == this.statement) {
            this.statement = this.getConnection().createStatement();
        }
        return this.statement;
    }

    public void destroyed() {
        try {
            if (null != this.statement) {
                this.statement.close();
                this.statement = null;
            }
            if (null != this.connection) {
                this.connection.close();
                this.connection = null;
            }
            if (null != this.resultSet) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error("Sqlite\u6570\u636e\u5e93\u5173\u95ed\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeQueryList(String sql, Class<T> clazz) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<T> rsList = new ArrayList<T>();
        try {
            this.resultSet = this.getStatement().executeQuery(sql);
            while (this.resultSet.next()) {
                T t = clazz.newInstance();
                for (Field field : t.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    field.set(t, this.resultSet.getObject(field.getName()));
                }
                rsList.add(t);
            }
        }
        finally {
            this.destroyed();
        }
        return rsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(String sql, Class<T> clazz) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            this.resultSet = this.getStatement().executeQuery(sql);
            T t = clazz.newInstance();
            for (Field field : t.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                field.set(t, this.resultSet.getObject(field.getName()));
            }
            T t2 = t;
            return t2;
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeInsertOrUpdate(String tableName, Map<String, Object> param) throws SQLException, ClassNotFoundException {
        try {
            int c;
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT OR REPLACE INTO ");
            sql.append(tableName);
            sql.append(" ( ");
            for (String key : param.keySet()) {
                sql.append("'" + key + "'");
                sql.append(",");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")  VALUES ( ");
            for (String key : param.keySet()) {
                sql.append("'");
                sql.append(param.get(key));
                sql.append("',");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(");");
            log.info("sql\uff1a{}", (Object)sql.toString());
            int n = c = this.getStatement().executeUpdate(sql.toString());
            return n;
        }
        finally {
            this.destroyed();
        }
    }

    /*
     * Loose catch block
     */
    public int executeUpdate(String sql, Object[] args) throws SQLException, ClassNotFoundException {
        Connection conn = this.getConnection();
        if (args == null || args.length == 0) {
            try {
                try (Statement stmt = conn.createStatement();){
                    int n = stmt.executeUpdate(sql);
                    return n;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.destroyed();
            }
        }
        try {
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                for (int i = 0; i < args.length; ++i) {
                    stmt.setObject(i + 1, args[i]);
                }
                int n = stmt.executeUpdate();
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.destroyed();
        }
    }
}

