/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.utils;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import cn.smartjavaai.face.utils.SVDUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class OpenCVUtils {
    public static Mat canny(Mat src) {
        Mat mat = src.clone();
        Imgproc.Canny((Mat)src, (Mat)mat, (double)100.0, (double)200.0);
        return mat;
    }

    public static void line(Mat mat, Point point1, Point point2) {
        Imgproc.line((Mat)mat, (Point)point1, (Point)point2, (Scalar)new Scalar(255.0, 255.0, 255.0), (int)1);
    }

    public static Mat toOpenCVMat(NDManager manager, NDArray srcPoints, NDArray dstPoints) {
        NDArray svdMat = SVDUtils.transformationFromPoints(manager, srcPoints, dstPoints);
        double[] doubleArray = svdMat.toDoubleArray();
        Mat newSvdMat = new Mat(2, 3, 6);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                newSvdMat.put(i, j, new double[]{doubleArray[i * 3 + j]});
            }
        }
        return newSvdMat;
    }

    public static Mat toOpenCVMat(double[][] points) {
        Mat mat = new Mat(5, 2, 6);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                mat.put(i, j, points[i * 5 + j]);
            }
        }
        return mat;
    }

    public static Mat invertAffineTransform(Mat src) {
        Mat dst = src.clone();
        Imgproc.invertAffineTransform((Mat)src, (Mat)dst);
        return dst;
    }

    public static BufferedImage mat2Image(Mat mat) {
        int width = mat.width();
        int height = mat.height();
        byte[] data = new byte[width * height * (int)mat.elemSize()];
        Imgproc.cvtColor((Mat)mat, (Mat)mat, (int)4);
        mat.get(0, 0, data);
        BufferedImage ret = new BufferedImage(width, height, 5);
        ret.getRaster().setDataElements(0, 0, width, height, data);
        return ret;
    }

    public static Mat image2Mat(BufferedImage img) {
        int channels;
        int width = img.getWidth();
        int height = img.getHeight();
        int imageType = img.getType();
        if (imageType == 5) {
            channels = 3;
        } else if (imageType == 6 || imageType == 7) {
            channels = 4;
        } else {
            BufferedImage convertedImg = new BufferedImage(width, height, 5);
            convertedImg.getGraphics().drawImage(img, 0, 0, null);
            img = convertedImg;
            channels = 3;
        }
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        Mat mat = new Mat(height, width, CvType.CV_8UC((int)channels));
        mat.put(0, 0, data);
        return mat;
    }
}

