/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.enums.DataType;

public class BooleanDataSpecs
implements IDataSpecs {
    private String trueKey;
    private String falseKey;

    public BooleanDataSpecs() {
        this.trueKey = Boolean.TRUE.toString();
        this.falseKey = Boolean.FALSE.toString();
    }

    public BooleanDataSpecs(String trueKey, String falseKey) {
        this.trueKey = trueKey;
        this.falseKey = falseKey;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOL;
    }

    @Override
    public Object parse(Object value) {
        return this.getTrueKey().equals(value.toString());
    }

    @Override
    public boolean validationData(Object value) {
        String resultStr = this.toResultString(value);
        return this.trueKey.equals(resultStr) || this.falseKey.equals(resultStr);
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }

    public void setTrueKey(String trueKey) {
        this.trueKey = trueKey;
    }

    public void setFalseKey(String falseKey) {
        this.falseKey = falseKey;
    }

    public String getTrueKey() {
        return this.trueKey;
    }

    public String getFalseKey() {
        return this.falseKey;
    }
}

