/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.enums.DataType;

public class DoubleDataSpecs
implements IDataSpecs {
    private static final int MAX_LENGTH = 20;
    private static final int MAX_DECIMALS_LENGTH = 19;
    private int length = 9;
    private int decimals;

    public DoubleDataSpecs() {
        this.length = 20;
        this.decimals = 19;
    }

    public DoubleDataSpecs(int length, int decimals) {
        this.setLength(length);
        this.setDecimals(decimals);
    }

    public void setLength(int length) {
        this.length = Math.min(length, 20);
    }

    public void setDecimals(int decimals) {
        this.decimals = Math.min(decimals, 19);
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Object parse(Object value) {
        return Double.parseDouble(value.toString());
    }

    @Override
    public boolean validationData(Object value) {
        String doubleStr = this.toResultString(value);
        try {
            Double.parseDouble(doubleStr);
        }
        catch (Exception e) {
            return false;
        }
        int index = doubleStr.indexOf(".");
        String integer = doubleStr.substring(0, index);
        String decimalsStr = doubleStr.substring(index);
        if (integer.length() > this.length - this.decimals) {
            return false;
        }
        return decimalsStr.length() <= this.decimals;
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }
}

