/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.enums.DataType;

public class FloatDataSpecs
implements IDataSpecs {
    private static final int MAX_LENGTH = 11;
    private static final int MAX_DECIMALS_LENGTH = 9;
    private int length;
    private int decimals;

    public FloatDataSpecs() {
        this.length = 11;
        this.decimals = 9;
    }

    public FloatDataSpecs(int length, int decimals) {
        this.setLength(length);
        this.setDecimals(decimals);
    }

    public void setLength(int length) {
        this.length = Math.min(length, 11);
    }

    public void setDecimals(int decimals) {
        this.decimals = Math.min(decimals, 9);
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    @Override
    public Object parse(Object value) {
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    @Override
    public boolean validationData(Object value) {
        String floatStr = this.toResultString(value);
        try {
            Float.parseFloat(floatStr);
        }
        catch (Exception e) {
            return false;
        }
        int index = floatStr.indexOf(".");
        String integer = floatStr.substring(0, index);
        String decimalsStr = floatStr.substring(index);
        if (integer.length() > this.length - this.decimals) {
            return false;
        }
        return decimalsStr.length() <= this.decimals;
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }
}

