/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.enums.DataType;

public class LongDataSpecs
implements IDataSpecs {
    private static final int MAX_LENGTH = 20;
    private int length;

    public LongDataSpecs() {
        this.length = 20;
    }

    public LongDataSpecs(Integer length) {
        this.setLength(length);
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = Math.min(length, 20);
    }

    @Override
    public DataType getDataType() {
        return DataType.INT;
    }

    @Override
    public Object parse(Object value) {
        return Long.parseLong(value.toString());
    }

    @Override
    public boolean validationData(Object value) {
        String valueStr = this.toResultString(value);
        try {
            Long.parseLong(valueStr);
        }
        catch (Exception e) {
            return false;
        }
        return valueStr.length() <= this.length;
    }

    @Override
    public String toResultString(Object value) {
        return value.toString();
    }
}

