/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.dataspecs;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.entity.StructEntity;
import cn.structured.function.api.enums.DataType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructDataSpecs
implements IDataSpecs {
    private final Map<String, IDataSpecs> dataSpecsMap;

    public StructDataSpecs(Map<String, IDataSpecs> dataSpecsMap) {
        this.dataSpecsMap = dataSpecsMap;
    }

    public IDataSpecs getDataSpecs(String key) {
        return this.dataSpecsMap.get(key);
    }

    @Override
    public DataType getDataType() {
        return DataType.STRUCT;
    }

    @Override
    public Object parse(Object value) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)value));
        StructEntity structEntity = new StructEntity();
        List<StructEntity.Entity> list = jsonObject.entrySet().stream().map(entry -> {
            StructEntity.Entity entity = new StructEntity.Entity();
            entity.setDataSpecs(this.getDataSpecs(entity.getKey()));
            entity.setKey(entity.getKey());
            entity.setValue(entry.getValue());
            return entity;
        }).collect(Collectors.toList());
        structEntity.setDataSpecs(this);
        structEntity.setItems(list);
        return structEntity;
    }

    @Override
    public boolean validationData(Object value) {
        String jsonStr = this.toResultString(value);
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        for (Map.Entry<String, IDataSpecs> entry : this.dataSpecsMap.entrySet()) {
            Object o = jsonObject.get((Object)entry.getKey());
            IDataSpecs dataSpecs = entry.getValue();
            boolean result = dataSpecs.validationData(o);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toResultString(Object value) {
        return JSON.toJSONString((Object)value);
    }

    public Map<String, IDataSpecs> getDataSpecsMap() {
        return this.dataSpecsMap;
    }
}

