/*
 * Decompiled with CFR 0.152.
 */
package cn.structured.function.api.entity;

import cn.structured.function.api.dataspecs.IDataSpecs;
import cn.structured.function.api.dataspecs.StructDataSpecs;
import cn.structured.function.api.entity.EnumEntity;
import cn.structured.function.api.entity.ParamContainer;
import cn.structured.function.api.entity.StructEntity;
import cn.structured.function.api.enums.DataType;
import cn.structured.function.api.exception.ValidationDataException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public abstract class AbsParamContainer
implements ParamContainer {
    protected final Object value;
    protected final IDataSpecs dataSpecs;
    protected final DataType dataType;
    protected final ExpressionParser parser = new SpelExpressionParser();
    protected final EvaluationContext ctx = new StandardEvaluationContext();

    public AbsParamContainer(Object value, IDataSpecs dataSpecs) {
        this.dataSpecs = dataSpecs;
        this.dataType = dataSpecs.getDataType();
        this.value = value;
        if (!dataSpecs.validationData(value)) {
            throw new ValidationDataException("\u6570\u636e\u6821\u9a8c\u5f02\u5e38\uff01\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff01" + value + "\u5f53\u524d\u6570\u636e\u5b9a\u4e49\u7c7b\u578b\u4e3a" + (Object)((Object)dataSpecs.getDataType()));
        }
        if (DataType.STRUCT.equals((Object)this.dataType)) {
            JSONObject jsonObject = JSON.parseObject((String)(value instanceof String ? value.toString() : JSON.toJSONString((Object)value)));
            jsonObject.forEach((arg_0, arg_1) -> ((EvaluationContext)this.ctx).setVariable(arg_0, arg_1));
        }
    }

    @Override
    public Integer getInteger(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (Integer)subDataSpecs.parse(value);
    }

    @Override
    public Long getLong(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (Long)subDataSpecs.parse(value);
    }

    @Override
    public Double getDouble(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (Double)subDataSpecs.parse(value);
    }

    @Override
    public Float getFloat(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (Float)subDataSpecs.parse(value);
    }

    @Override
    public String getString(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return subDataSpecs.parse(value).toString();
    }

    @Override
    public Boolean getBoolean(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (boolean)((Boolean)subDataSpecs.parse(value));
    }

    @Override
    public List<Object> getArray(String key) {
        Expression expression = this.parser.parseExpression(key);
        Object value = expression.getValue(this.ctx);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        return (List)subDataSpecs.parse(value);
    }

    @Override
    public StructEntity getEntity(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        Object value = expression.getValue(this.ctx);
        return (StructEntity)subDataSpecs.parse(value);
    }

    @Override
    public EnumEntity getEnum(String key) {
        Expression expression = this.parser.parseExpression(key);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        return (EnumEntity)subDataSpecs.parse(expression.getValue(this.ctx, String.class));
    }

    @Override
    public Object getObject(String key) {
        Expression expression = this.parser.parseExpression(key);
        return expression.getValue(this.ctx);
    }

    @Override
    public Integer getInteger() {
        return (Integer)this.dataSpecs.parse(this.value);
    }

    @Override
    public Long getLong() {
        return (Long)this.dataSpecs.parse(this.value);
    }

    @Override
    public Double getDouble() {
        return (Double)this.dataSpecs.parse(this.value);
    }

    @Override
    public Float getFloat() {
        return (Float)this.dataSpecs.parse(this.value);
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public Boolean getBoolean() {
        return (boolean)((Boolean)this.dataSpecs.parse(this.value));
    }

    @Override
    public List<Object> getArray() {
        return (List)this.dataSpecs.parse(this.value);
    }

    @Override
    public StructEntity getEntity() {
        return (StructEntity)this.dataSpecs.parse(this.value);
    }

    @Override
    public EnumEntity getEnum() {
        return (EnumEntity)this.dataSpecs.parse(this.value);
    }

    @Override
    public Object getObject() {
        return this.dataSpecs.parse(this.value);
    }

    public String toString() {
        return this.dataSpecs.toResultString(this.value);
    }

    @Override
    public Date getDate(String key) {
        Expression expression = this.parser.parseExpression(key);
        Object value = expression.getValue(this.ctx);
        IDataSpecs subDataSpecs = this.getSubDataSpecs(key, this.dataSpecs);
        return (Date)subDataSpecs.parse(value);
    }

    @Override
    public Date getDate() {
        return (Date)this.dataSpecs.parse(this.value);
    }

    protected IDataSpecs getSubDataSpecs(String key, IDataSpecs dataSpecs) {
        StructDataSpecs structDataSpecs = (StructDataSpecs)dataSpecs;
        Map<String, IDataSpecs> dataSpecsMap = structDataSpecs.getDataSpecsMap();
        if (key.startsWith("#")) {
            key = key.substring(1);
        }
        int index = key.indexOf(".");
        IDataSpecs specs = dataSpecsMap.get(key);
        if (index > 0) {
            String subKey = key.substring(0, index);
            return this.getSubDataSpecs(subKey, specs);
        }
        return specs;
    }

    public DataType getDataType() {
        return this.dataType;
    }
}

