/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.sora.lang;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import io.github.rosemoe.sora.lang.QuickQuoteHandler;
import io.github.rosemoe.sora.lang.analysis.AnalyzeManager;
import io.github.rosemoe.sora.lang.completion.CompletionCancelledException;
import io.github.rosemoe.sora.lang.completion.CompletionPublisher;
import io.github.rosemoe.sora.lang.format.Formatter;
import io.github.rosemoe.sora.lang.smartEnter.NewlineHandler;
import io.github.rosemoe.sora.text.CharPosition;
import io.github.rosemoe.sora.text.ContentReference;
import io.github.rosemoe.sora.widget.SymbolPairMatch;

public abstract class Language {
    public static final char[] DEFAULT_OPERATORS;
    public static final int INTERRUPTION_LEVEL_STRONG = 0;
    public static final int INTERRUPTION_LEVEL_SLIGHT = 1;
    public static final int INTERRUPTION_LEVEL_NONE = 2;

    public Language() {
        throw new UnsupportedOperationException();
    }

    public char[] getOperators() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public abstract AnalyzeManager getAnalyzeManager();

    public abstract int getInterruptionLevel();

    @WorkerThread
    public void requireAutoComplete(ContentReference content, CharPosition position, CompletionPublisher publisher, Bundle extraArguments) throws CompletionCancelledException {
        throw new UnsupportedOperationException();
    }

    public boolean isCompletionChar(char ch) {
        throw new UnsupportedOperationException();
    }

    @UiThread
    public abstract int getIndentAdvance(@NonNull ContentReference var1, int var2, int var3);

    @UiThread
    public abstract boolean useTab();

    @UiThread
    public abstract Formatter getFormatter();

    @UiThread
    public abstract SymbolPairMatch getSymbolPairs();

    @UiThread
    @Nullable
    public abstract NewlineHandler[] getNewlineHandlers();

    @UiThread
    @Nullable
    public QuickQuoteHandler getQuickQuoteHandler() {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        throw new UnsupportedOperationException();
    }

    static {
        throw new UnsupportedOperationException();
    }
}

