/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.internal;

import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.model.Command;
import cn.zoecloud.core.model.CommandResult;
import cn.zoecloud.core.model.CommandResultListResult;
import cn.zoecloud.core.model.CommandStatus;
import cn.zoecloud.core.model.GetGroupPageResult;
import cn.zoecloud.core.model.GetLayoutPageResult;
import cn.zoecloud.core.model.GetProgramPublishDetailResult;
import cn.zoecloud.core.model.GetProgramPublishStatusResult;
import cn.zoecloud.core.model.GetTerminalPageResult;
import cn.zoecloud.core.model.GetTerminalSingleResult;
import cn.zoecloud.core.model.Group;
import cn.zoecloud.core.model.Layout;
import cn.zoecloud.core.model.ProgramPublishResult;
import cn.zoecloud.core.model.PublishDetail;
import cn.zoecloud.core.model.PublishInfo;
import cn.zoecloud.core.model.PublishStatusInfo;
import cn.zoecloud.core.model.Terminal;
import cn.zoecloud.core.model.comm.GenericPageResult;
import cn.zoecloud.core.model.comm.ZoeCloudResponse;
import cn.zoecloud.core.parser.ResponseParseException;
import cn.zoecloud.core.parser.ResponseParser;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class ZoeCloudResponseParsers {
    public static final GetGroupPageResponseParser getGroupPageResponseParser = new GetGroupPageResponseParser();
    public static final GetTerminalSingleResponseParser getTerminalSingleResponseParser = new GetTerminalSingleResponseParser();
    public static final GetTerminalPageResponseParser getTerminalPageResponseParser = new GetTerminalPageResponseParser();
    public static final CommandResultListResponseParser commandResultListResponseParser = new CommandResultListResponseParser();
    public static final GetLayoutPageResponseParser getLayoutPageResponseParser = new GetLayoutPageResponseParser();
    public static final ProgramPublishResponseParser programPublishResponseParser = new ProgramPublishResponseParser();
    public static final GetProgramPublishStatusResponseParser getProgramPublishStatusResponseParser = new GetProgramPublishStatusResponseParser();
    public static final GetProgramPublishDetailResponseParser getProgramPublishDetailResponseParser = new GetProgramPublishDetailResponseParser();
    private static final String NODE_PAGE_CONTENT = "content";
    private static final String NODE_PAGE_NUMBER = "number";
    private static final String NODE_PAGE_SIZE = "size";
    private static final String NODE_PAGE_TOTAL_ELEMENTS = "totalElements";

    private static ZoeCloudResponse parseResponseString(String responseBody) throws ResponseParseException {
        ZoeCloudResponse response = (ZoeCloudResponse)JSONObject.parseObject((String)responseBody, ZoeCloudResponse.class);
        if (response == null) {
            throw new ResponseParseException("Unable to parse the response content.");
        }
        if (!response.isSuccess()) {
            throw new ServiceException(response.getMessage(), response.getErrorCode(), responseBody);
        }
        return response;
    }

    private static GenericPageResult parsePageInfo(ZoeCloudResponse response) throws ResponseParseException {
        JSONObject page = response.getPage();
        if (page == null) {
            throw new ResponseParseException("Node page cannot be found.");
        }
        Integer pageNumber = page.getInteger(NODE_PAGE_NUMBER);
        Integer pageSize = page.getInteger(NODE_PAGE_SIZE);
        Integer totalElements = page.getInteger(NODE_PAGE_TOTAL_ELEMENTS);
        if (pageNumber == null || pageSize == null || totalElements == null) {
            throw new ResponseParseException("Paging node data exception");
        }
        GenericPageResult genericPageResult = new GenericPageResult();
        genericPageResult.setPageNumber(pageNumber);
        genericPageResult.setPageSize(pageSize);
        genericPageResult.setTotalElements(totalElements.intValue());
        return genericPageResult;
    }

    private static CommandResult parserCommandResult(JSONObject json) throws ResponseParseException {
        Command command = Command.findOne(json.getString("command"));
        if (command == null) {
            throw new ResponseParseException("Command not found.");
        }
        CommandStatus status = CommandStatus.findOne(json.getString("status"));
        if (status == null) {
            throw new ResponseParseException("Command status exception");
        }
        CommandResult commandResult = null;
        if (status == CommandStatus.SUCCESSFUL) {
            switch (command) {
                case SCREEN_STATUS: 
                case SCREEN_CAPTURE: {
                    commandResult = (CommandResult)json.toJavaObject(CommandResult.StringExtra.class);
                    break;
                }
                case FETCH_PROGRAMS: {
                    commandResult = (CommandResult)json.toJavaObject(CommandResult.ProgramExtra.class);
                    break;
                }
                default: {
                    commandResult = (CommandResult)json.toJavaObject(CommandResult.NoneExtra.class);
                    break;
                }
            }
        } else {
            commandResult = (CommandResult)json.toJavaObject(CommandResult.NoneExtra.class);
        }
        return commandResult;
    }

    public static final class GetProgramPublishDetailResponseParser
    implements ResponseParser<GetProgramPublishDetailResult> {
        @Override
        public GetProgramPublishDetailResult parse(String responseBody) throws ResponseParseException {
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            if (response.getEntities() == null || response.getEntities().size() == 0) {
                throw new ResponseParseException("The result is empty.");
            }
            GetProgramPublishDetailResult result = new GetProgramPublishDetailResult();
            result.setEntities(response.getEntities().toJavaList(PublishDetail.class));
            return result;
        }
    }

    public static final class GetProgramPublishStatusResponseParser
    implements ResponseParser<GetProgramPublishStatusResult> {
        @Override
        public GetProgramPublishStatusResult parse(String responseBody) throws ResponseParseException {
            GetProgramPublishStatusResult result = new GetProgramPublishStatusResult();
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            if (response.getEntity() != null) {
                result.setEntity(response.getEntity().toJavaObject(PublishStatusInfo.class));
            }
            return result;
        }
    }

    public static final class ProgramPublishResponseParser
    implements ResponseParser<ProgramPublishResult> {
        @Override
        public ProgramPublishResult parse(String responseBody) throws ResponseParseException {
            ProgramPublishResult result = new ProgramPublishResult();
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            if (response.getEntity() != null) {
                result.setEntity(response.getEntity().toJavaObject(PublishInfo.class));
            }
            return result;
        }
    }

    public static final class GetLayoutPageResponseParser
    implements ResponseParser<GetLayoutPageResult> {
        @Override
        public GetLayoutPageResult parse(String responseBody) throws ResponseParseException {
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            GenericPageResult genericPageResult = ZoeCloudResponseParsers.parsePageInfo(response);
            GetLayoutPageResult result = new GetLayoutPageResult(genericPageResult);
            List layouts = response.getPage().getJSONArray(ZoeCloudResponseParsers.NODE_PAGE_CONTENT).toJavaList(Layout.class);
            result.setEntities(layouts);
            return result;
        }
    }

    public static final class CommandResultListResponseParser
    implements ResponseParser<CommandResultListResult> {
        @Override
        public CommandResultListResult parse(String responseBody) throws ResponseParseException {
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            if (response.getEntities() == null || response.getEntities().size() == 0) {
                throw new ResponseParseException("The result of commands is empty.");
            }
            ArrayList<CommandResult> entities = new ArrayList<CommandResult>();
            int len = response.getEntities().size();
            for (int i = 0; i < len; ++i) {
                JSONObject json = response.getEntities().getJSONObject(i);
                entities.add(ZoeCloudResponseParsers.parserCommandResult(json));
            }
            CommandResultListResult result = new CommandResultListResult();
            result.setEntities(entities);
            return result;
        }
    }

    public static final class GetTerminalPageResponseParser
    implements ResponseParser<GetTerminalPageResult> {
        @Override
        public GetTerminalPageResult parse(String responseBody) throws ResponseParseException {
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            GenericPageResult genericPageResult = ZoeCloudResponseParsers.parsePageInfo(response);
            GetTerminalPageResult result = new GetTerminalPageResult(genericPageResult);
            List terminals = response.getPage().getJSONArray(ZoeCloudResponseParsers.NODE_PAGE_CONTENT).toJavaList(Terminal.class);
            result.setEntities(terminals);
            return result;
        }
    }

    public static final class GetTerminalSingleResponseParser
    implements ResponseParser<GetTerminalSingleResult> {
        @Override
        public GetTerminalSingleResult parse(String responseBody) throws ResponseParseException {
            GetTerminalSingleResult result = new GetTerminalSingleResult();
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            if (response.getEntity() != null) {
                result.setEntity(response.getEntity().toJavaObject(Terminal.class));
            }
            return result;
        }
    }

    public static final class GetGroupPageResponseParser
    implements ResponseParser<GetGroupPageResult> {
        @Override
        public GetGroupPageResult parse(String responseBody) throws ResponseParseException {
            ZoeCloudResponse response = ZoeCloudResponseParsers.parseResponseString(responseBody);
            GenericPageResult genericPageResult = ZoeCloudResponseParsers.parsePageInfo(response);
            GetGroupPageResult result = new GetGroupPageResult(genericPageResult);
            List groups = response.getPage().getJSONArray(ZoeCloudResponseParsers.NODE_PAGE_CONTENT).toJavaList(Group.class);
            result.setEntities(groups);
            return result;
        }
    }
}

