/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.operation;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.internal.ZoeCloudResponseParsers;
import cn.zoecloud.core.model.BaseCommandRequest;
import cn.zoecloud.core.model.CommandCaptureScreenRequest;
import cn.zoecloud.core.model.CommandCloseScreenRequest;
import cn.zoecloud.core.model.CommandFetchProgramsRequest;
import cn.zoecloud.core.model.CommandFetchScreenStatusRequest;
import cn.zoecloud.core.model.CommandOpenScreenRequest;
import cn.zoecloud.core.model.CommandResultListResult;
import cn.zoecloud.core.model.GetCommandResultListRequest;
import cn.zoecloud.core.operation.ZoeCloudOperation;
import cn.zoecloud.core.service.HttpMethod;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ServiceClient;
import com.alibaba.fastjson.JSON;

public class ZoeCloudCommandOperation
extends ZoeCloudOperation {
    private static final String COMMAND_PATH = "/api/2.0/commands";
    private static final String COMMAND_RESULT_PATH = "/api/2.0/commands/results";
    private static final String COMMAND_OPEN_SCREEN_PATH = "/api/2.0/commands/screen/open";
    private static final String COMMAND_CLOSE_SCREEN_PATH = "/api/2.0/commands/screen/close";
    private static final String COMMAND_FETCH_SCREEN_STATUS_PATH = "/api/2.0/commands/screen/status";
    private static final String COMMAND_FETCH_PROGRAMS_PATH = "/api/2.0/commands/programs/fetch";
    private static final String COMMAND_CAPTURE_SCREEN_PATH = "/api/2.0/commands/screen/capture";

    public ZoeCloudCommandOperation(ServiceClient client, Credential credential, String endpoint) {
        super(client, credential, endpoint);
    }

    public CommandResultListResult getCommandResults(GetCommandResultListRequest getCommandResultListRequest) throws ServiceException, ClientException {
        assert (getCommandResultListRequest != null);
        assert (getCommandResultListRequest.getBody() != null);
        RequestMessage request = new RequestMessage(this.getEndpoint(), COMMAND_RESULT_PATH);
        request.setMethod(HttpMethod.POST);
        request.setBody(JSON.toJSONString((Object)getCommandResultListRequest.getBody()));
        return this.doOperation(request, ZoeCloudResponseParsers.commandResultListResponseParser);
    }

    public CommandResultListResult openScreen(CommandOpenScreenRequest commandOpenScreenRequest) throws ServiceException, ClientException {
        return this.sendSimpleRequest(commandOpenScreenRequest, COMMAND_OPEN_SCREEN_PATH);
    }

    public CommandResultListResult closeScreen(CommandCloseScreenRequest commandCloseScreenRequest) throws ServiceException, ClientException {
        return this.sendSimpleRequest(commandCloseScreenRequest, COMMAND_CLOSE_SCREEN_PATH);
    }

    public CommandResultListResult fetchScreenStatus(CommandFetchScreenStatusRequest commandFetchScreenStatusRequest) throws ServiceException, ClientException {
        return this.sendSimpleRequest(commandFetchScreenStatusRequest, COMMAND_FETCH_SCREEN_STATUS_PATH);
    }

    public CommandResultListResult fetchPrograms(CommandFetchProgramsRequest commandFetchProgramsRequest) throws ServiceException, ClientException {
        return this.sendSimpleRequest(commandFetchProgramsRequest, COMMAND_FETCH_PROGRAMS_PATH);
    }

    public CommandResultListResult captureScreen(CommandCaptureScreenRequest commandCaptureScreenRequest) throws ServiceException, ClientException {
        return this.sendSimpleRequest(commandCaptureScreenRequest, COMMAND_CAPTURE_SCREEN_PATH);
    }

    private CommandResultListResult sendSimpleRequest(BaseCommandRequest request, String commandPath) {
        this.checkRequest(request);
        RequestMessage requestMessage = new RequestMessage(this.getEndpoint(), commandPath);
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setBody(JSON.toJSONString((Object)request));
        return this.doOperation(requestMessage, ZoeCloudResponseParsers.commandResultListResponseParser);
    }

    private void checkRequest(BaseCommandRequest request) {
        assert (request != null);
        if (request.getTimeout() == null || request.getTimeout() <= 0 || request.getTimeout() > 5) {
            throw new ClientException("The timeout should be in the range of [1-5].");
        }
    }
}

