/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.operation;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.internal.ZoeCloudResponseParsers;
import cn.zoecloud.core.model.GetLayoutPageRequest;
import cn.zoecloud.core.model.GetLayoutPageResult;
import cn.zoecloud.core.model.GetProgramPublishDetailRequest;
import cn.zoecloud.core.model.GetProgramPublishDetailResult;
import cn.zoecloud.core.model.GetProgramPublishStatusRequest;
import cn.zoecloud.core.model.GetProgramPublishStatusResult;
import cn.zoecloud.core.model.ProgramPublishRequest;
import cn.zoecloud.core.model.ProgramPublishResult;
import cn.zoecloud.core.operation.ZoeCloudOperation;
import cn.zoecloud.core.service.HttpMethod;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ServiceClient;
import com.alibaba.fastjson.JSON;

public class ZoeCloudProgramOperation
extends ZoeCloudOperation {
    private static final String LAYOUT_PATH = "/api/2.0/layouts";
    private static final String PUBLISH_PATH = "/api/2.0/layouts/publish";

    public ZoeCloudProgramOperation(ServiceClient client, Credential credential, String endpoint) {
        super(client, credential, endpoint);
    }

    public GetLayoutPageResult getLayoutPage(GetLayoutPageRequest getLayoutPageRequest) throws ServiceException, ClientException {
        assert (getLayoutPageRequest != null);
        String url = String.format("%s?page=%d&size=%d", LAYOUT_PATH, getLayoutPageRequest.getPageRequest().getPageNumber(), getLayoutPageRequest.getPageRequest().getPageSize());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return this.doOperation(request, ZoeCloudResponseParsers.getLayoutPageResponseParser);
    }

    public ProgramPublishResult programPublish(ProgramPublishRequest programPublishRequest) throws ServiceException, ClientException {
        assert (programPublishRequest != null);
        RequestMessage request = new RequestMessage(this.getEndpoint(), PUBLISH_PATH);
        request.setMethod(HttpMethod.POST);
        request.setBody(JSON.toJSONString((Object)programPublishRequest));
        return this.doOperation(request, ZoeCloudResponseParsers.programPublishResponseParser);
    }

    public GetProgramPublishStatusResult getProgramPublishStatus(GetProgramPublishStatusRequest getProgramPublishStatusRequest) throws ServiceException, ClientException {
        assert (getProgramPublishStatusRequest != null);
        String url = String.format("%s/%s", PUBLISH_PATH, getProgramPublishStatusRequest.getPublishId());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return this.doOperation(request, ZoeCloudResponseParsers.getProgramPublishStatusResponseParser);
    }

    public GetProgramPublishDetailResult getProgramPublishDetail(GetProgramPublishDetailRequest getProgramPublishDetailRequest) throws ServiceException, ClientException {
        assert (getProgramPublishDetailRequest != null);
        String url = String.format("%s/%s/details", PUBLISH_PATH, getProgramPublishDetailRequest.getPublishId());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return this.doOperation(request, ZoeCloudResponseParsers.getProgramPublishDetailResponseParser);
    }
}

