/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.service;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.service.HttpMethod;
import cn.zoecloud.core.service.RequestMessage;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class HttpRequestFactory {
    public HttpRequestBase createHttpRequest(RequestMessage request) {
        HttpPost httpRequest;
        String url = request.getUrl();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)request.getBody())) {
                postMethod.setEntity((HttpEntity)new StringEntity(request.getBody(), "utf-8"));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(url);
            if (StringUtils.isNotBlank((CharSequence)request.getBody())) {
                putMethod.setEntity((HttpEntity)new StringEntity(request.getBody(), "utf-8"));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(url);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(url);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(url);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(url);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }
}

