/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.service;

import cn.zoecloud.core.service.HttpMethod;
import cn.zoecloud.core.util.HttpUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class RequestMessage {
    private String endpoint;
    private String resourcePath;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String body;
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public RequestMessage(String endpoint, String resourcePath) {
        this.endpoint = endpoint;
        this.resourcePath = resourcePath;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getUrl() {
        String paramString = HttpUtil.paramToQueryString(this.parameters, "utf-8");
        if (StringUtils.isBlank((CharSequence)paramString)) {
            return String.format("%s%s", this.endpoint, this.resourcePath);
        }
        return String.format("%s%s?%s", this.endpoint, this.resourcePath, paramString);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

