/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.util;

import cn.zoecloud.core.util.LogUtil;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfoUtil {
    private static final String VERSION_INFO_FILE = "versioninfo.properties";
    private static final String USER_AGENT_PREFIX = "zoecloud-sdk-java";
    private static String version = null;
    private static String defaultUserAgent = null;

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtil.initializeVersion();
        }
        return version;
    }

    public static String getDefaultUserAgent() {
        if (defaultUserAgent == null) {
            defaultUserAgent = "zoecloud-sdk-java/" + VersionInfoUtil.getVersion() + "(" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + ";" + System.getProperty("java.version") + ")";
        }
        return defaultUserAgent;
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtil.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new IllegalArgumentException("versioninfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            LogUtil.logException("Unable to load version information for the running SDK: ", e);
            version = "unknown-version";
        }
    }
}

