/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core;

import cn.zoecloud.core.ClientConfiguration;
import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.ZoeCloud;
import cn.zoecloud.core.auth.CredentialProvider;
import cn.zoecloud.core.auth.DefaultCredentialProvider;
import cn.zoecloud.core.model.CommandCaptureScreenRequest;
import cn.zoecloud.core.model.CommandCloseScreenRequest;
import cn.zoecloud.core.model.CommandFetchProgramsRequest;
import cn.zoecloud.core.model.CommandFetchScreenStatusRequest;
import cn.zoecloud.core.model.CommandOpenScreenRequest;
import cn.zoecloud.core.model.CommandResultListResult;
import cn.zoecloud.core.model.GetCommandResultListRequest;
import cn.zoecloud.core.model.GetGroupPageRequest;
import cn.zoecloud.core.model.GetGroupPageResult;
import cn.zoecloud.core.model.GetLayoutPageRequest;
import cn.zoecloud.core.model.GetLayoutPageResult;
import cn.zoecloud.core.model.GetProgramPublishDetailRequest;
import cn.zoecloud.core.model.GetProgramPublishDetailResult;
import cn.zoecloud.core.model.GetProgramPublishStatusRequest;
import cn.zoecloud.core.model.GetProgramPublishStatusResult;
import cn.zoecloud.core.model.GetTerminalPageRequest;
import cn.zoecloud.core.model.GetTerminalPageResult;
import cn.zoecloud.core.model.GetTerminalSingleRequest;
import cn.zoecloud.core.model.GetTerminalSingleResult;
import cn.zoecloud.core.model.ProgramPublishRequest;
import cn.zoecloud.core.model.ProgramPublishResult;
import cn.zoecloud.core.operation.ZoeCloudCommandOperation;
import cn.zoecloud.core.operation.ZoeCloudGroupOperation;
import cn.zoecloud.core.operation.ZoeCloudProgramOperation;
import cn.zoecloud.core.operation.ZoeCloudTerminalOperation;
import cn.zoecloud.core.service.ServiceClient;
import cn.zoecloud.core.util.LogUtil;

public class ZoeCloudClient
implements ZoeCloud {
    private CredentialProvider credentialProvider;
    private String endpoint;
    private ServiceClient serviceClient;
    private ZoeCloudGroupOperation groupOperation;
    private ZoeCloudTerminalOperation terminalOperation;
    private ZoeCloudCommandOperation commandOperation;
    private ZoeCloudProgramOperation programOperation;

    public ZoeCloudClient(String appKey, String appSecret) {
        this("http://api.zoecloud.cn/zcc", new DefaultCredentialProvider(appKey, appSecret), new ClientConfiguration());
    }

    public ZoeCloudClient(String endpoint, String appKey, String appSecret) {
        this(endpoint, new DefaultCredentialProvider(appKey, appSecret), new ClientConfiguration());
    }

    public ZoeCloudClient(String endpoint, CredentialProvider credentialProvider, ClientConfiguration config) {
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.serviceClient = new ServiceClient(config);
        this.initOperations();
    }

    @Override
    public GetGroupPageResult getGroupPage(GetGroupPageRequest request) throws ServiceException, ClientException {
        return this.groupOperation.getGroupPage(request);
    }

    @Override
    public GetTerminalSingleResult getTerminal(GetTerminalSingleRequest request) throws ServiceException, ClientException {
        return this.terminalOperation.getTerminal(request);
    }

    @Override
    public GetTerminalPageResult getTerminalPage(GetTerminalPageRequest request) throws ServiceException, ClientException {
        return this.terminalOperation.getTerminalPage(request);
    }

    @Override
    public CommandResultListResult getCommandResultList(GetCommandResultListRequest request) throws ServiceException, ClientException {
        return this.commandOperation.getCommandResults(request);
    }

    @Override
    public CommandResultListResult commandOpenScreen(CommandOpenScreenRequest request) throws ServiceException, ClientException {
        return this.commandOperation.openScreen(request);
    }

    @Override
    public CommandResultListResult commandCloseScreen(CommandCloseScreenRequest request) throws ServiceException, ClientException {
        return this.commandOperation.closeScreen(request);
    }

    @Override
    public CommandResultListResult commandFetchScreenStatus(CommandFetchScreenStatusRequest request) throws ServiceException, ClientException {
        return this.commandOperation.fetchScreenStatus(request);
    }

    @Override
    public CommandResultListResult commandFetchPrograms(CommandFetchProgramsRequest request) throws ServiceException, ClientException {
        return this.commandOperation.fetchPrograms(request);
    }

    @Override
    public CommandResultListResult commandCaptureScreen(CommandCaptureScreenRequest request) throws ServiceException, ClientException {
        return this.commandOperation.captureScreen(request);
    }

    @Override
    public GetLayoutPageResult getLayoutPage(GetLayoutPageRequest request) throws ServiceException, ClientException {
        return this.programOperation.getLayoutPage(request);
    }

    @Override
    public ProgramPublishResult programPublish(ProgramPublishRequest request) throws ServiceException, ClientException {
        return this.programOperation.programPublish(request);
    }

    @Override
    public GetProgramPublishStatusResult getProgramPublishStatus(GetProgramPublishStatusRequest request) throws ServiceException, ClientException {
        return this.programOperation.getProgramPublishStatus(request);
    }

    @Override
    public GetProgramPublishDetailResult getProgramPublishDetail(GetProgramPublishDetailRequest request) throws ServiceException, ClientException {
        return this.programOperation.getProgramPublishDetail(request);
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            LogUtil.logException("shutdown throw exception: ", e);
        }
    }

    private void initOperations() {
        this.groupOperation = new ZoeCloudGroupOperation(this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.terminalOperation = new ZoeCloudTerminalOperation(this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.commandOperation = new ZoeCloudCommandOperation(this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.programOperation = new ZoeCloudProgramOperation(this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
    }
}

